/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Mode;
import com.atlan.model.assets.ModeQuery;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class ModeChart
extends Mode {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeChart";
    String typeName;
    @Attribute
    String modeChartType;
    @Attribute
    ModeQuery modeQuery;

    public static ModeChart refByGuid(String guid) {
        return ((ModeChartBuilder)ModeChart.builder().guid(guid)).build();
    }

    public static ModeChart refByQualifiedName(String qualifiedName) {
        return ((ModeChartBuilder)ModeChart.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ModeChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeChartBuilder)((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ModeChartBuilder<?, ?> trimToRequired() {
        return ModeChart.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeChart retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ModeChart) {
            return (ModeChart)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ModeChart.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ModeChart retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ModeChart) {
            return (ModeChart)entity;
        }
        throw new NotFoundException("No ModeChart found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ModeChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeDescription(((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeUserDescription(((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeOwners(((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeChart updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ModeChart)Asset.updateCertificate(ModeChart.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeCertificate(((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeChart)Asset.updateAnnouncement(ModeChart.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeAnnouncement(((ModeChartBuilder)ModeChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ModeChart replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.replaceTerms(ModeChart.updater(qualifiedName, name), terms);
    }

    public static ModeChart appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ModeChart removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeChart(ModeChartBuilder<?, ?> b) {
        super((Mode.ModeBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeChart.$default$typeName();
        this.modeChartType = b.modeChartType;
        this.modeQuery = b.modeQuery;
    }

    @Generated
    public static ModeChartBuilder<?, ?> builder() {
        return new ModeChartBuilderImpl();
    }

    @Generated
    public ModeChartBuilder<?, ?> toBuilder() {
        return new ModeChartBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getModeChartType() {
        return this.modeChartType;
    }

    @Generated
    public ModeQuery getModeQuery() {
        return this.modeQuery;
    }

    @Generated
    public void setModeChartType(String modeChartType) {
        this.modeChartType = modeChartType;
    }

    @Generated
    public void setModeQuery(ModeQuery modeQuery) {
        this.modeQuery = modeQuery;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeChart)) {
            return false;
        }
        ModeChart other = (ModeChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$modeChartType = this.getModeChartType();
        String other$modeChartType = other.getModeChartType();
        if (this$modeChartType == null ? other$modeChartType != null : !this$modeChartType.equals(other$modeChartType)) {
            return false;
        }
        ModeQuery this$modeQuery = this.getModeQuery();
        ModeQuery other$modeQuery = other.getModeQuery();
        return !(this$modeQuery == null ? other$modeQuery != null : !((Object)this$modeQuery).equals(other$modeQuery));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeChart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $modeChartType = this.getModeChartType();
        result = result * 59 + ($modeChartType == null ? 43 : $modeChartType.hashCode());
        ModeQuery $modeQuery = this.getModeQuery();
        result = result * 59 + ($modeQuery == null ? 43 : ((Object)$modeQuery).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ModeChartBuilderImpl
    extends ModeChartBuilder<ModeChart, ModeChartBuilderImpl> {
        @Generated
        private ModeChartBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeChartBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeChart build() {
            return new ModeChart(this);
        }
    }

    @Generated
    public static abstract class ModeChartBuilder<C extends ModeChart, B extends ModeChartBuilder<C, B>>
    extends Mode.ModeBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String modeChartType;
        @Generated
        private ModeQuery modeQuery;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeChart instance, ModeChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.modeChartType(instance.modeChartType);
            b.modeQuery(instance.modeQuery);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B modeChartType(String modeChartType) {
            this.modeChartType = modeChartType;
            return (B)this.self();
        }

        @Generated
        public B modeQuery(ModeQuery modeQuery) {
            this.modeQuery = modeQuery;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeChart.ModeChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", modeChartType=" + this.modeChartType + ", modeQuery=" + this.modeQuery + ")";
        }
    }
}

