/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Mode;
import com.atlan.model.assets.ModeReport;
import com.atlan.model.assets.ModeWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class ModeCollection
extends Mode {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeCollection";
    String typeName;
    @Attribute
    String modeCollectionType;
    @Attribute
    String modeCollectionState;
    @Attribute
    ModeWorkspace modeWorkspace;
    @Attribute
    SortedSet<ModeReport> modeReports;

    public static ModeCollection refByGuid(String guid) {
        return ((ModeCollectionBuilder)ModeCollection.builder().guid(guid)).build();
    }

    public static ModeCollection refByQualifiedName(String qualifiedName) {
        return ((ModeCollectionBuilder)ModeCollection.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ModeCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeCollectionBuilder)((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ModeCollectionBuilder<?, ?> trimToRequired() {
        return ModeCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeCollection retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ModeCollection) {
            return (ModeCollection)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ModeCollection.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ModeCollection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ModeCollection) {
            return (ModeCollection)entity;
        }
        throw new NotFoundException("No ModeCollection found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ModeCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeDescription(((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeUserDescription(((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeOwners(((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeCollection updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ModeCollection)Asset.updateCertificate(ModeCollection.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeCertificate(((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeCollection)Asset.updateAnnouncement(ModeCollection.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeAnnouncement(((ModeCollectionBuilder)ModeCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ModeCollection replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.replaceTerms(ModeCollection.updater(qualifiedName, name), terms);
    }

    public static ModeCollection appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ModeCollection removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeCollection(ModeCollectionBuilder<?, ?> b) {
        super((Mode.ModeBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeCollection.$default$typeName();
        this.modeCollectionType = b.modeCollectionType;
        this.modeCollectionState = b.modeCollectionState;
        this.modeWorkspace = b.modeWorkspace;
        SortedSet<ModeReport> modeReports = new TreeSet<ModeReport>();
        if (b.modeReports != null) {
            modeReports.addAll(b.modeReports);
        }
        modeReports = Collections.unmodifiableSortedSet(modeReports);
        this.modeReports = modeReports;
    }

    @Generated
    public static ModeCollectionBuilder<?, ?> builder() {
        return new ModeCollectionBuilderImpl();
    }

    @Generated
    public ModeCollectionBuilder<?, ?> toBuilder() {
        return new ModeCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getModeCollectionType() {
        return this.modeCollectionType;
    }

    @Generated
    public String getModeCollectionState() {
        return this.modeCollectionState;
    }

    @Generated
    public ModeWorkspace getModeWorkspace() {
        return this.modeWorkspace;
    }

    @Generated
    public SortedSet<ModeReport> getModeReports() {
        return this.modeReports;
    }

    @Generated
    public void setModeCollectionType(String modeCollectionType) {
        this.modeCollectionType = modeCollectionType;
    }

    @Generated
    public void setModeCollectionState(String modeCollectionState) {
        this.modeCollectionState = modeCollectionState;
    }

    @Generated
    public void setModeWorkspace(ModeWorkspace modeWorkspace) {
        this.modeWorkspace = modeWorkspace;
    }

    @Generated
    public void setModeReports(SortedSet<ModeReport> modeReports) {
        this.modeReports = modeReports;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeCollection)) {
            return false;
        }
        ModeCollection other = (ModeCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$modeCollectionType = this.getModeCollectionType();
        String other$modeCollectionType = other.getModeCollectionType();
        if (this$modeCollectionType == null ? other$modeCollectionType != null : !this$modeCollectionType.equals(other$modeCollectionType)) {
            return false;
        }
        String this$modeCollectionState = this.getModeCollectionState();
        String other$modeCollectionState = other.getModeCollectionState();
        if (this$modeCollectionState == null ? other$modeCollectionState != null : !this$modeCollectionState.equals(other$modeCollectionState)) {
            return false;
        }
        ModeWorkspace this$modeWorkspace = this.getModeWorkspace();
        ModeWorkspace other$modeWorkspace = other.getModeWorkspace();
        if (this$modeWorkspace == null ? other$modeWorkspace != null : !((Object)this$modeWorkspace).equals(other$modeWorkspace)) {
            return false;
        }
        SortedSet<ModeReport> this$modeReports = this.getModeReports();
        SortedSet<ModeReport> other$modeReports = other.getModeReports();
        return !(this$modeReports == null ? other$modeReports != null : !this$modeReports.equals(other$modeReports));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $modeCollectionType = this.getModeCollectionType();
        result = result * 59 + ($modeCollectionType == null ? 43 : $modeCollectionType.hashCode());
        String $modeCollectionState = this.getModeCollectionState();
        result = result * 59 + ($modeCollectionState == null ? 43 : $modeCollectionState.hashCode());
        ModeWorkspace $modeWorkspace = this.getModeWorkspace();
        result = result * 59 + ($modeWorkspace == null ? 43 : ((Object)$modeWorkspace).hashCode());
        SortedSet<ModeReport> $modeReports = this.getModeReports();
        result = result * 59 + ($modeReports == null ? 43 : $modeReports.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ModeCollectionBuilderImpl
    extends ModeCollectionBuilder<ModeCollection, ModeCollectionBuilderImpl> {
        @Generated
        private ModeCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeCollection build() {
            return new ModeCollection(this);
        }
    }

    @Generated
    public static abstract class ModeCollectionBuilder<C extends ModeCollection, B extends ModeCollectionBuilder<C, B>>
    extends Mode.ModeBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String modeCollectionType;
        @Generated
        private String modeCollectionState;
        @Generated
        private ModeWorkspace modeWorkspace;
        @Generated
        private ArrayList<ModeReport> modeReports;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeCollection instance, ModeCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.modeCollectionType(instance.modeCollectionType);
            b.modeCollectionState(instance.modeCollectionState);
            b.modeWorkspace(instance.modeWorkspace);
            b.modeReports(instance.modeReports == null ? Collections.emptySortedSet() : instance.modeReports);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionType(String modeCollectionType) {
            this.modeCollectionType = modeCollectionType;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionState(String modeCollectionState) {
            this.modeCollectionState = modeCollectionState;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspace(ModeWorkspace modeWorkspace) {
            this.modeWorkspace = modeWorkspace;
            return (B)this.self();
        }

        @Generated
        public B modeReport(ModeReport modeReport) {
            if (this.modeReports == null) {
                this.modeReports = new ArrayList();
            }
            this.modeReports.add(modeReport);
            return (B)this.self();
        }

        @Generated
        public B modeReports(Collection<? extends ModeReport> modeReports) {
            if (modeReports == null) {
                throw new NullPointerException("modeReports cannot be null");
            }
            if (this.modeReports == null) {
                this.modeReports = new ArrayList();
            }
            this.modeReports.addAll(modeReports);
            return (B)this.self();
        }

        @Generated
        public B clearModeReports() {
            if (this.modeReports != null) {
                this.modeReports.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeCollection.ModeCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", modeCollectionType=" + this.modeCollectionType + ", modeCollectionState=" + this.modeCollectionState + ", modeWorkspace=" + this.modeWorkspace + ", modeReports=" + this.modeReports + ")";
        }
    }
}

