/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Mode;
import com.atlan.model.assets.ModeChart;
import com.atlan.model.assets.ModeReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class ModeQuery
extends Mode {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeQuery";
    String typeName;
    @Attribute
    String modeRawQuery;
    @Attribute
    Long modeReportImportCount;
    @Attribute
    SortedSet<ModeChart> modeCharts;
    @Attribute
    ModeReport modeReport;

    public static ModeQuery refByGuid(String guid) {
        return ((ModeQueryBuilder)ModeQuery.builder().guid(guid)).build();
    }

    public static ModeQuery refByQualifiedName(String qualifiedName) {
        return ((ModeQueryBuilder)ModeQuery.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ModeQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeQueryBuilder)((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ModeQueryBuilder<?, ?> trimToRequired() {
        return ModeQuery.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeQuery retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ModeQuery) {
            return (ModeQuery)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ModeQuery.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ModeQuery retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ModeQuery) {
            return (ModeQuery)entity;
        }
        throw new NotFoundException("No ModeQuery found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ModeQuery removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeQuery)Asset.removeDescription(((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeQuery removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeQuery)Asset.removeUserDescription(((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeQuery removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ModeQuery)Asset.removeOwners(((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeQuery updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ModeQuery)Asset.updateCertificate(ModeQuery.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeQuery removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ModeQuery)Asset.removeCertificate(((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeQuery updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeQuery)Asset.updateAnnouncement(ModeQuery.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeQuery removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ModeQuery)Asset.removeAnnouncement(((ModeQueryBuilder)ModeQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ModeQuery replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeQuery)Asset.replaceTerms(ModeQuery.updater(qualifiedName, name), terms);
    }

    public static ModeQuery appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeQuery)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ModeQuery removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeQuery)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeQuery(ModeQueryBuilder<?, ?> b) {
        super((Mode.ModeBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeQuery.$default$typeName();
        this.modeRawQuery = b.modeRawQuery;
        this.modeReportImportCount = b.modeReportImportCount;
        SortedSet<ModeChart> modeCharts = new TreeSet<ModeChart>();
        if (b.modeCharts != null) {
            modeCharts.addAll(b.modeCharts);
        }
        modeCharts = Collections.unmodifiableSortedSet(modeCharts);
        this.modeCharts = modeCharts;
        this.modeReport = b.modeReport;
    }

    @Generated
    public static ModeQueryBuilder<?, ?> builder() {
        return new ModeQueryBuilderImpl();
    }

    @Generated
    public ModeQueryBuilder<?, ?> toBuilder() {
        return new ModeQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getModeRawQuery() {
        return this.modeRawQuery;
    }

    @Generated
    public Long getModeReportImportCount() {
        return this.modeReportImportCount;
    }

    @Generated
    public SortedSet<ModeChart> getModeCharts() {
        return this.modeCharts;
    }

    @Generated
    public ModeReport getModeReport() {
        return this.modeReport;
    }

    @Generated
    public void setModeRawQuery(String modeRawQuery) {
        this.modeRawQuery = modeRawQuery;
    }

    @Generated
    public void setModeReportImportCount(Long modeReportImportCount) {
        this.modeReportImportCount = modeReportImportCount;
    }

    @Generated
    public void setModeCharts(SortedSet<ModeChart> modeCharts) {
        this.modeCharts = modeCharts;
    }

    @Generated
    public void setModeReport(ModeReport modeReport) {
        this.modeReport = modeReport;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeQuery)) {
            return false;
        }
        ModeQuery other = (ModeQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modeReportImportCount = this.getModeReportImportCount();
        Long other$modeReportImportCount = other.getModeReportImportCount();
        if (this$modeReportImportCount == null ? other$modeReportImportCount != null : !((Object)this$modeReportImportCount).equals(other$modeReportImportCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$modeRawQuery = this.getModeRawQuery();
        String other$modeRawQuery = other.getModeRawQuery();
        if (this$modeRawQuery == null ? other$modeRawQuery != null : !this$modeRawQuery.equals(other$modeRawQuery)) {
            return false;
        }
        SortedSet<ModeChart> this$modeCharts = this.getModeCharts();
        SortedSet<ModeChart> other$modeCharts = other.getModeCharts();
        if (this$modeCharts == null ? other$modeCharts != null : !this$modeCharts.equals(other$modeCharts)) {
            return false;
        }
        ModeReport this$modeReport = this.getModeReport();
        ModeReport other$modeReport = other.getModeReport();
        return !(this$modeReport == null ? other$modeReport != null : !((Object)this$modeReport).equals(other$modeReport));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modeReportImportCount = this.getModeReportImportCount();
        result = result * 59 + ($modeReportImportCount == null ? 43 : ((Object)$modeReportImportCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $modeRawQuery = this.getModeRawQuery();
        result = result * 59 + ($modeRawQuery == null ? 43 : $modeRawQuery.hashCode());
        SortedSet<ModeChart> $modeCharts = this.getModeCharts();
        result = result * 59 + ($modeCharts == null ? 43 : $modeCharts.hashCode());
        ModeReport $modeReport = this.getModeReport();
        result = result * 59 + ($modeReport == null ? 43 : ((Object)$modeReport).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ModeQueryBuilderImpl
    extends ModeQueryBuilder<ModeQuery, ModeQueryBuilderImpl> {
        @Generated
        private ModeQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeQuery build() {
            return new ModeQuery(this);
        }
    }

    @Generated
    public static abstract class ModeQueryBuilder<C extends ModeQuery, B extends ModeQueryBuilder<C, B>>
    extends Mode.ModeBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String modeRawQuery;
        @Generated
        private Long modeReportImportCount;
        @Generated
        private ArrayList<ModeChart> modeCharts;
        @Generated
        private ModeReport modeReport;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeQuery instance, ModeQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.modeRawQuery(instance.modeRawQuery);
            b.modeReportImportCount(instance.modeReportImportCount);
            b.modeCharts(instance.modeCharts == null ? Collections.emptySortedSet() : instance.modeCharts);
            b.modeReport(instance.modeReport);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B modeRawQuery(String modeRawQuery) {
            this.modeRawQuery = modeRawQuery;
            return (B)this.self();
        }

        @Generated
        public B modeReportImportCount(Long modeReportImportCount) {
            this.modeReportImportCount = modeReportImportCount;
            return (B)this.self();
        }

        @Generated
        public B modeChart(ModeChart modeChart) {
            if (this.modeCharts == null) {
                this.modeCharts = new ArrayList();
            }
            this.modeCharts.add(modeChart);
            return (B)this.self();
        }

        @Generated
        public B modeCharts(Collection<? extends ModeChart> modeCharts) {
            if (modeCharts == null) {
                throw new NullPointerException("modeCharts cannot be null");
            }
            if (this.modeCharts == null) {
                this.modeCharts = new ArrayList();
            }
            this.modeCharts.addAll(modeCharts);
            return (B)this.self();
        }

        @Generated
        public B clearModeCharts() {
            if (this.modeCharts != null) {
                this.modeCharts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeReport(ModeReport modeReport) {
            this.modeReport = modeReport;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeQuery.ModeQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", modeRawQuery=" + this.modeRawQuery + ", modeReportImportCount=" + this.modeReportImportCount + ", modeCharts=" + this.modeCharts + ", modeReport=" + this.modeReport + ")";
        }
    }
}

