/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Mode;
import com.atlan.model.assets.ModeCollection;
import com.atlan.model.assets.ModeQuery;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class ModeReport
extends Mode {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeReport";
    String typeName;
    @Attribute
    String modeCollectionToken;
    @Attribute
    Long modeReportPublishedAt;
    @Attribute
    Long modeQueryCount;
    @Attribute
    Long modeChartCount;
    @Attribute
    String modeQueryPreview;
    @Attribute
    Boolean modeIsPublic;
    @Attribute
    Boolean modeIsShared;
    @Attribute
    SortedSet<ModeCollection> modeCollections;
    @Attribute
    SortedSet<ModeQuery> modeQueries;

    public static ModeReport refByGuid(String guid) {
        return ((ModeReportBuilder)ModeReport.builder().guid(guid)).build();
    }

    public static ModeReport refByQualifiedName(String qualifiedName) {
        return ((ModeReportBuilder)ModeReport.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ModeReportBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeReportBuilder)((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ModeReportBuilder<?, ?> trimToRequired() {
        return ModeReport.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeReport retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ModeReport) {
            return (ModeReport)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ModeReport.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ModeReport retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ModeReport) {
            return (ModeReport)entity;
        }
        throw new NotFoundException("No ModeReport found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ModeReport removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeDescription(((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeReport removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeUserDescription(((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeReport removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeOwners(((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeReport updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ModeReport)Asset.updateCertificate(ModeReport.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeReport removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeCertificate(((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeReport updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeReport)Asset.updateAnnouncement(ModeReport.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeReport removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ModeReport)Asset.removeAnnouncement(((ModeReportBuilder)ModeReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ModeReport replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.replaceTerms(ModeReport.updater(qualifiedName, name), terms);
    }

    public static ModeReport appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ModeReport removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeReport)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeReport(ModeReportBuilder<?, ?> b) {
        super((Mode.ModeBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeReport.$default$typeName();
        this.modeCollectionToken = b.modeCollectionToken;
        this.modeReportPublishedAt = b.modeReportPublishedAt;
        this.modeQueryCount = b.modeQueryCount;
        this.modeChartCount = b.modeChartCount;
        this.modeQueryPreview = b.modeQueryPreview;
        this.modeIsPublic = b.modeIsPublic;
        this.modeIsShared = b.modeIsShared;
        SortedSet<ModeCollection> modeCollections = new TreeSet<ModeCollection>();
        if (b.modeCollections != null) {
            modeCollections.addAll(b.modeCollections);
        }
        modeCollections = Collections.unmodifiableSortedSet(modeCollections);
        this.modeCollections = modeCollections;
        SortedSet<ModeQuery> modeQueries = new TreeSet<ModeQuery>();
        if (b.modeQueries != null) {
            modeQueries.addAll(b.modeQueries);
        }
        modeQueries = Collections.unmodifiableSortedSet(modeQueries);
        this.modeQueries = modeQueries;
    }

    @Generated
    public static ModeReportBuilder<?, ?> builder() {
        return new ModeReportBuilderImpl();
    }

    @Generated
    public ModeReportBuilder<?, ?> toBuilder() {
        return new ModeReportBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getModeCollectionToken() {
        return this.modeCollectionToken;
    }

    @Generated
    public Long getModeReportPublishedAt() {
        return this.modeReportPublishedAt;
    }

    @Generated
    public Long getModeQueryCount() {
        return this.modeQueryCount;
    }

    @Generated
    public Long getModeChartCount() {
        return this.modeChartCount;
    }

    @Generated
    public String getModeQueryPreview() {
        return this.modeQueryPreview;
    }

    @Generated
    public Boolean getModeIsPublic() {
        return this.modeIsPublic;
    }

    @Generated
    public Boolean getModeIsShared() {
        return this.modeIsShared;
    }

    @Generated
    public SortedSet<ModeCollection> getModeCollections() {
        return this.modeCollections;
    }

    @Generated
    public SortedSet<ModeQuery> getModeQueries() {
        return this.modeQueries;
    }

    @Generated
    public void setModeCollectionToken(String modeCollectionToken) {
        this.modeCollectionToken = modeCollectionToken;
    }

    @Generated
    public void setModeReportPublishedAt(Long modeReportPublishedAt) {
        this.modeReportPublishedAt = modeReportPublishedAt;
    }

    @Generated
    public void setModeQueryCount(Long modeQueryCount) {
        this.modeQueryCount = modeQueryCount;
    }

    @Generated
    public void setModeChartCount(Long modeChartCount) {
        this.modeChartCount = modeChartCount;
    }

    @Generated
    public void setModeQueryPreview(String modeQueryPreview) {
        this.modeQueryPreview = modeQueryPreview;
    }

    @Generated
    public void setModeIsPublic(Boolean modeIsPublic) {
        this.modeIsPublic = modeIsPublic;
    }

    @Generated
    public void setModeIsShared(Boolean modeIsShared) {
        this.modeIsShared = modeIsShared;
    }

    @Generated
    public void setModeCollections(SortedSet<ModeCollection> modeCollections) {
        this.modeCollections = modeCollections;
    }

    @Generated
    public void setModeQueries(SortedSet<ModeQuery> modeQueries) {
        this.modeQueries = modeQueries;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeReport)) {
            return false;
        }
        ModeReport other = (ModeReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modeReportPublishedAt = this.getModeReportPublishedAt();
        Long other$modeReportPublishedAt = other.getModeReportPublishedAt();
        if (this$modeReportPublishedAt == null ? other$modeReportPublishedAt != null : !((Object)this$modeReportPublishedAt).equals(other$modeReportPublishedAt)) {
            return false;
        }
        Long this$modeQueryCount = this.getModeQueryCount();
        Long other$modeQueryCount = other.getModeQueryCount();
        if (this$modeQueryCount == null ? other$modeQueryCount != null : !((Object)this$modeQueryCount).equals(other$modeQueryCount)) {
            return false;
        }
        Long this$modeChartCount = this.getModeChartCount();
        Long other$modeChartCount = other.getModeChartCount();
        if (this$modeChartCount == null ? other$modeChartCount != null : !((Object)this$modeChartCount).equals(other$modeChartCount)) {
            return false;
        }
        Boolean this$modeIsPublic = this.getModeIsPublic();
        Boolean other$modeIsPublic = other.getModeIsPublic();
        if (this$modeIsPublic == null ? other$modeIsPublic != null : !((Object)this$modeIsPublic).equals(other$modeIsPublic)) {
            return false;
        }
        Boolean this$modeIsShared = this.getModeIsShared();
        Boolean other$modeIsShared = other.getModeIsShared();
        if (this$modeIsShared == null ? other$modeIsShared != null : !((Object)this$modeIsShared).equals(other$modeIsShared)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$modeCollectionToken = this.getModeCollectionToken();
        String other$modeCollectionToken = other.getModeCollectionToken();
        if (this$modeCollectionToken == null ? other$modeCollectionToken != null : !this$modeCollectionToken.equals(other$modeCollectionToken)) {
            return false;
        }
        String this$modeQueryPreview = this.getModeQueryPreview();
        String other$modeQueryPreview = other.getModeQueryPreview();
        if (this$modeQueryPreview == null ? other$modeQueryPreview != null : !this$modeQueryPreview.equals(other$modeQueryPreview)) {
            return false;
        }
        SortedSet<ModeCollection> this$modeCollections = this.getModeCollections();
        SortedSet<ModeCollection> other$modeCollections = other.getModeCollections();
        if (this$modeCollections == null ? other$modeCollections != null : !this$modeCollections.equals(other$modeCollections)) {
            return false;
        }
        SortedSet<ModeQuery> this$modeQueries = this.getModeQueries();
        SortedSet<ModeQuery> other$modeQueries = other.getModeQueries();
        return !(this$modeQueries == null ? other$modeQueries != null : !this$modeQueries.equals(other$modeQueries));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeReport;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modeReportPublishedAt = this.getModeReportPublishedAt();
        result = result * 59 + ($modeReportPublishedAt == null ? 43 : ((Object)$modeReportPublishedAt).hashCode());
        Long $modeQueryCount = this.getModeQueryCount();
        result = result * 59 + ($modeQueryCount == null ? 43 : ((Object)$modeQueryCount).hashCode());
        Long $modeChartCount = this.getModeChartCount();
        result = result * 59 + ($modeChartCount == null ? 43 : ((Object)$modeChartCount).hashCode());
        Boolean $modeIsPublic = this.getModeIsPublic();
        result = result * 59 + ($modeIsPublic == null ? 43 : ((Object)$modeIsPublic).hashCode());
        Boolean $modeIsShared = this.getModeIsShared();
        result = result * 59 + ($modeIsShared == null ? 43 : ((Object)$modeIsShared).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $modeCollectionToken = this.getModeCollectionToken();
        result = result * 59 + ($modeCollectionToken == null ? 43 : $modeCollectionToken.hashCode());
        String $modeQueryPreview = this.getModeQueryPreview();
        result = result * 59 + ($modeQueryPreview == null ? 43 : $modeQueryPreview.hashCode());
        SortedSet<ModeCollection> $modeCollections = this.getModeCollections();
        result = result * 59 + ($modeCollections == null ? 43 : $modeCollections.hashCode());
        SortedSet<ModeQuery> $modeQueries = this.getModeQueries();
        result = result * 59 + ($modeQueries == null ? 43 : $modeQueries.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ModeReportBuilderImpl
    extends ModeReportBuilder<ModeReport, ModeReportBuilderImpl> {
        @Generated
        private ModeReportBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeReportBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeReport build() {
            return new ModeReport(this);
        }
    }

    @Generated
    public static abstract class ModeReportBuilder<C extends ModeReport, B extends ModeReportBuilder<C, B>>
    extends Mode.ModeBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String modeCollectionToken;
        @Generated
        private Long modeReportPublishedAt;
        @Generated
        private Long modeQueryCount;
        @Generated
        private Long modeChartCount;
        @Generated
        private String modeQueryPreview;
        @Generated
        private Boolean modeIsPublic;
        @Generated
        private Boolean modeIsShared;
        @Generated
        private ArrayList<ModeCollection> modeCollections;
        @Generated
        private ArrayList<ModeQuery> modeQueries;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeReportBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeReport instance, ModeReportBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.modeCollectionToken(instance.modeCollectionToken);
            b.modeReportPublishedAt(instance.modeReportPublishedAt);
            b.modeQueryCount(instance.modeQueryCount);
            b.modeChartCount(instance.modeChartCount);
            b.modeQueryPreview(instance.modeQueryPreview);
            b.modeIsPublic(instance.modeIsPublic);
            b.modeIsShared(instance.modeIsShared);
            b.modeCollections(instance.modeCollections == null ? Collections.emptySortedSet() : instance.modeCollections);
            b.modeQueries(instance.modeQueries == null ? Collections.emptySortedSet() : instance.modeQueries);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionToken(String modeCollectionToken) {
            this.modeCollectionToken = modeCollectionToken;
            return (B)this.self();
        }

        @Generated
        public B modeReportPublishedAt(Long modeReportPublishedAt) {
            this.modeReportPublishedAt = modeReportPublishedAt;
            return (B)this.self();
        }

        @Generated
        public B modeQueryCount(Long modeQueryCount) {
            this.modeQueryCount = modeQueryCount;
            return (B)this.self();
        }

        @Generated
        public B modeChartCount(Long modeChartCount) {
            this.modeChartCount = modeChartCount;
            return (B)this.self();
        }

        @Generated
        public B modeQueryPreview(String modeQueryPreview) {
            this.modeQueryPreview = modeQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B modeIsPublic(Boolean modeIsPublic) {
            this.modeIsPublic = modeIsPublic;
            return (B)this.self();
        }

        @Generated
        public B modeIsShared(Boolean modeIsShared) {
            this.modeIsShared = modeIsShared;
            return (B)this.self();
        }

        @Generated
        public B modeCollection(ModeCollection modeCollection) {
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.add(modeCollection);
            return (B)this.self();
        }

        @Generated
        public B modeCollections(Collection<? extends ModeCollection> modeCollections) {
            if (modeCollections == null) {
                throw new NullPointerException("modeCollections cannot be null");
            }
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.addAll(modeCollections);
            return (B)this.self();
        }

        @Generated
        public B clearModeCollections() {
            if (this.modeCollections != null) {
                this.modeCollections.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeQuery(ModeQuery modeQuery) {
            if (this.modeQueries == null) {
                this.modeQueries = new ArrayList();
            }
            this.modeQueries.add(modeQuery);
            return (B)this.self();
        }

        @Generated
        public B modeQueries(Collection<? extends ModeQuery> modeQueries) {
            if (modeQueries == null) {
                throw new NullPointerException("modeQueries cannot be null");
            }
            if (this.modeQueries == null) {
                this.modeQueries = new ArrayList();
            }
            this.modeQueries.addAll(modeQueries);
            return (B)this.self();
        }

        @Generated
        public B clearModeQueries() {
            if (this.modeQueries != null) {
                this.modeQueries.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeReport.ModeReportBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", modeCollectionToken=" + this.modeCollectionToken + ", modeReportPublishedAt=" + this.modeReportPublishedAt + ", modeQueryCount=" + this.modeQueryCount + ", modeChartCount=" + this.modeChartCount + ", modeQueryPreview=" + this.modeQueryPreview + ", modeIsPublic=" + this.modeIsPublic + ", modeIsShared=" + this.modeIsShared + ", modeCollections=" + this.modeCollections + ", modeQueries=" + this.modeQueries + ")";
        }
    }
}

