/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Mode;
import com.atlan.model.assets.ModeCollection;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class ModeWorkspace
extends Mode {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeWorkspace";
    String typeName;
    @Attribute
    Long modeCollectionCount;
    @Attribute
    SortedSet<ModeCollection> modeCollections;

    public static ModeWorkspace refByGuid(String guid) {
        return ((ModeWorkspaceBuilder)ModeWorkspace.builder().guid(guid)).build();
    }

    public static ModeWorkspace refByQualifiedName(String qualifiedName) {
        return ((ModeWorkspaceBuilder)ModeWorkspace.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ModeWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeWorkspaceBuilder)((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ModeWorkspaceBuilder<?, ?> trimToRequired() {
        return ModeWorkspace.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeWorkspace retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ModeWorkspace) {
            return (ModeWorkspace)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ModeWorkspace.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ModeWorkspace retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ModeWorkspace) {
            return (ModeWorkspace)entity;
        }
        throw new NotFoundException("No ModeWorkspace found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ModeWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeDescription(((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeUserDescription(((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeOwners(((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeWorkspace updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ModeWorkspace)Asset.updateCertificate(ModeWorkspace.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeCertificate(((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ModeWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeWorkspace)Asset.updateAnnouncement(ModeWorkspace.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeAnnouncement(((ModeWorkspaceBuilder)ModeWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ModeWorkspace replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.replaceTerms(ModeWorkspace.updater(qualifiedName, name), terms);
    }

    public static ModeWorkspace appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ModeWorkspace removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeWorkspace(ModeWorkspaceBuilder<?, ?> b) {
        super((Mode.ModeBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeWorkspace.$default$typeName();
        this.modeCollectionCount = b.modeCollectionCount;
        SortedSet<ModeCollection> modeCollections = new TreeSet<ModeCollection>();
        if (b.modeCollections != null) {
            modeCollections.addAll(b.modeCollections);
        }
        modeCollections = Collections.unmodifiableSortedSet(modeCollections);
        this.modeCollections = modeCollections;
    }

    @Generated
    public static ModeWorkspaceBuilder<?, ?> builder() {
        return new ModeWorkspaceBuilderImpl();
    }

    @Generated
    public ModeWorkspaceBuilder<?, ?> toBuilder() {
        return new ModeWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getModeCollectionCount() {
        return this.modeCollectionCount;
    }

    @Generated
    public SortedSet<ModeCollection> getModeCollections() {
        return this.modeCollections;
    }

    @Generated
    public void setModeCollectionCount(Long modeCollectionCount) {
        this.modeCollectionCount = modeCollectionCount;
    }

    @Generated
    public void setModeCollections(SortedSet<ModeCollection> modeCollections) {
        this.modeCollections = modeCollections;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeWorkspace)) {
            return false;
        }
        ModeWorkspace other = (ModeWorkspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modeCollectionCount = this.getModeCollectionCount();
        Long other$modeCollectionCount = other.getModeCollectionCount();
        if (this$modeCollectionCount == null ? other$modeCollectionCount != null : !((Object)this$modeCollectionCount).equals(other$modeCollectionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ModeCollection> this$modeCollections = this.getModeCollections();
        SortedSet<ModeCollection> other$modeCollections = other.getModeCollections();
        return !(this$modeCollections == null ? other$modeCollections != null : !this$modeCollections.equals(other$modeCollections));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeWorkspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modeCollectionCount = this.getModeCollectionCount();
        result = result * 59 + ($modeCollectionCount == null ? 43 : ((Object)$modeCollectionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ModeCollection> $modeCollections = this.getModeCollections();
        result = result * 59 + ($modeCollections == null ? 43 : $modeCollections.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ModeWorkspaceBuilderImpl
    extends ModeWorkspaceBuilder<ModeWorkspace, ModeWorkspaceBuilderImpl> {
        @Generated
        private ModeWorkspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeWorkspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeWorkspace build() {
            return new ModeWorkspace(this);
        }
    }

    @Generated
    public static abstract class ModeWorkspaceBuilder<C extends ModeWorkspace, B extends ModeWorkspaceBuilder<C, B>>
    extends Mode.ModeBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long modeCollectionCount;
        @Generated
        private ArrayList<ModeCollection> modeCollections;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeWorkspace instance, ModeWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.modeCollectionCount(instance.modeCollectionCount);
            b.modeCollections(instance.modeCollections == null ? Collections.emptySortedSet() : instance.modeCollections);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionCount(Long modeCollectionCount) {
            this.modeCollectionCount = modeCollectionCount;
            return (B)this.self();
        }

        @Generated
        public B modeCollection(ModeCollection modeCollection) {
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.add(modeCollection);
            return (B)this.self();
        }

        @Generated
        public B modeCollections(Collection<? extends ModeCollection> modeCollections) {
            if (modeCollections == null) {
                throw new NullPointerException("modeCollections cannot be null");
            }
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.addAll(modeCollections);
            return (B)this.self();
        }

        @Generated
        public B clearModeCollections() {
            if (this.modeCollections != null) {
                this.modeCollections.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeWorkspace.ModeWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", modeCollectionCount=" + this.modeCollectionCount + ", modeCollections=" + this.modeCollections + ")";
        }
    }
}

