/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBITable;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class PowerBIColumn
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIColumn";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    String powerBIColumnDataCategory;
    @Attribute
    String powerBIColumnDataType;
    @Attribute
    String powerBISortByColumn;
    @Attribute
    String powerBIColumnSummarizeBy;
    @Attribute
    PowerBITable table;

    public static PowerBIColumn refByGuid(String guid) {
        return ((PowerBIColumnBuilder)PowerBIColumn.builder().guid(guid)).build();
    }

    public static PowerBIColumn refByQualifiedName(String qualifiedName) {
        return ((PowerBIColumnBuilder)PowerBIColumn.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIColumnBuilder)((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIColumnBuilder<?, ?> trimToRequired() {
        return PowerBIColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIColumn retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIColumn) {
            return (PowerBIColumn)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIColumn.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIColumn retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIColumn) {
            return (PowerBIColumn)entity;
        }
        throw new NotFoundException("No PowerBIColumn found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIColumn removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeDescription(((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIColumn removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeUserDescription(((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIColumn removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeOwners(((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIColumn updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIColumn)Asset.updateCertificate(PowerBIColumn.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIColumn removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeCertificate(((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIColumn updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIColumn)Asset.updateAnnouncement(PowerBIColumn.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIColumn removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeAnnouncement(((PowerBIColumnBuilder)PowerBIColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIColumn replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.replaceTerms(PowerBIColumn.updater(qualifiedName, name), terms);
    }

    public static PowerBIColumn appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIColumn removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIColumn(PowerBIColumnBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIColumn.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.datasetQualifiedName = b.datasetQualifiedName;
        this.powerBIColumnDataCategory = b.powerBIColumnDataCategory;
        this.powerBIColumnDataType = b.powerBIColumnDataType;
        this.powerBISortByColumn = b.powerBISortByColumn;
        this.powerBIColumnSummarizeBy = b.powerBIColumnSummarizeBy;
        this.table = b.table;
    }

    @Generated
    public static PowerBIColumnBuilder<?, ?> builder() {
        return new PowerBIColumnBuilderImpl();
    }

    @Generated
    public PowerBIColumnBuilder<?, ?> toBuilder() {
        return new PowerBIColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Generated
    public String getPowerBIColumnDataCategory() {
        return this.powerBIColumnDataCategory;
    }

    @Generated
    public String getPowerBIColumnDataType() {
        return this.powerBIColumnDataType;
    }

    @Generated
    public String getPowerBISortByColumn() {
        return this.powerBISortByColumn;
    }

    @Generated
    public String getPowerBIColumnSummarizeBy() {
        return this.powerBIColumnSummarizeBy;
    }

    @Generated
    public PowerBITable getTable() {
        return this.table;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setDatasetQualifiedName(String datasetQualifiedName) {
        this.datasetQualifiedName = datasetQualifiedName;
    }

    @Generated
    public void setPowerBIColumnDataCategory(String powerBIColumnDataCategory) {
        this.powerBIColumnDataCategory = powerBIColumnDataCategory;
    }

    @Generated
    public void setPowerBIColumnDataType(String powerBIColumnDataType) {
        this.powerBIColumnDataType = powerBIColumnDataType;
    }

    @Generated
    public void setPowerBISortByColumn(String powerBISortByColumn) {
        this.powerBISortByColumn = powerBISortByColumn;
    }

    @Generated
    public void setPowerBIColumnSummarizeBy(String powerBIColumnSummarizeBy) {
        this.powerBIColumnSummarizeBy = powerBIColumnSummarizeBy;
    }

    @Generated
    public void setTable(PowerBITable table) {
        this.table = table;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIColumn)) {
            return false;
        }
        PowerBIColumn other = (PowerBIColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        String this$powerBIColumnDataCategory = this.getPowerBIColumnDataCategory();
        String other$powerBIColumnDataCategory = other.getPowerBIColumnDataCategory();
        if (this$powerBIColumnDataCategory == null ? other$powerBIColumnDataCategory != null : !this$powerBIColumnDataCategory.equals(other$powerBIColumnDataCategory)) {
            return false;
        }
        String this$powerBIColumnDataType = this.getPowerBIColumnDataType();
        String other$powerBIColumnDataType = other.getPowerBIColumnDataType();
        if (this$powerBIColumnDataType == null ? other$powerBIColumnDataType != null : !this$powerBIColumnDataType.equals(other$powerBIColumnDataType)) {
            return false;
        }
        String this$powerBISortByColumn = this.getPowerBISortByColumn();
        String other$powerBISortByColumn = other.getPowerBISortByColumn();
        if (this$powerBISortByColumn == null ? other$powerBISortByColumn != null : !this$powerBISortByColumn.equals(other$powerBISortByColumn)) {
            return false;
        }
        String this$powerBIColumnSummarizeBy = this.getPowerBIColumnSummarizeBy();
        String other$powerBIColumnSummarizeBy = other.getPowerBIColumnSummarizeBy();
        if (this$powerBIColumnSummarizeBy == null ? other$powerBIColumnSummarizeBy != null : !this$powerBIColumnSummarizeBy.equals(other$powerBIColumnSummarizeBy)) {
            return false;
        }
        PowerBITable this$table = this.getTable();
        PowerBITable other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        String $powerBIColumnDataCategory = this.getPowerBIColumnDataCategory();
        result = result * 59 + ($powerBIColumnDataCategory == null ? 43 : $powerBIColumnDataCategory.hashCode());
        String $powerBIColumnDataType = this.getPowerBIColumnDataType();
        result = result * 59 + ($powerBIColumnDataType == null ? 43 : $powerBIColumnDataType.hashCode());
        String $powerBISortByColumn = this.getPowerBISortByColumn();
        result = result * 59 + ($powerBISortByColumn == null ? 43 : $powerBISortByColumn.hashCode());
        String $powerBIColumnSummarizeBy = this.getPowerBIColumnSummarizeBy();
        result = result * 59 + ($powerBIColumnSummarizeBy == null ? 43 : $powerBIColumnSummarizeBy.hashCode());
        PowerBITable $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIColumnBuilderImpl
    extends PowerBIColumnBuilder<PowerBIColumn, PowerBIColumnBuilderImpl> {
        @Generated
        private PowerBIColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIColumn build() {
            return new PowerBIColumn(this);
        }
    }

    @Generated
    public static abstract class PowerBIColumnBuilder<C extends PowerBIColumn, B extends PowerBIColumnBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private String powerBIColumnDataCategory;
        @Generated
        private String powerBIColumnDataType;
        @Generated
        private String powerBISortByColumn;
        @Generated
        private String powerBIColumnSummarizeBy;
        @Generated
        private PowerBITable table;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIColumn instance, PowerBIColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.powerBIColumnDataCategory(instance.powerBIColumnDataCategory);
            b.powerBIColumnDataType(instance.powerBIColumnDataType);
            b.powerBISortByColumn(instance.powerBISortByColumn);
            b.powerBIColumnSummarizeBy(instance.powerBIColumnSummarizeBy);
            b.table(instance.table);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnDataCategory(String powerBIColumnDataCategory) {
            this.powerBIColumnDataCategory = powerBIColumnDataCategory;
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnDataType(String powerBIColumnDataType) {
            this.powerBIColumnDataType = powerBIColumnDataType;
            return (B)this.self();
        }

        @Generated
        public B powerBISortByColumn(String powerBISortByColumn) {
            this.powerBISortByColumn = powerBISortByColumn;
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnSummarizeBy(String powerBIColumnSummarizeBy) {
            this.powerBIColumnSummarizeBy = powerBIColumnSummarizeBy;
            return (B)this.self();
        }

        @Generated
        public B table(PowerBITable table) {
            this.table = table;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIColumn.PowerBIColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", datasetQualifiedName=" + this.datasetQualifiedName + ", powerBIColumnDataCategory=" + this.powerBIColumnDataCategory + ", powerBIColumnDataType=" + this.powerBIColumnDataType + ", powerBISortByColumn=" + this.powerBISortByColumn + ", powerBIColumnSummarizeBy=" + this.powerBIColumnSummarizeBy + ", table=" + this.table + ")";
        }
    }
}

