/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBITile;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIDashboard
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDashboard";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String webUrl;
    @Attribute
    Long tileCount;
    @Attribute
    SortedSet<PowerBITile> tiles;
    @Attribute
    PowerBIWorkspace workspace;

    public static PowerBIDashboard refByGuid(String guid) {
        return ((PowerBIDashboardBuilder)PowerBIDashboard.builder().guid(guid)).build();
    }

    public static PowerBIDashboard refByQualifiedName(String qualifiedName) {
        return ((PowerBIDashboardBuilder)PowerBIDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDashboardBuilder)((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIDashboardBuilder<?, ?> trimToRequired() {
        return PowerBIDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIDashboard) {
            return (PowerBIDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIDashboard) {
            return (PowerBIDashboard)entity;
        }
        throw new NotFoundException("No PowerBIDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDashboard)Asset.removeDescription(((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDashboard)Asset.removeUserDescription(((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDashboard)Asset.removeOwners(((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDashboard)Asset.updateCertificate(PowerBIDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDashboard)Asset.removeCertificate(((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDashboard)Asset.updateAnnouncement(PowerBIDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDashboard)Asset.removeAnnouncement(((PowerBIDashboardBuilder)PowerBIDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDashboard)Asset.replaceTerms(PowerBIDashboard.updater(qualifiedName, name), terms);
    }

    public static PowerBIDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDashboard(PowerBIDashboardBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDashboard.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.webUrl = b.webUrl;
        this.tileCount = b.tileCount;
        SortedSet<PowerBITile> tiles = new TreeSet<PowerBITile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        this.workspace = b.workspace;
    }

    @Generated
    public static PowerBIDashboardBuilder<?, ?> builder() {
        return new PowerBIDashboardBuilderImpl();
    }

    @Generated
    public PowerBIDashboardBuilder<?, ?> toBuilder() {
        return new PowerBIDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public Long getTileCount() {
        return this.tileCount;
    }

    @Generated
    public SortedSet<PowerBITile> getTiles() {
        return this.tiles;
    }

    @Generated
    public PowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setTileCount(Long tileCount) {
        this.tileCount = tileCount;
    }

    @Generated
    public void setTiles(SortedSet<PowerBITile> tiles) {
        this.tiles = tiles;
    }

    @Generated
    public void setWorkspace(PowerBIWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDashboard)) {
            return false;
        }
        PowerBIDashboard other = (PowerBIDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$tileCount = this.getTileCount();
        Long other$tileCount = other.getTileCount();
        if (this$tileCount == null ? other$tileCount != null : !((Object)this$tileCount).equals(other$tileCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        SortedSet<PowerBITile> this$tiles = this.getTiles();
        SortedSet<PowerBITile> other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) {
            return false;
        }
        PowerBIWorkspace this$workspace = this.getWorkspace();
        PowerBIWorkspace other$workspace = other.getWorkspace();
        return !(this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $tileCount = this.getTileCount();
        result = result * 59 + ($tileCount == null ? 43 : ((Object)$tileCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        SortedSet<PowerBITile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        PowerBIWorkspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIDashboardBuilderImpl
    extends PowerBIDashboardBuilder<PowerBIDashboard, PowerBIDashboardBuilderImpl> {
        @Generated
        private PowerBIDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDashboard build() {
            return new PowerBIDashboard(this);
        }
    }

    @Generated
    public static abstract class PowerBIDashboardBuilder<C extends PowerBIDashboard, B extends PowerBIDashboardBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String webUrl;
        @Generated
        private Long tileCount;
        @Generated
        private ArrayList<PowerBITile> tiles;
        @Generated
        private PowerBIWorkspace workspace;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDashboard instance, PowerBIDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.webUrl(instance.webUrl);
            b.tileCount(instance.tileCount);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
            b.workspace(instance.workspace);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B tileCount(Long tileCount) {
            this.tileCount = tileCount;
            return (B)this.self();
        }

        @Generated
        public B tile(PowerBITile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends PowerBITile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workspace(PowerBIWorkspace workspace) {
            this.workspace = workspace;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIDashboard.PowerBIDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", webUrl=" + this.webUrl + ", tileCount=" + this.tileCount + ", tiles=" + this.tiles + ", workspace=" + this.workspace + ")";
        }
    }
}

