/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIDataflow
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDataflow";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String webUrl;
    @Attribute
    PowerBIWorkspace workspace;
    @Attribute
    SortedSet<PowerBIDataset> datasets;

    public static PowerBIDataflow refByGuid(String guid) {
        return ((PowerBIDataflowBuilder)PowerBIDataflow.builder().guid(guid)).build();
    }

    public static PowerBIDataflow refByQualifiedName(String qualifiedName) {
        return ((PowerBIDataflowBuilder)PowerBIDataflow.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIDataflowBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDataflowBuilder)((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIDataflowBuilder<?, ?> trimToRequired() {
        return PowerBIDataflow.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDataflow retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIDataflow) {
            return (PowerBIDataflow)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIDataflow.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIDataflow retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIDataflow) {
            return (PowerBIDataflow)entity;
        }
        throw new NotFoundException("No PowerBIDataflow found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIDataflow removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeDescription(((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataflow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeUserDescription(((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataflow removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeOwners(((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataflow updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDataflow)Asset.updateCertificate(PowerBIDataflow.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDataflow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeCertificate(((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataflow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDataflow)Asset.updateAnnouncement(PowerBIDataflow.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDataflow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeAnnouncement(((PowerBIDataflowBuilder)PowerBIDataflow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIDataflow replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.replaceTerms(PowerBIDataflow.updater(qualifiedName, name), terms);
    }

    public static PowerBIDataflow appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDataflow removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDataflow(PowerBIDataflowBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDataflow.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.webUrl = b.webUrl;
        this.workspace = b.workspace;
        SortedSet<PowerBIDataset> datasets = new TreeSet<PowerBIDataset>();
        if (b.datasets != null) {
            datasets.addAll(b.datasets);
        }
        datasets = Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
    }

    @Generated
    public static PowerBIDataflowBuilder<?, ?> builder() {
        return new PowerBIDataflowBuilderImpl();
    }

    @Generated
    public PowerBIDataflowBuilder<?, ?> toBuilder() {
        return new PowerBIDataflowBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public PowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    @Generated
    public SortedSet<PowerBIDataset> getDatasets() {
        return this.datasets;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setWorkspace(PowerBIWorkspace workspace) {
        this.workspace = workspace;
    }

    @Generated
    public void setDatasets(SortedSet<PowerBIDataset> datasets) {
        this.datasets = datasets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDataflow)) {
            return false;
        }
        PowerBIDataflow other = (PowerBIDataflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        PowerBIWorkspace this$workspace = this.getWorkspace();
        PowerBIWorkspace other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace)) {
            return false;
        }
        SortedSet<PowerBIDataset> this$datasets = this.getDatasets();
        SortedSet<PowerBIDataset> other$datasets = other.getDatasets();
        return !(this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDataflow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        PowerBIWorkspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        SortedSet<PowerBIDataset> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : $datasets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIDataflowBuilderImpl
    extends PowerBIDataflowBuilder<PowerBIDataflow, PowerBIDataflowBuilderImpl> {
        @Generated
        private PowerBIDataflowBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDataflowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDataflow build() {
            return new PowerBIDataflow(this);
        }
    }

    @Generated
    public static abstract class PowerBIDataflowBuilder<C extends PowerBIDataflow, B extends PowerBIDataflowBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String webUrl;
        @Generated
        private PowerBIWorkspace workspace;
        @Generated
        private ArrayList<PowerBIDataset> datasets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDataflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDataflow instance, PowerBIDataflowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.webUrl(instance.webUrl);
            b.workspace(instance.workspace);
            b.datasets(instance.datasets == null ? Collections.emptySortedSet() : instance.datasets);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B workspace(PowerBIWorkspace workspace) {
            this.workspace = workspace;
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.add(dataset);
            return (B)this.self();
        }

        @Generated
        public B datasets(Collection<? extends PowerBIDataset> datasets) {
            if (datasets == null) {
                throw new NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.addAll(datasets);
            return (B)this.self();
        }

        @Generated
        public B clearDatasets() {
            if (this.datasets != null) {
                this.datasets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIDataflow.PowerBIDataflowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", webUrl=" + this.webUrl + ", workspace=" + this.workspace + ", datasets=" + this.datasets + ")";
        }
    }
}

