/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDataflow;
import com.atlan.model.assets.PowerBIDatasource;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.assets.PowerBITable;
import com.atlan.model.assets.PowerBITile;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIDataset
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDataset";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String webUrl;
    @Attribute
    SortedSet<PowerBIReport> reports;
    @Attribute
    SortedSet<PowerBITile> tiles;
    @Attribute
    PowerBIWorkspace workspace;
    @Attribute
    SortedSet<PowerBITable> tables;
    @Attribute
    SortedSet<PowerBIDatasource> datasources;
    @Attribute
    SortedSet<PowerBIDataflow> dataflows;

    public static PowerBIDataset refByGuid(String guid) {
        return ((PowerBIDatasetBuilder)PowerBIDataset.builder().guid(guid)).build();
    }

    public static PowerBIDataset refByQualifiedName(String qualifiedName) {
        return ((PowerBIDatasetBuilder)PowerBIDataset.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDatasetBuilder)((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIDatasetBuilder<?, ?> trimToRequired() {
        return PowerBIDataset.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDataset retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIDataset) {
            return (PowerBIDataset)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIDataset.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIDataset retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIDataset) {
            return (PowerBIDataset)entity;
        }
        throw new NotFoundException("No PowerBIDataset found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIDataset removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataset)Asset.removeDescription(((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataset)Asset.removeUserDescription(((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataset removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataset)Asset.removeOwners(((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataset updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDataset)Asset.updateCertificate(PowerBIDataset.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDataset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataset)Asset.removeCertificate(((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDataset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDataset)Asset.updateAnnouncement(PowerBIDataset.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDataset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataset)Asset.removeAnnouncement(((PowerBIDatasetBuilder)PowerBIDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIDataset replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataset)Asset.replaceTerms(PowerBIDataset.updater(qualifiedName, name), terms);
    }

    public static PowerBIDataset appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataset)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDataset removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataset)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDataset(PowerBIDatasetBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDataset.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.webUrl = b.webUrl;
        SortedSet<PowerBIReport> reports = new TreeSet<PowerBIReport>();
        if (b.reports != null) {
            reports.addAll(b.reports);
        }
        reports = Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        SortedSet<PowerBITile> tiles = new TreeSet<PowerBITile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        this.workspace = b.workspace;
        SortedSet<PowerBITable> tables = new TreeSet<PowerBITable>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        SortedSet<PowerBIDatasource> datasources = new TreeSet<PowerBIDatasource>();
        if (b.datasources != null) {
            datasources.addAll(b.datasources);
        }
        datasources = Collections.unmodifiableSortedSet(datasources);
        this.datasources = datasources;
        SortedSet<PowerBIDataflow> dataflows = new TreeSet<PowerBIDataflow>();
        if (b.dataflows != null) {
            dataflows.addAll(b.dataflows);
        }
        dataflows = Collections.unmodifiableSortedSet(dataflows);
        this.dataflows = dataflows;
    }

    @Generated
    public static PowerBIDatasetBuilder<?, ?> builder() {
        return new PowerBIDatasetBuilderImpl();
    }

    @Generated
    public PowerBIDatasetBuilder<?, ?> toBuilder() {
        return new PowerBIDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public SortedSet<PowerBIReport> getReports() {
        return this.reports;
    }

    @Generated
    public SortedSet<PowerBITile> getTiles() {
        return this.tiles;
    }

    @Generated
    public PowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    @Generated
    public SortedSet<PowerBITable> getTables() {
        return this.tables;
    }

    @Generated
    public SortedSet<PowerBIDatasource> getDatasources() {
        return this.datasources;
    }

    @Generated
    public SortedSet<PowerBIDataflow> getDataflows() {
        return this.dataflows;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setReports(SortedSet<PowerBIReport> reports) {
        this.reports = reports;
    }

    @Generated
    public void setTiles(SortedSet<PowerBITile> tiles) {
        this.tiles = tiles;
    }

    @Generated
    public void setWorkspace(PowerBIWorkspace workspace) {
        this.workspace = workspace;
    }

    @Generated
    public void setTables(SortedSet<PowerBITable> tables) {
        this.tables = tables;
    }

    @Generated
    public void setDatasources(SortedSet<PowerBIDatasource> datasources) {
        this.datasources = datasources;
    }

    @Generated
    public void setDataflows(SortedSet<PowerBIDataflow> dataflows) {
        this.dataflows = dataflows;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDataset)) {
            return false;
        }
        PowerBIDataset other = (PowerBIDataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        SortedSet<PowerBIReport> this$reports = this.getReports();
        SortedSet<PowerBIReport> other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) {
            return false;
        }
        SortedSet<PowerBITile> this$tiles = this.getTiles();
        SortedSet<PowerBITile> other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) {
            return false;
        }
        PowerBIWorkspace this$workspace = this.getWorkspace();
        PowerBIWorkspace other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace)) {
            return false;
        }
        SortedSet<PowerBITable> this$tables = this.getTables();
        SortedSet<PowerBITable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        SortedSet<PowerBIDatasource> this$datasources = this.getDatasources();
        SortedSet<PowerBIDatasource> other$datasources = other.getDatasources();
        if (this$datasources == null ? other$datasources != null : !this$datasources.equals(other$datasources)) {
            return false;
        }
        SortedSet<PowerBIDataflow> this$dataflows = this.getDataflows();
        SortedSet<PowerBIDataflow> other$dataflows = other.getDataflows();
        return !(this$dataflows == null ? other$dataflows != null : !this$dataflows.equals(other$dataflows));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        SortedSet<PowerBIReport> $reports = this.getReports();
        result = result * 59 + ($reports == null ? 43 : $reports.hashCode());
        SortedSet<PowerBITile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        PowerBIWorkspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        SortedSet<PowerBITable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        SortedSet<PowerBIDatasource> $datasources = this.getDatasources();
        result = result * 59 + ($datasources == null ? 43 : $datasources.hashCode());
        SortedSet<PowerBIDataflow> $dataflows = this.getDataflows();
        result = result * 59 + ($dataflows == null ? 43 : $dataflows.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIDatasetBuilderImpl
    extends PowerBIDatasetBuilder<PowerBIDataset, PowerBIDatasetBuilderImpl> {
        @Generated
        private PowerBIDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDataset build() {
            return new PowerBIDataset(this);
        }
    }

    @Generated
    public static abstract class PowerBIDatasetBuilder<C extends PowerBIDataset, B extends PowerBIDatasetBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String webUrl;
        @Generated
        private ArrayList<PowerBIReport> reports;
        @Generated
        private ArrayList<PowerBITile> tiles;
        @Generated
        private PowerBIWorkspace workspace;
        @Generated
        private ArrayList<PowerBITable> tables;
        @Generated
        private ArrayList<PowerBIDatasource> datasources;
        @Generated
        private ArrayList<PowerBIDataflow> dataflows;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDataset instance, PowerBIDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.webUrl(instance.webUrl);
            b.reports(instance.reports == null ? Collections.emptySortedSet() : instance.reports);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
            b.workspace(instance.workspace);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.datasources(instance.datasources == null ? Collections.emptySortedSet() : instance.datasources);
            b.dataflows(instance.dataflows == null ? Collections.emptySortedSet() : instance.dataflows);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B report(PowerBIReport report) {
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.add(report);
            return (B)this.self();
        }

        @Generated
        public B reports(Collection<? extends PowerBIReport> reports) {
            if (reports == null) {
                throw new NullPointerException("reports cannot be null");
            }
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.addAll(reports);
            return (B)this.self();
        }

        @Generated
        public B clearReports() {
            if (this.reports != null) {
                this.reports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tile(PowerBITile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends PowerBITile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workspace(PowerBIWorkspace workspace) {
            this.workspace = workspace;
            return (B)this.self();
        }

        @Generated
        public B table(PowerBITable table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends PowerBITable> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasource(PowerBIDatasource datasource) {
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.add(datasource);
            return (B)this.self();
        }

        @Generated
        public B datasources(Collection<? extends PowerBIDatasource> datasources) {
            if (datasources == null) {
                throw new NullPointerException("datasources cannot be null");
            }
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.addAll(datasources);
            return (B)this.self();
        }

        @Generated
        public B clearDatasources() {
            if (this.datasources != null) {
                this.datasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataflow(PowerBIDataflow dataflow) {
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.add(dataflow);
            return (B)this.self();
        }

        @Generated
        public B dataflows(Collection<? extends PowerBIDataflow> dataflows) {
            if (dataflows == null) {
                throw new NullPointerException("dataflows cannot be null");
            }
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.addAll(dataflows);
            return (B)this.self();
        }

        @Generated
        public B clearDataflows() {
            if (this.dataflows != null) {
                this.dataflows.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIDataset.PowerBIDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", webUrl=" + this.webUrl + ", reports=" + this.reports + ", tiles=" + this.tiles + ", workspace=" + this.workspace + ", tables=" + this.tables + ", datasources=" + this.datasources + ", dataflows=" + this.dataflows + ")";
        }
    }
}

