/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIDatasource
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDatasource";
    String typeName;
    @Attribute
    Map<String, String> connectionDetails;
    @Attribute
    SortedSet<PowerBIDataset> datasets;

    public static PowerBIDatasource refByGuid(String guid) {
        return ((PowerBIDatasourceBuilder)PowerBIDatasource.builder().guid(guid)).build();
    }

    public static PowerBIDatasource refByQualifiedName(String qualifiedName) {
        return ((PowerBIDatasourceBuilder)PowerBIDatasource.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIDatasourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDatasourceBuilder)((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIDatasourceBuilder<?, ?> trimToRequired() {
        return PowerBIDatasource.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDatasource retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIDatasource) {
            return (PowerBIDatasource)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIDatasource.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIDatasource retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIDatasource) {
            return (PowerBIDatasource)entity;
        }
        throw new NotFoundException("No PowerBIDatasource found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIDatasource removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeDescription(((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDatasource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeUserDescription(((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDatasource removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeOwners(((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDatasource updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDatasource)Asset.updateCertificate(PowerBIDatasource.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDatasource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeCertificate(((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIDatasource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDatasource)Asset.updateAnnouncement(PowerBIDatasource.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDatasource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeAnnouncement(((PowerBIDatasourceBuilder)PowerBIDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIDatasource replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.replaceTerms(PowerBIDatasource.updater(qualifiedName, name), terms);
    }

    public static PowerBIDatasource appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDatasource removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDatasource(PowerBIDatasourceBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        Map<Object, Object> connectionDetails;
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDatasource.$default$typeName();
        switch (b.connectionDetails$key == null ? 0 : b.connectionDetails$key.size()) {
            case 0: {
                connectionDetails = Collections.emptyMap();
                break;
            }
            case 1: {
                connectionDetails = Collections.singletonMap(b.connectionDetails$key.get(0), b.connectionDetails$value.get(0));
                break;
            }
            default: {
                connectionDetails = new LinkedHashMap(b.connectionDetails$key.size() < 0x40000000 ? 1 + b.connectionDetails$key.size() + (b.connectionDetails$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.connectionDetails$key.size(); ++$i) {
                    connectionDetails.put(b.connectionDetails$key.get($i), b.connectionDetails$value.get($i));
                }
                connectionDetails = Collections.unmodifiableMap(connectionDetails);
            }
        }
        this.connectionDetails = connectionDetails;
        SortedSet<PowerBIDataset> datasets = new TreeSet<PowerBIDataset>();
        if (b.datasets != null) {
            datasets.addAll(b.datasets);
        }
        datasets = Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
    }

    @Generated
    public static PowerBIDatasourceBuilder<?, ?> builder() {
        return new PowerBIDatasourceBuilderImpl();
    }

    @Generated
    public PowerBIDatasourceBuilder<?, ?> toBuilder() {
        return new PowerBIDatasourceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Map<String, String> getConnectionDetails() {
        return this.connectionDetails;
    }

    @Generated
    public SortedSet<PowerBIDataset> getDatasets() {
        return this.datasets;
    }

    @Generated
    public void setConnectionDetails(Map<String, String> connectionDetails) {
        this.connectionDetails = connectionDetails;
    }

    @Generated
    public void setDatasets(SortedSet<PowerBIDataset> datasets) {
        this.datasets = datasets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDatasource)) {
            return false;
        }
        PowerBIDatasource other = (PowerBIDatasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$connectionDetails = this.getConnectionDetails();
        Map<String, String> other$connectionDetails = other.getConnectionDetails();
        if (this$connectionDetails == null ? other$connectionDetails != null : !((Object)this$connectionDetails).equals(other$connectionDetails)) {
            return false;
        }
        SortedSet<PowerBIDataset> this$datasets = this.getDatasets();
        SortedSet<PowerBIDataset> other$datasets = other.getDatasets();
        return !(this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDatasource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $connectionDetails = this.getConnectionDetails();
        result = result * 59 + ($connectionDetails == null ? 43 : ((Object)$connectionDetails).hashCode());
        SortedSet<PowerBIDataset> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : $datasets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIDatasourceBuilderImpl
    extends PowerBIDatasourceBuilder<PowerBIDatasource, PowerBIDatasourceBuilderImpl> {
        @Generated
        private PowerBIDatasourceBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDatasourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDatasource build() {
            return new PowerBIDatasource(this);
        }
    }

    @Generated
    public static abstract class PowerBIDatasourceBuilder<C extends PowerBIDatasource, B extends PowerBIDatasourceBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> connectionDetails$key;
        @Generated
        private ArrayList<String> connectionDetails$value;
        @Generated
        private ArrayList<PowerBIDataset> datasets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDatasourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDatasource instance, PowerBIDatasourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.connectionDetails(instance.connectionDetails == null ? Collections.emptyMap() : instance.connectionDetails);
            b.datasets(instance.datasets == null ? Collections.emptySortedSet() : instance.datasets);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B connectionDetail(String connectionDetailKey, String connectionDetailValue) {
            if (this.connectionDetails$key == null) {
                this.connectionDetails$key = new ArrayList();
                this.connectionDetails$value = new ArrayList();
            }
            this.connectionDetails$key.add(connectionDetailKey);
            this.connectionDetails$value.add(connectionDetailValue);
            return (B)this.self();
        }

        @Generated
        public B connectionDetails(Map<? extends String, ? extends String> connectionDetails) {
            if (connectionDetails == null) {
                throw new NullPointerException("connectionDetails cannot be null");
            }
            if (this.connectionDetails$key == null) {
                this.connectionDetails$key = new ArrayList();
                this.connectionDetails$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : connectionDetails.entrySet()) {
                this.connectionDetails$key.add($lombokEntry.getKey());
                this.connectionDetails$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearConnectionDetails() {
            if (this.connectionDetails$key != null) {
                this.connectionDetails$key.clear();
                this.connectionDetails$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.add(dataset);
            return (B)this.self();
        }

        @Generated
        public B datasets(Collection<? extends PowerBIDataset> datasets) {
            if (datasets == null) {
                throw new NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.addAll(datasets);
            return (B)this.self();
        }

        @Generated
        public B clearDatasets() {
            if (this.datasets != null) {
                this.datasets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIDatasource.PowerBIDatasourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", connectionDetails$key=" + this.connectionDetails$key + ", connectionDetails$value=" + this.connectionDetails$value + ", datasets=" + this.datasets + ")";
        }
    }
}

