/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBITable;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class PowerBIMeasure
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIMeasure";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    String powerBIMeasureExpression;
    @Attribute
    Boolean powerBIIsExternalMeasure;
    @Attribute
    PowerBITable table;

    public static PowerBIMeasure refByGuid(String guid) {
        return ((PowerBIMeasureBuilder)PowerBIMeasure.builder().guid(guid)).build();
    }

    public static PowerBIMeasure refByQualifiedName(String qualifiedName) {
        return ((PowerBIMeasureBuilder)PowerBIMeasure.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIMeasureBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIMeasureBuilder)((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIMeasureBuilder<?, ?> trimToRequired() {
        return PowerBIMeasure.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIMeasure retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIMeasure) {
            return (PowerBIMeasure)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIMeasure.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIMeasure retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIMeasure) {
            return (PowerBIMeasure)entity;
        }
        throw new NotFoundException("No PowerBIMeasure found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIMeasure removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIMeasure)Asset.removeDescription(((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIMeasure removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIMeasure)Asset.removeUserDescription(((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIMeasure removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIMeasure)Asset.removeOwners(((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIMeasure updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIMeasure)Asset.updateCertificate(PowerBIMeasure.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIMeasure removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIMeasure)Asset.removeCertificate(((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIMeasure updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIMeasure)Asset.updateAnnouncement(PowerBIMeasure.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIMeasure removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIMeasure)Asset.removeAnnouncement(((PowerBIMeasureBuilder)PowerBIMeasure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIMeasure replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIMeasure)Asset.replaceTerms(PowerBIMeasure.updater(qualifiedName, name), terms);
    }

    public static PowerBIMeasure appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIMeasure)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIMeasure removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIMeasure)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIMeasure(PowerBIMeasureBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIMeasure.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.datasetQualifiedName = b.datasetQualifiedName;
        this.powerBIMeasureExpression = b.powerBIMeasureExpression;
        this.powerBIIsExternalMeasure = b.powerBIIsExternalMeasure;
        this.table = b.table;
    }

    @Generated
    public static PowerBIMeasureBuilder<?, ?> builder() {
        return new PowerBIMeasureBuilderImpl();
    }

    @Generated
    public PowerBIMeasureBuilder<?, ?> toBuilder() {
        return new PowerBIMeasureBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Generated
    public String getPowerBIMeasureExpression() {
        return this.powerBIMeasureExpression;
    }

    @Generated
    public Boolean getPowerBIIsExternalMeasure() {
        return this.powerBIIsExternalMeasure;
    }

    @Generated
    public PowerBITable getTable() {
        return this.table;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setDatasetQualifiedName(String datasetQualifiedName) {
        this.datasetQualifiedName = datasetQualifiedName;
    }

    @Generated
    public void setPowerBIMeasureExpression(String powerBIMeasureExpression) {
        this.powerBIMeasureExpression = powerBIMeasureExpression;
    }

    @Generated
    public void setPowerBIIsExternalMeasure(Boolean powerBIIsExternalMeasure) {
        this.powerBIIsExternalMeasure = powerBIIsExternalMeasure;
    }

    @Generated
    public void setTable(PowerBITable table) {
        this.table = table;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIMeasure)) {
            return false;
        }
        PowerBIMeasure other = (PowerBIMeasure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsExternalMeasure = this.getPowerBIIsExternalMeasure();
        Boolean other$powerBIIsExternalMeasure = other.getPowerBIIsExternalMeasure();
        if (this$powerBIIsExternalMeasure == null ? other$powerBIIsExternalMeasure != null : !((Object)this$powerBIIsExternalMeasure).equals(other$powerBIIsExternalMeasure)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        String this$powerBIMeasureExpression = this.getPowerBIMeasureExpression();
        String other$powerBIMeasureExpression = other.getPowerBIMeasureExpression();
        if (this$powerBIMeasureExpression == null ? other$powerBIMeasureExpression != null : !this$powerBIMeasureExpression.equals(other$powerBIMeasureExpression)) {
            return false;
        }
        PowerBITable this$table = this.getTable();
        PowerBITable other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIMeasure;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsExternalMeasure = this.getPowerBIIsExternalMeasure();
        result = result * 59 + ($powerBIIsExternalMeasure == null ? 43 : ((Object)$powerBIIsExternalMeasure).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        String $powerBIMeasureExpression = this.getPowerBIMeasureExpression();
        result = result * 59 + ($powerBIMeasureExpression == null ? 43 : $powerBIMeasureExpression.hashCode());
        PowerBITable $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIMeasureBuilderImpl
    extends PowerBIMeasureBuilder<PowerBIMeasure, PowerBIMeasureBuilderImpl> {
        @Generated
        private PowerBIMeasureBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIMeasureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIMeasure build() {
            return new PowerBIMeasure(this);
        }
    }

    @Generated
    public static abstract class PowerBIMeasureBuilder<C extends PowerBIMeasure, B extends PowerBIMeasureBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private String powerBIMeasureExpression;
        @Generated
        private Boolean powerBIIsExternalMeasure;
        @Generated
        private PowerBITable table;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIMeasureBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIMeasure instance, PowerBIMeasureBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.powerBIMeasureExpression(instance.powerBIMeasureExpression);
            b.powerBIIsExternalMeasure(instance.powerBIIsExternalMeasure);
            b.table(instance.table);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBIMeasureExpression(String powerBIMeasureExpression) {
            this.powerBIMeasureExpression = powerBIMeasureExpression;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsExternalMeasure(Boolean powerBIIsExternalMeasure) {
            this.powerBIIsExternalMeasure = powerBIIsExternalMeasure;
            return (B)this.self();
        }

        @Generated
        public B table(PowerBITable table) {
            this.table = table;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIMeasure.PowerBIMeasureBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", datasetQualifiedName=" + this.datasetQualifiedName + ", powerBIMeasureExpression=" + this.powerBIMeasureExpression + ", powerBIIsExternalMeasure=" + this.powerBIIsExternalMeasure + ", table=" + this.table + ")";
        }
    }
}

