/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class PowerBIPage
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIPage";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String reportQualifiedName;
    @Attribute
    PowerBIReport report;

    public static PowerBIPage refByGuid(String guid) {
        return ((PowerBIPageBuilder)PowerBIPage.builder().guid(guid)).build();
    }

    public static PowerBIPage refByQualifiedName(String qualifiedName) {
        return ((PowerBIPageBuilder)PowerBIPage.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIPageBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIPageBuilder)((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIPageBuilder<?, ?> trimToRequired() {
        return PowerBIPage.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIPage retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIPage) {
            return (PowerBIPage)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIPage.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIPage retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIPage) {
            return (PowerBIPage)entity;
        }
        throw new NotFoundException("No PowerBIPage found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIPage removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIPage)Asset.removeDescription(((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIPage removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIPage)Asset.removeUserDescription(((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIPage removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIPage)Asset.removeOwners(((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIPage updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIPage)Asset.updateCertificate(PowerBIPage.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIPage removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIPage)Asset.removeCertificate(((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIPage updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIPage)Asset.updateAnnouncement(PowerBIPage.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIPage removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIPage)Asset.removeAnnouncement(((PowerBIPageBuilder)PowerBIPage.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIPage replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIPage)Asset.replaceTerms(PowerBIPage.updater(qualifiedName, name), terms);
    }

    public static PowerBIPage appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIPage)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIPage removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIPage)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIPage(PowerBIPageBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIPage.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.reportQualifiedName = b.reportQualifiedName;
        this.report = b.report;
    }

    @Generated
    public static PowerBIPageBuilder<?, ?> builder() {
        return new PowerBIPageBuilderImpl();
    }

    @Generated
    public PowerBIPageBuilder<?, ?> toBuilder() {
        return new PowerBIPageBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getReportQualifiedName() {
        return this.reportQualifiedName;
    }

    @Generated
    public PowerBIReport getReport() {
        return this.report;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setReportQualifiedName(String reportQualifiedName) {
        this.reportQualifiedName = reportQualifiedName;
    }

    @Generated
    public void setReport(PowerBIReport report) {
        this.report = report;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIPage)) {
            return false;
        }
        PowerBIPage other = (PowerBIPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$reportQualifiedName = this.getReportQualifiedName();
        String other$reportQualifiedName = other.getReportQualifiedName();
        if (this$reportQualifiedName == null ? other$reportQualifiedName != null : !this$reportQualifiedName.equals(other$reportQualifiedName)) {
            return false;
        }
        PowerBIReport this$report = this.getReport();
        PowerBIReport other$report = other.getReport();
        return !(this$report == null ? other$report != null : !((Object)this$report).equals(other$report));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIPage;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $reportQualifiedName = this.getReportQualifiedName();
        result = result * 59 + ($reportQualifiedName == null ? 43 : $reportQualifiedName.hashCode());
        PowerBIReport $report = this.getReport();
        result = result * 59 + ($report == null ? 43 : ((Object)$report).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIPageBuilderImpl
    extends PowerBIPageBuilder<PowerBIPage, PowerBIPageBuilderImpl> {
        @Generated
        private PowerBIPageBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIPageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIPage build() {
            return new PowerBIPage(this);
        }
    }

    @Generated
    public static abstract class PowerBIPageBuilder<C extends PowerBIPage, B extends PowerBIPageBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String reportQualifiedName;
        @Generated
        private PowerBIReport report;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIPageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIPage instance, PowerBIPageBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.reportQualifiedName(instance.reportQualifiedName);
            b.report(instance.report);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B reportQualifiedName(String reportQualifiedName) {
            this.reportQualifiedName = reportQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B report(PowerBIReport report) {
            this.report = report;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIPage.PowerBIPageBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", reportQualifiedName=" + this.reportQualifiedName + ", report=" + this.report + ")";
        }
    }
}

