/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIPage;
import com.atlan.model.assets.PowerBITile;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIReport
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIReport";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    String webUrl;
    @Attribute
    Long pageCount;
    @Attribute
    SortedSet<PowerBITile> tiles;
    @Attribute
    PowerBIWorkspace workspace;
    @Attribute
    SortedSet<PowerBIPage> pages;
    @Attribute
    PowerBIDataset dataset;

    public static PowerBIReport refByGuid(String guid) {
        return ((PowerBIReportBuilder)PowerBIReport.builder().guid(guid)).build();
    }

    public static PowerBIReport refByQualifiedName(String qualifiedName) {
        return ((PowerBIReportBuilder)PowerBIReport.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIReportBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIReportBuilder)((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIReportBuilder<?, ?> trimToRequired() {
        return PowerBIReport.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIReport retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIReport) {
            return (PowerBIReport)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIReport.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIReport retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIReport) {
            return (PowerBIReport)entity;
        }
        throw new NotFoundException("No PowerBIReport found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIReport removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport)Asset.removeDescription(((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIReport removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport)Asset.removeUserDescription(((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIReport removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport)Asset.removeOwners(((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIReport updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIReport)Asset.updateCertificate(PowerBIReport.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIReport removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport)Asset.removeCertificate(((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIReport updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIReport)Asset.updateAnnouncement(PowerBIReport.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIReport removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport)Asset.removeAnnouncement(((PowerBIReportBuilder)PowerBIReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIReport replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport)Asset.replaceTerms(PowerBIReport.updater(qualifiedName, name), terms);
    }

    public static PowerBIReport appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIReport removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIReport(PowerBIReportBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIReport.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.datasetQualifiedName = b.datasetQualifiedName;
        this.webUrl = b.webUrl;
        this.pageCount = b.pageCount;
        SortedSet<PowerBITile> tiles = new TreeSet<PowerBITile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        this.workspace = b.workspace;
        SortedSet<PowerBIPage> pages = new TreeSet<PowerBIPage>();
        if (b.pages != null) {
            pages.addAll(b.pages);
        }
        pages = Collections.unmodifiableSortedSet(pages);
        this.pages = pages;
        this.dataset = b.dataset;
    }

    @Generated
    public static PowerBIReportBuilder<?, ?> builder() {
        return new PowerBIReportBuilderImpl();
    }

    @Generated
    public PowerBIReportBuilder<?, ?> toBuilder() {
        return new PowerBIReportBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public Long getPageCount() {
        return this.pageCount;
    }

    @Generated
    public SortedSet<PowerBITile> getTiles() {
        return this.tiles;
    }

    @Generated
    public PowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    @Generated
    public SortedSet<PowerBIPage> getPages() {
        return this.pages;
    }

    @Generated
    public PowerBIDataset getDataset() {
        return this.dataset;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setDatasetQualifiedName(String datasetQualifiedName) {
        this.datasetQualifiedName = datasetQualifiedName;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setPageCount(Long pageCount) {
        this.pageCount = pageCount;
    }

    @Generated
    public void setTiles(SortedSet<PowerBITile> tiles) {
        this.tiles = tiles;
    }

    @Generated
    public void setWorkspace(PowerBIWorkspace workspace) {
        this.workspace = workspace;
    }

    @Generated
    public void setPages(SortedSet<PowerBIPage> pages) {
        this.pages = pages;
    }

    @Generated
    public void setDataset(PowerBIDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIReport)) {
            return false;
        }
        PowerBIReport other = (PowerBIReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$pageCount = this.getPageCount();
        Long other$pageCount = other.getPageCount();
        if (this$pageCount == null ? other$pageCount != null : !((Object)this$pageCount).equals(other$pageCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        SortedSet<PowerBITile> this$tiles = this.getTiles();
        SortedSet<PowerBITile> other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) {
            return false;
        }
        PowerBIWorkspace this$workspace = this.getWorkspace();
        PowerBIWorkspace other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace)) {
            return false;
        }
        SortedSet<PowerBIPage> this$pages = this.getPages();
        SortedSet<PowerBIPage> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !this$pages.equals(other$pages)) {
            return false;
        }
        PowerBIDataset this$dataset = this.getDataset();
        PowerBIDataset other$dataset = other.getDataset();
        return !(this$dataset == null ? other$dataset != null : !((Object)this$dataset).equals(other$dataset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIReport;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $pageCount = this.getPageCount();
        result = result * 59 + ($pageCount == null ? 43 : ((Object)$pageCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        SortedSet<PowerBITile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        PowerBIWorkspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        SortedSet<PowerBIPage> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : $pages.hashCode());
        PowerBIDataset $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : ((Object)$dataset).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIReportBuilderImpl
    extends PowerBIReportBuilder<PowerBIReport, PowerBIReportBuilderImpl> {
        @Generated
        private PowerBIReportBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIReportBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIReport build() {
            return new PowerBIReport(this);
        }
    }

    @Generated
    public static abstract class PowerBIReportBuilder<C extends PowerBIReport, B extends PowerBIReportBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private String webUrl;
        @Generated
        private Long pageCount;
        @Generated
        private ArrayList<PowerBITile> tiles;
        @Generated
        private PowerBIWorkspace workspace;
        @Generated
        private ArrayList<PowerBIPage> pages;
        @Generated
        private PowerBIDataset dataset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIReportBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIReport instance, PowerBIReportBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.webUrl(instance.webUrl);
            b.pageCount(instance.pageCount);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
            b.workspace(instance.workspace);
            b.pages(instance.pages == null ? Collections.emptySortedSet() : instance.pages);
            b.dataset(instance.dataset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B pageCount(Long pageCount) {
            this.pageCount = pageCount;
            return (B)this.self();
        }

        @Generated
        public B tile(PowerBITile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends PowerBITile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workspace(PowerBIWorkspace workspace) {
            this.workspace = workspace;
            return (B)this.self();
        }

        @Generated
        public B page(PowerBIPage page) {
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.add(page);
            return (B)this.self();
        }

        @Generated
        public B pages(Collection<? extends PowerBIPage> pages) {
            if (pages == null) {
                throw new NullPointerException("pages cannot be null");
            }
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.addAll(pages);
            return (B)this.self();
        }

        @Generated
        public B clearPages() {
            if (this.pages != null) {
                this.pages.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            this.dataset = dataset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIReport.PowerBIReportBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", datasetQualifiedName=" + this.datasetQualifiedName + ", webUrl=" + this.webUrl + ", pageCount=" + this.pageCount + ", tiles=" + this.tiles + ", workspace=" + this.workspace + ", pages=" + this.pages + ", dataset=" + this.dataset + ")";
        }
    }
}

