/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIColumn;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIMeasure;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBITable
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBITable";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    SortedSet<String> powerBITableSourceExpressions;
    @Attribute
    Long powerBITableColumnCount;
    @Attribute
    Long powerBITableMeasureCount;
    @Attribute
    SortedSet<PowerBIMeasure> measures;
    @Attribute
    SortedSet<PowerBIColumn> columns;
    @Attribute
    PowerBIDataset dataset;

    public static PowerBITable refByGuid(String guid) {
        return ((PowerBITableBuilder)PowerBITable.builder().guid(guid)).build();
    }

    public static PowerBITable refByQualifiedName(String qualifiedName) {
        return ((PowerBITableBuilder)PowerBITable.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBITableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBITableBuilder)((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBITableBuilder<?, ?> trimToRequired() {
        return PowerBITable.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBITable retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBITable) {
            return (PowerBITable)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBITable.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBITable retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBITable) {
            return (PowerBITable)entity;
        }
        throw new NotFoundException("No PowerBITable found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBITable removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeDescription(((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeUserDescription(((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITable removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeOwners(((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITable updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBITable)Asset.updateCertificate(PowerBITable.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBITable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeCertificate(((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBITable)Asset.updateAnnouncement(PowerBITable.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBITable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeAnnouncement(((PowerBITableBuilder)PowerBITable.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBITable replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.replaceTerms(PowerBITable.updater(qualifiedName, name), terms);
    }

    public static PowerBITable appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBITable removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBITable(PowerBITableBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBITable.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.datasetQualifiedName = b.datasetQualifiedName;
        SortedSet<String> powerBITableSourceExpressions = new TreeSet<String>();
        if (b.powerBITableSourceExpressions != null) {
            powerBITableSourceExpressions.addAll(b.powerBITableSourceExpressions);
        }
        powerBITableSourceExpressions = Collections.unmodifiableSortedSet(powerBITableSourceExpressions);
        this.powerBITableSourceExpressions = powerBITableSourceExpressions;
        this.powerBITableColumnCount = b.powerBITableColumnCount;
        this.powerBITableMeasureCount = b.powerBITableMeasureCount;
        SortedSet<PowerBIMeasure> measures = new TreeSet<PowerBIMeasure>();
        if (b.measures != null) {
            measures.addAll(b.measures);
        }
        measures = Collections.unmodifiableSortedSet(measures);
        this.measures = measures;
        SortedSet<PowerBIColumn> columns = new TreeSet<PowerBIColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.dataset = b.dataset;
    }

    @Generated
    public static PowerBITableBuilder<?, ?> builder() {
        return new PowerBITableBuilderImpl();
    }

    @Generated
    public PowerBITableBuilder<?, ?> toBuilder() {
        return new PowerBITableBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Generated
    public SortedSet<String> getPowerBITableSourceExpressions() {
        return this.powerBITableSourceExpressions;
    }

    @Generated
    public Long getPowerBITableColumnCount() {
        return this.powerBITableColumnCount;
    }

    @Generated
    public Long getPowerBITableMeasureCount() {
        return this.powerBITableMeasureCount;
    }

    @Generated
    public SortedSet<PowerBIMeasure> getMeasures() {
        return this.measures;
    }

    @Generated
    public SortedSet<PowerBIColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public PowerBIDataset getDataset() {
        return this.dataset;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setDatasetQualifiedName(String datasetQualifiedName) {
        this.datasetQualifiedName = datasetQualifiedName;
    }

    @Generated
    public void setPowerBITableSourceExpressions(SortedSet<String> powerBITableSourceExpressions) {
        this.powerBITableSourceExpressions = powerBITableSourceExpressions;
    }

    @Generated
    public void setPowerBITableColumnCount(Long powerBITableColumnCount) {
        this.powerBITableColumnCount = powerBITableColumnCount;
    }

    @Generated
    public void setPowerBITableMeasureCount(Long powerBITableMeasureCount) {
        this.powerBITableMeasureCount = powerBITableMeasureCount;
    }

    @Generated
    public void setMeasures(SortedSet<PowerBIMeasure> measures) {
        this.measures = measures;
    }

    @Generated
    public void setColumns(SortedSet<PowerBIColumn> columns) {
        this.columns = columns;
    }

    @Generated
    public void setDataset(PowerBIDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBITable)) {
            return false;
        }
        PowerBITable other = (PowerBITable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$powerBITableColumnCount = this.getPowerBITableColumnCount();
        Long other$powerBITableColumnCount = other.getPowerBITableColumnCount();
        if (this$powerBITableColumnCount == null ? other$powerBITableColumnCount != null : !((Object)this$powerBITableColumnCount).equals(other$powerBITableColumnCount)) {
            return false;
        }
        Long this$powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        Long other$powerBITableMeasureCount = other.getPowerBITableMeasureCount();
        if (this$powerBITableMeasureCount == null ? other$powerBITableMeasureCount != null : !((Object)this$powerBITableMeasureCount).equals(other$powerBITableMeasureCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        SortedSet<String> this$powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        SortedSet<String> other$powerBITableSourceExpressions = other.getPowerBITableSourceExpressions();
        if (this$powerBITableSourceExpressions == null ? other$powerBITableSourceExpressions != null : !this$powerBITableSourceExpressions.equals(other$powerBITableSourceExpressions)) {
            return false;
        }
        SortedSet<PowerBIMeasure> this$measures = this.getMeasures();
        SortedSet<PowerBIMeasure> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !this$measures.equals(other$measures)) {
            return false;
        }
        SortedSet<PowerBIColumn> this$columns = this.getColumns();
        SortedSet<PowerBIColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        PowerBIDataset this$dataset = this.getDataset();
        PowerBIDataset other$dataset = other.getDataset();
        return !(this$dataset == null ? other$dataset != null : !((Object)this$dataset).equals(other$dataset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBITable;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $powerBITableColumnCount = this.getPowerBITableColumnCount();
        result = result * 59 + ($powerBITableColumnCount == null ? 43 : ((Object)$powerBITableColumnCount).hashCode());
        Long $powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        result = result * 59 + ($powerBITableMeasureCount == null ? 43 : ((Object)$powerBITableMeasureCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        SortedSet<String> $powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        result = result * 59 + ($powerBITableSourceExpressions == null ? 43 : $powerBITableSourceExpressions.hashCode());
        SortedSet<PowerBIMeasure> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : $measures.hashCode());
        SortedSet<PowerBIColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        PowerBIDataset $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : ((Object)$dataset).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBITableBuilderImpl
    extends PowerBITableBuilder<PowerBITable, PowerBITableBuilderImpl> {
        @Generated
        private PowerBITableBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBITableBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBITable build() {
            return new PowerBITable(this);
        }
    }

    @Generated
    public static abstract class PowerBITableBuilder<C extends PowerBITable, B extends PowerBITableBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private ArrayList<String> powerBITableSourceExpressions;
        @Generated
        private Long powerBITableColumnCount;
        @Generated
        private Long powerBITableMeasureCount;
        @Generated
        private ArrayList<PowerBIMeasure> measures;
        @Generated
        private ArrayList<PowerBIColumn> columns;
        @Generated
        private PowerBIDataset dataset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBITableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBITable instance, PowerBITableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.powerBITableSourceExpressions(instance.powerBITableSourceExpressions == null ? Collections.emptySortedSet() : instance.powerBITableSourceExpressions);
            b.powerBITableColumnCount(instance.powerBITableColumnCount);
            b.powerBITableMeasureCount(instance.powerBITableMeasureCount);
            b.measures(instance.measures == null ? Collections.emptySortedSet() : instance.measures);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.dataset(instance.dataset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBITableSourceExpression(String powerBITableSourceExpression) {
            if (this.powerBITableSourceExpressions == null) {
                this.powerBITableSourceExpressions = new ArrayList();
            }
            this.powerBITableSourceExpressions.add(powerBITableSourceExpression);
            return (B)this.self();
        }

        @Generated
        public B powerBITableSourceExpressions(Collection<? extends String> powerBITableSourceExpressions) {
            if (powerBITableSourceExpressions == null) {
                throw new NullPointerException("powerBITableSourceExpressions cannot be null");
            }
            if (this.powerBITableSourceExpressions == null) {
                this.powerBITableSourceExpressions = new ArrayList();
            }
            this.powerBITableSourceExpressions.addAll(powerBITableSourceExpressions);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBITableSourceExpressions() {
            if (this.powerBITableSourceExpressions != null) {
                this.powerBITableSourceExpressions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBITableColumnCount(Long powerBITableColumnCount) {
            this.powerBITableColumnCount = powerBITableColumnCount;
            return (B)this.self();
        }

        @Generated
        public B powerBITableMeasureCount(Long powerBITableMeasureCount) {
            this.powerBITableMeasureCount = powerBITableMeasureCount;
            return (B)this.self();
        }

        @Generated
        public B measure(PowerBIMeasure measure) {
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.add(measure);
            return (B)this.self();
        }

        @Generated
        public B measures(Collection<? extends PowerBIMeasure> measures) {
            if (measures == null) {
                throw new NullPointerException("measures cannot be null");
            }
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.addAll(measures);
            return (B)this.self();
        }

        @Generated
        public B clearMeasures() {
            if (this.measures != null) {
                this.measures.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B column(PowerBIColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends PowerBIColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            this.dataset = dataset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBITable.PowerBITableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", datasetQualifiedName=" + this.datasetQualifiedName + ", powerBITableSourceExpressions=" + this.powerBITableSourceExpressions + ", powerBITableColumnCount=" + this.powerBITableColumnCount + ", powerBITableMeasureCount=" + this.powerBITableMeasureCount + ", measures=" + this.measures + ", columns=" + this.columns + ", dataset=" + this.dataset + ")";
        }
    }
}

