/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDashboard;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class PowerBITile
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBITile";
    String typeName;
    @Attribute
    String workspaceQualifiedName;
    @Attribute
    String dashboardQualifiedName;
    @Attribute
    PowerBIReport report;
    @Attribute
    PowerBIDataset dataset;
    @Attribute
    PowerBIDashboard dashboard;

    public static PowerBITile refByGuid(String guid) {
        return ((PowerBITileBuilder)PowerBITile.builder().guid(guid)).build();
    }

    public static PowerBITile refByQualifiedName(String qualifiedName) {
        return ((PowerBITileBuilder)PowerBITile.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBITileBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBITileBuilder)((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBITileBuilder<?, ?> trimToRequired() {
        return PowerBITile.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBITile retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBITile) {
            return (PowerBITile)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBITile.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBITile retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBITile) {
            return (PowerBITile)entity;
        }
        throw new NotFoundException("No PowerBITile found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBITile removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBITile)Asset.removeDescription(((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITile removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBITile)Asset.removeUserDescription(((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITile removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBITile)Asset.removeOwners(((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITile updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBITile)Asset.updateCertificate(PowerBITile.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBITile removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBITile)Asset.removeCertificate(((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBITile updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBITile)Asset.updateAnnouncement(PowerBITile.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBITile removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBITile)Asset.removeAnnouncement(((PowerBITileBuilder)PowerBITile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBITile replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITile)Asset.replaceTerms(PowerBITile.updater(qualifiedName, name), terms);
    }

    public static PowerBITile appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITile)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBITile removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBITile)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBITile(PowerBITileBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBITile.$default$typeName();
        this.workspaceQualifiedName = b.workspaceQualifiedName;
        this.dashboardQualifiedName = b.dashboardQualifiedName;
        this.report = b.report;
        this.dataset = b.dataset;
        this.dashboard = b.dashboard;
    }

    @Generated
    public static PowerBITileBuilder<?, ?> builder() {
        return new PowerBITileBuilderImpl();
    }

    @Generated
    public PowerBITileBuilder<?, ?> toBuilder() {
        return new PowerBITileBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Generated
    public String getDashboardQualifiedName() {
        return this.dashboardQualifiedName;
    }

    @Generated
    public PowerBIReport getReport() {
        return this.report;
    }

    @Generated
    public PowerBIDataset getDataset() {
        return this.dataset;
    }

    @Generated
    public PowerBIDashboard getDashboard() {
        return this.dashboard;
    }

    @Generated
    public void setWorkspaceQualifiedName(String workspaceQualifiedName) {
        this.workspaceQualifiedName = workspaceQualifiedName;
    }

    @Generated
    public void setDashboardQualifiedName(String dashboardQualifiedName) {
        this.dashboardQualifiedName = dashboardQualifiedName;
    }

    @Generated
    public void setReport(PowerBIReport report) {
        this.report = report;
    }

    @Generated
    public void setDataset(PowerBIDataset dataset) {
        this.dataset = dataset;
    }

    @Generated
    public void setDashboard(PowerBIDashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBITile)) {
            return false;
        }
        PowerBITile other = (PowerBITile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) {
            return false;
        }
        String this$dashboardQualifiedName = this.getDashboardQualifiedName();
        String other$dashboardQualifiedName = other.getDashboardQualifiedName();
        if (this$dashboardQualifiedName == null ? other$dashboardQualifiedName != null : !this$dashboardQualifiedName.equals(other$dashboardQualifiedName)) {
            return false;
        }
        PowerBIReport this$report = this.getReport();
        PowerBIReport other$report = other.getReport();
        if (this$report == null ? other$report != null : !((Object)this$report).equals(other$report)) {
            return false;
        }
        PowerBIDataset this$dataset = this.getDataset();
        PowerBIDataset other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !((Object)this$dataset).equals(other$dataset)) {
            return false;
        }
        PowerBIDashboard this$dashboard = this.getDashboard();
        PowerBIDashboard other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBITile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        String $dashboardQualifiedName = this.getDashboardQualifiedName();
        result = result * 59 + ($dashboardQualifiedName == null ? 43 : $dashboardQualifiedName.hashCode());
        PowerBIReport $report = this.getReport();
        result = result * 59 + ($report == null ? 43 : ((Object)$report).hashCode());
        PowerBIDataset $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : ((Object)$dataset).hashCode());
        PowerBIDashboard $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBITileBuilderImpl
    extends PowerBITileBuilder<PowerBITile, PowerBITileBuilderImpl> {
        @Generated
        private PowerBITileBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBITileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBITile build() {
            return new PowerBITile(this);
        }
    }

    @Generated
    public static abstract class PowerBITileBuilder<C extends PowerBITile, B extends PowerBITileBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workspaceQualifiedName;
        @Generated
        private String dashboardQualifiedName;
        @Generated
        private PowerBIReport report;
        @Generated
        private PowerBIDataset dataset;
        @Generated
        private PowerBIDashboard dashboard;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBITileBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBITile instance, PowerBITileBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
            b.dashboardQualifiedName(instance.dashboardQualifiedName);
            b.report(instance.report);
            b.dataset(instance.dataset);
            b.dashboard(instance.dashboard);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dashboardQualifiedName(String dashboardQualifiedName) {
            this.dashboardQualifiedName = dashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B report(PowerBIReport report) {
            this.report = report;
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            this.dataset = dataset;
            return (B)this.self();
        }

        @Generated
        public B dashboard(PowerBIDashboard dashboard) {
            this.dashboard = dashboard;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBITile.PowerBITileBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ", dashboardQualifiedName=" + this.dashboardQualifiedName + ", report=" + this.report + ", dataset=" + this.dataset + ", dashboard=" + this.dashboard + ")";
        }
    }
}

