/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.PowerBI;
import com.atlan.model.assets.PowerBIDashboard;
import com.atlan.model.assets.PowerBIDataflow;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PowerBIWorkspace
extends PowerBI {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIWorkspace";
    String typeName;
    @Attribute
    String webUrl;
    @Attribute
    Long reportCount;
    @Attribute
    Long dashboardCount;
    @Attribute
    Long datasetCount;
    @Attribute
    Long dataflowCount;
    @Attribute
    SortedSet<PowerBIReport> reports;
    @Attribute
    SortedSet<PowerBIDataset> datasets;
    @Attribute
    SortedSet<PowerBIDashboard> dashboards;
    @Attribute
    SortedSet<PowerBIDataflow> dataflows;

    public static PowerBIWorkspace refByGuid(String guid) {
        return ((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().guid(guid)).build();
    }

    public static PowerBIWorkspace refByQualifiedName(String qualifiedName) {
        return ((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PowerBIWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIWorkspaceBuilder)((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PowerBIWorkspaceBuilder<?, ?> trimToRequired() {
        return PowerBIWorkspace.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIWorkspace retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PowerBIWorkspace) {
            return (PowerBIWorkspace)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PowerBIWorkspace.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PowerBIWorkspace retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PowerBIWorkspace) {
            return (PowerBIWorkspace)entity;
        }
        throw new NotFoundException("No PowerBIWorkspace found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PowerBIWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeDescription(((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeUserDescription(((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeOwners(((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIWorkspace updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIWorkspace)Asset.updateCertificate(PowerBIWorkspace.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeCertificate(((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PowerBIWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIWorkspace)Asset.updateAnnouncement(PowerBIWorkspace.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeAnnouncement(((PowerBIWorkspaceBuilder)PowerBIWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PowerBIWorkspace replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace)Asset.replaceTerms(PowerBIWorkspace.updater(qualifiedName, name), terms);
    }

    public static PowerBIWorkspace appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIWorkspace removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIWorkspace(PowerBIWorkspaceBuilder<?, ?> b) {
        super((PowerBI.PowerBIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIWorkspace.$default$typeName();
        this.webUrl = b.webUrl;
        this.reportCount = b.reportCount;
        this.dashboardCount = b.dashboardCount;
        this.datasetCount = b.datasetCount;
        this.dataflowCount = b.dataflowCount;
        SortedSet<PowerBIReport> reports = new TreeSet<PowerBIReport>();
        if (b.reports != null) {
            reports.addAll(b.reports);
        }
        reports = Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        SortedSet<PowerBIDataset> datasets = new TreeSet<PowerBIDataset>();
        if (b.datasets != null) {
            datasets.addAll(b.datasets);
        }
        datasets = Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
        SortedSet<PowerBIDashboard> dashboards = new TreeSet<PowerBIDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        SortedSet<PowerBIDataflow> dataflows = new TreeSet<PowerBIDataflow>();
        if (b.dataflows != null) {
            dataflows.addAll(b.dataflows);
        }
        dataflows = Collections.unmodifiableSortedSet(dataflows);
        this.dataflows = dataflows;
    }

    @Generated
    public static PowerBIWorkspaceBuilder<?, ?> builder() {
        return new PowerBIWorkspaceBuilderImpl();
    }

    @Generated
    public PowerBIWorkspaceBuilder<?, ?> toBuilder() {
        return new PowerBIWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public Long getReportCount() {
        return this.reportCount;
    }

    @Generated
    public Long getDashboardCount() {
        return this.dashboardCount;
    }

    @Generated
    public Long getDatasetCount() {
        return this.datasetCount;
    }

    @Generated
    public Long getDataflowCount() {
        return this.dataflowCount;
    }

    @Generated
    public SortedSet<PowerBIReport> getReports() {
        return this.reports;
    }

    @Generated
    public SortedSet<PowerBIDataset> getDatasets() {
        return this.datasets;
    }

    @Generated
    public SortedSet<PowerBIDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public SortedSet<PowerBIDataflow> getDataflows() {
        return this.dataflows;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setReportCount(Long reportCount) {
        this.reportCount = reportCount;
    }

    @Generated
    public void setDashboardCount(Long dashboardCount) {
        this.dashboardCount = dashboardCount;
    }

    @Generated
    public void setDatasetCount(Long datasetCount) {
        this.datasetCount = datasetCount;
    }

    @Generated
    public void setDataflowCount(Long dataflowCount) {
        this.dataflowCount = dataflowCount;
    }

    @Generated
    public void setReports(SortedSet<PowerBIReport> reports) {
        this.reports = reports;
    }

    @Generated
    public void setDatasets(SortedSet<PowerBIDataset> datasets) {
        this.datasets = datasets;
    }

    @Generated
    public void setDashboards(SortedSet<PowerBIDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Generated
    public void setDataflows(SortedSet<PowerBIDataflow> dataflows) {
        this.dataflows = dataflows;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIWorkspace)) {
            return false;
        }
        PowerBIWorkspace other = (PowerBIWorkspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$reportCount = this.getReportCount();
        Long other$reportCount = other.getReportCount();
        if (this$reportCount == null ? other$reportCount != null : !((Object)this$reportCount).equals(other$reportCount)) {
            return false;
        }
        Long this$dashboardCount = this.getDashboardCount();
        Long other$dashboardCount = other.getDashboardCount();
        if (this$dashboardCount == null ? other$dashboardCount != null : !((Object)this$dashboardCount).equals(other$dashboardCount)) {
            return false;
        }
        Long this$datasetCount = this.getDatasetCount();
        Long other$datasetCount = other.getDatasetCount();
        if (this$datasetCount == null ? other$datasetCount != null : !((Object)this$datasetCount).equals(other$datasetCount)) {
            return false;
        }
        Long this$dataflowCount = this.getDataflowCount();
        Long other$dataflowCount = other.getDataflowCount();
        if (this$dataflowCount == null ? other$dataflowCount != null : !((Object)this$dataflowCount).equals(other$dataflowCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        SortedSet<PowerBIReport> this$reports = this.getReports();
        SortedSet<PowerBIReport> other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) {
            return false;
        }
        SortedSet<PowerBIDataset> this$datasets = this.getDatasets();
        SortedSet<PowerBIDataset> other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets)) {
            return false;
        }
        SortedSet<PowerBIDashboard> this$dashboards = this.getDashboards();
        SortedSet<PowerBIDashboard> other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) {
            return false;
        }
        SortedSet<PowerBIDataflow> this$dataflows = this.getDataflows();
        SortedSet<PowerBIDataflow> other$dataflows = other.getDataflows();
        return !(this$dataflows == null ? other$dataflows != null : !this$dataflows.equals(other$dataflows));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIWorkspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $reportCount = this.getReportCount();
        result = result * 59 + ($reportCount == null ? 43 : ((Object)$reportCount).hashCode());
        Long $dashboardCount = this.getDashboardCount();
        result = result * 59 + ($dashboardCount == null ? 43 : ((Object)$dashboardCount).hashCode());
        Long $datasetCount = this.getDatasetCount();
        result = result * 59 + ($datasetCount == null ? 43 : ((Object)$datasetCount).hashCode());
        Long $dataflowCount = this.getDataflowCount();
        result = result * 59 + ($dataflowCount == null ? 43 : ((Object)$dataflowCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        SortedSet<PowerBIReport> $reports = this.getReports();
        result = result * 59 + ($reports == null ? 43 : $reports.hashCode());
        SortedSet<PowerBIDataset> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : $datasets.hashCode());
        SortedSet<PowerBIDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        SortedSet<PowerBIDataflow> $dataflows = this.getDataflows();
        result = result * 59 + ($dataflows == null ? 43 : $dataflows.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PowerBIWorkspaceBuilderImpl
    extends PowerBIWorkspaceBuilder<PowerBIWorkspace, PowerBIWorkspaceBuilderImpl> {
        @Generated
        private PowerBIWorkspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIWorkspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIWorkspace build() {
            return new PowerBIWorkspace(this);
        }
    }

    @Generated
    public static abstract class PowerBIWorkspaceBuilder<C extends PowerBIWorkspace, B extends PowerBIWorkspaceBuilder<C, B>>
    extends PowerBI.PowerBIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String webUrl;
        @Generated
        private Long reportCount;
        @Generated
        private Long dashboardCount;
        @Generated
        private Long datasetCount;
        @Generated
        private Long dataflowCount;
        @Generated
        private ArrayList<PowerBIReport> reports;
        @Generated
        private ArrayList<PowerBIDataset> datasets;
        @Generated
        private ArrayList<PowerBIDashboard> dashboards;
        @Generated
        private ArrayList<PowerBIDataflow> dataflows;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIWorkspace instance, PowerBIWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.webUrl(instance.webUrl);
            b.reportCount(instance.reportCount);
            b.dashboardCount(instance.dashboardCount);
            b.datasetCount(instance.datasetCount);
            b.dataflowCount(instance.dataflowCount);
            b.reports(instance.reports == null ? Collections.emptySortedSet() : instance.reports);
            b.datasets(instance.datasets == null ? Collections.emptySortedSet() : instance.datasets);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
            b.dataflows(instance.dataflows == null ? Collections.emptySortedSet() : instance.dataflows);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B reportCount(Long reportCount) {
            this.reportCount = reportCount;
            return (B)this.self();
        }

        @Generated
        public B dashboardCount(Long dashboardCount) {
            this.dashboardCount = dashboardCount;
            return (B)this.self();
        }

        @Generated
        public B datasetCount(Long datasetCount) {
            this.datasetCount = datasetCount;
            return (B)this.self();
        }

        @Generated
        public B dataflowCount(Long dataflowCount) {
            this.dataflowCount = dataflowCount;
            return (B)this.self();
        }

        @Generated
        public B report(PowerBIReport report) {
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.add(report);
            return (B)this.self();
        }

        @Generated
        public B reports(Collection<? extends PowerBIReport> reports) {
            if (reports == null) {
                throw new NullPointerException("reports cannot be null");
            }
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.addAll(reports);
            return (B)this.self();
        }

        @Generated
        public B clearReports() {
            if (this.reports != null) {
                this.reports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(PowerBIDataset dataset) {
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.add(dataset);
            return (B)this.self();
        }

        @Generated
        public B datasets(Collection<? extends PowerBIDataset> datasets) {
            if (datasets == null) {
                throw new NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.addAll(datasets);
            return (B)this.self();
        }

        @Generated
        public B clearDatasets() {
            if (this.datasets != null) {
                this.datasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dashboard(PowerBIDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends PowerBIDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataflow(PowerBIDataflow dataflow) {
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.add(dataflow);
            return (B)this.self();
        }

        @Generated
        public B dataflows(Collection<? extends PowerBIDataflow> dataflows) {
            if (dataflows == null) {
                throw new NullPointerException("dataflows cannot be null");
            }
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.addAll(dataflows);
            return (B)this.self();
        }

        @Generated
        public B clearDataflows() {
            if (this.dataflows != null) {
                this.dataflows.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIWorkspace.PowerBIWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", webUrl=" + this.webUrl + ", reportCount=" + this.reportCount + ", dashboardCount=" + this.dashboardCount + ", datasetCount=" + this.datasetCount + ", dataflowCount=" + this.dataflowCount + ", reports=" + this.reports + ", datasets=" + this.datasets + ", dashboards=" + this.dashboards + ", dataflows=" + this.dataflows + ")";
        }
    }
}

