/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Preset;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PresetChart
extends Preset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetChart";
    String typeName;
    @Attribute
    String presetChartDescriptionMarkdown;
    @Attribute
    Map<String, String> presetChartFormData;
    @Attribute
    PresetDashboard presetDashboard;

    public static PresetChart refByGuid(String guid) {
        return ((PresetChartBuilder)PresetChart.builder().guid(guid)).build();
    }

    public static PresetChart refByQualifiedName(String qualifiedName) {
        return ((PresetChartBuilder)PresetChart.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PresetChartBuilder<?, ?> creator(String name, String collectionQualifiedName) {
        String[] tokens = collectionQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String workspaceQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(collectionQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return (PresetChartBuilder)((PresetChartBuilder)((Preset.PresetBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)PresetChart.builder().name(name)).qualifiedName(collectionQualifiedName + "/" + name)).connectorType(connectorType)).presetDashboardQualifiedName(collectionQualifiedName)).presetDashboard(PresetDashboard.refByQualifiedName(collectionQualifiedName))).presetWorkspaceQualifiedName(workspaceQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetChartBuilder)((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PresetChartBuilder<?, ?> trimToRequired() {
        return PresetChart.updater(this.getQualifiedName(), this.getName());
    }

    public static PresetChart retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PresetChart) {
            return (PresetChart)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PresetChart.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PresetChart retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PresetChart) {
            return (PresetChart)entity;
        }
        throw new NotFoundException("No PresetChart found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PresetChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeDescription(((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeUserDescription(((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeOwners(((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetChart updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PresetChart)Asset.updateCertificate(PresetChart.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeCertificate(((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetChart)Asset.updateAnnouncement(PresetChart.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeAnnouncement(((PresetChartBuilder)PresetChart.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PresetChart replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.replaceTerms(PresetChart.updater(qualifiedName, name), terms);
    }

    public static PresetChart appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PresetChart removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetChart(PresetChartBuilder<?, ?> b) {
        super((Preset.PresetBuilder<?, ?>)b);
        Map<Object, Object> presetChartFormData;
        this.typeName = b.typeName$set ? b.typeName$value : PresetChart.$default$typeName();
        this.presetChartDescriptionMarkdown = b.presetChartDescriptionMarkdown;
        switch (b.presetChartFormData$key == null ? 0 : b.presetChartFormData$key.size()) {
            case 0: {
                presetChartFormData = Collections.emptyMap();
                break;
            }
            case 1: {
                presetChartFormData = Collections.singletonMap(b.presetChartFormData$key.get(0), b.presetChartFormData$value.get(0));
                break;
            }
            default: {
                presetChartFormData = new LinkedHashMap(b.presetChartFormData$key.size() < 0x40000000 ? 1 + b.presetChartFormData$key.size() + (b.presetChartFormData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.presetChartFormData$key.size(); ++$i) {
                    presetChartFormData.put(b.presetChartFormData$key.get($i), b.presetChartFormData$value.get($i));
                }
                presetChartFormData = Collections.unmodifiableMap(presetChartFormData);
            }
        }
        this.presetChartFormData = presetChartFormData;
        this.presetDashboard = b.presetDashboard;
    }

    @Generated
    public static PresetChartBuilder<?, ?> builder() {
        return new PresetChartBuilderImpl();
    }

    @Generated
    public PresetChartBuilder<?, ?> toBuilder() {
        return new PresetChartBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getPresetChartDescriptionMarkdown() {
        return this.presetChartDescriptionMarkdown;
    }

    @Generated
    public Map<String, String> getPresetChartFormData() {
        return this.presetChartFormData;
    }

    @Generated
    public PresetDashboard getPresetDashboard() {
        return this.presetDashboard;
    }

    @Generated
    public void setPresetChartDescriptionMarkdown(String presetChartDescriptionMarkdown) {
        this.presetChartDescriptionMarkdown = presetChartDescriptionMarkdown;
    }

    @Generated
    public void setPresetChartFormData(Map<String, String> presetChartFormData) {
        this.presetChartFormData = presetChartFormData;
    }

    @Generated
    public void setPresetDashboard(PresetDashboard presetDashboard) {
        this.presetDashboard = presetDashboard;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetChart)) {
            return false;
        }
        PresetChart other = (PresetChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$presetChartDescriptionMarkdown = this.getPresetChartDescriptionMarkdown();
        String other$presetChartDescriptionMarkdown = other.getPresetChartDescriptionMarkdown();
        if (this$presetChartDescriptionMarkdown == null ? other$presetChartDescriptionMarkdown != null : !this$presetChartDescriptionMarkdown.equals(other$presetChartDescriptionMarkdown)) {
            return false;
        }
        Map<String, String> this$presetChartFormData = this.getPresetChartFormData();
        Map<String, String> other$presetChartFormData = other.getPresetChartFormData();
        if (this$presetChartFormData == null ? other$presetChartFormData != null : !((Object)this$presetChartFormData).equals(other$presetChartFormData)) {
            return false;
        }
        PresetDashboard this$presetDashboard = this.getPresetDashboard();
        PresetDashboard other$presetDashboard = other.getPresetDashboard();
        return !(this$presetDashboard == null ? other$presetDashboard != null : !((Object)this$presetDashboard).equals(other$presetDashboard));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetChart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $presetChartDescriptionMarkdown = this.getPresetChartDescriptionMarkdown();
        result = result * 59 + ($presetChartDescriptionMarkdown == null ? 43 : $presetChartDescriptionMarkdown.hashCode());
        Map<String, String> $presetChartFormData = this.getPresetChartFormData();
        result = result * 59 + ($presetChartFormData == null ? 43 : ((Object)$presetChartFormData).hashCode());
        PresetDashboard $presetDashboard = this.getPresetDashboard();
        result = result * 59 + ($presetDashboard == null ? 43 : ((Object)$presetDashboard).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PresetChartBuilderImpl
    extends PresetChartBuilder<PresetChart, PresetChartBuilderImpl> {
        @Generated
        private PresetChartBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetChartBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetChart build() {
            return new PresetChart(this);
        }
    }

    @Generated
    public static abstract class PresetChartBuilder<C extends PresetChart, B extends PresetChartBuilder<C, B>>
    extends Preset.PresetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String presetChartDescriptionMarkdown;
        @Generated
        private ArrayList<String> presetChartFormData$key;
        @Generated
        private ArrayList<String> presetChartFormData$value;
        @Generated
        private PresetDashboard presetDashboard;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetChart instance, PresetChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.presetChartDescriptionMarkdown(instance.presetChartDescriptionMarkdown);
            b.presetChartFormData(instance.presetChartFormData == null ? Collections.emptyMap() : instance.presetChartFormData);
            b.presetDashboard(instance.presetDashboard);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B presetChartDescriptionMarkdown(String presetChartDescriptionMarkdown) {
            this.presetChartDescriptionMarkdown = presetChartDescriptionMarkdown;
            return (B)this.self();
        }

        @Generated
        public B putPresetChartFormData(String putPresetChartFormDataKey, String putPresetChartFormDataValue) {
            if (this.presetChartFormData$key == null) {
                this.presetChartFormData$key = new ArrayList();
                this.presetChartFormData$value = new ArrayList();
            }
            this.presetChartFormData$key.add(putPresetChartFormDataKey);
            this.presetChartFormData$value.add(putPresetChartFormDataValue);
            return (B)this.self();
        }

        @Generated
        public B presetChartFormData(Map<? extends String, ? extends String> presetChartFormData) {
            if (presetChartFormData == null) {
                throw new NullPointerException("presetChartFormData cannot be null");
            }
            if (this.presetChartFormData$key == null) {
                this.presetChartFormData$key = new ArrayList();
                this.presetChartFormData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : presetChartFormData.entrySet()) {
                this.presetChartFormData$key.add($lombokEntry.getKey());
                this.presetChartFormData$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearPresetChartFormData() {
            if (this.presetChartFormData$key != null) {
                this.presetChartFormData$key.clear();
                this.presetChartFormData$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetDashboard(PresetDashboard presetDashboard) {
            this.presetDashboard = presetDashboard;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PresetChart.PresetChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", presetChartDescriptionMarkdown=" + this.presetChartDescriptionMarkdown + ", presetChartFormData$key=" + this.presetChartFormData$key + ", presetChartFormData$value=" + this.presetChartFormData$value + ", presetDashboard=" + this.presetDashboard + ")";
        }
    }
}

