/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Preset;
import com.atlan.model.assets.PresetChart;
import com.atlan.model.assets.PresetDataset;
import com.atlan.model.assets.PresetWorkspace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PresetDashboard
extends Preset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetDashboard";
    String typeName;
    @Attribute
    String presetDashboardChangedByName;
    @Attribute
    String presetDashboardChangedByURL;
    @Attribute
    Boolean presetDashboardIsManagedExternally;
    @Attribute
    Boolean presetDashboardIsPublished;
    @Attribute
    String presetDashboardThumbnailURL;
    @Attribute
    Long presetDashboardChartCount;
    @Attribute
    SortedSet<PresetDataset> presetDatasets;
    @Attribute
    SortedSet<PresetChart> presetCharts;
    @Attribute
    PresetWorkspace presetWorkspace;

    public static PresetDashboard refByGuid(String guid) {
        return ((PresetDashboardBuilder)PresetDashboard.builder().guid(guid)).build();
    }

    public static PresetDashboard refByQualifiedName(String qualifiedName) {
        return ((PresetDashboardBuilder)PresetDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PresetDashboardBuilder<?, ?> creator(String name, String workspaceQualifiedName) {
        String[] tokens = workspaceQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return (PresetDashboardBuilder)((Asset.AssetBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard.builder().name(name)).qualifiedName(workspaceQualifiedName + "/" + name)).connectorType(connectorType)).presetWorkspaceQualifiedName(workspaceQualifiedName)).presetWorkspace(PresetWorkspace.refByQualifiedName(workspaceQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PresetDashboardBuilder<?, ?> trimToRequired() {
        return PresetDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static PresetDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PresetDashboard) {
            return (PresetDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PresetDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PresetDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PresetDashboard) {
            return (PresetDashboard)entity;
        }
        throw new NotFoundException("No PresetDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PresetDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeDescription(((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeUserDescription(((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeOwners(((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PresetDashboard)Asset.updateCertificate(PresetDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeCertificate(((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetDashboard)Asset.updateAnnouncement(PresetDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeAnnouncement(((PresetDashboardBuilder)PresetDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PresetDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.replaceTerms(PresetDashboard.updater(qualifiedName, name), terms);
    }

    public static PresetDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PresetDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetDashboard(PresetDashboardBuilder<?, ?> b) {
        super((Preset.PresetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PresetDashboard.$default$typeName();
        this.presetDashboardChangedByName = b.presetDashboardChangedByName;
        this.presetDashboardChangedByURL = b.presetDashboardChangedByURL;
        this.presetDashboardIsManagedExternally = b.presetDashboardIsManagedExternally;
        this.presetDashboardIsPublished = b.presetDashboardIsPublished;
        this.presetDashboardThumbnailURL = b.presetDashboardThumbnailURL;
        this.presetDashboardChartCount = b.presetDashboardChartCount;
        SortedSet<PresetDataset> presetDatasets = new TreeSet<PresetDataset>();
        if (b.presetDatasets != null) {
            presetDatasets.addAll(b.presetDatasets);
        }
        presetDatasets = Collections.unmodifiableSortedSet(presetDatasets);
        this.presetDatasets = presetDatasets;
        SortedSet<PresetChart> presetCharts = new TreeSet<PresetChart>();
        if (b.presetCharts != null) {
            presetCharts.addAll(b.presetCharts);
        }
        presetCharts = Collections.unmodifiableSortedSet(presetCharts);
        this.presetCharts = presetCharts;
        this.presetWorkspace = b.presetWorkspace;
    }

    @Generated
    public static PresetDashboardBuilder<?, ?> builder() {
        return new PresetDashboardBuilderImpl();
    }

    @Generated
    public PresetDashboardBuilder<?, ?> toBuilder() {
        return new PresetDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getPresetDashboardChangedByName() {
        return this.presetDashboardChangedByName;
    }

    @Generated
    public String getPresetDashboardChangedByURL() {
        return this.presetDashboardChangedByURL;
    }

    @Generated
    public Boolean getPresetDashboardIsManagedExternally() {
        return this.presetDashboardIsManagedExternally;
    }

    @Generated
    public Boolean getPresetDashboardIsPublished() {
        return this.presetDashboardIsPublished;
    }

    @Generated
    public String getPresetDashboardThumbnailURL() {
        return this.presetDashboardThumbnailURL;
    }

    @Generated
    public Long getPresetDashboardChartCount() {
        return this.presetDashboardChartCount;
    }

    @Generated
    public SortedSet<PresetDataset> getPresetDatasets() {
        return this.presetDatasets;
    }

    @Generated
    public SortedSet<PresetChart> getPresetCharts() {
        return this.presetCharts;
    }

    @Generated
    public PresetWorkspace getPresetWorkspace() {
        return this.presetWorkspace;
    }

    @Generated
    public void setPresetDashboardChangedByName(String presetDashboardChangedByName) {
        this.presetDashboardChangedByName = presetDashboardChangedByName;
    }

    @Generated
    public void setPresetDashboardChangedByURL(String presetDashboardChangedByURL) {
        this.presetDashboardChangedByURL = presetDashboardChangedByURL;
    }

    @Generated
    public void setPresetDashboardIsManagedExternally(Boolean presetDashboardIsManagedExternally) {
        this.presetDashboardIsManagedExternally = presetDashboardIsManagedExternally;
    }

    @Generated
    public void setPresetDashboardIsPublished(Boolean presetDashboardIsPublished) {
        this.presetDashboardIsPublished = presetDashboardIsPublished;
    }

    @Generated
    public void setPresetDashboardThumbnailURL(String presetDashboardThumbnailURL) {
        this.presetDashboardThumbnailURL = presetDashboardThumbnailURL;
    }

    @Generated
    public void setPresetDashboardChartCount(Long presetDashboardChartCount) {
        this.presetDashboardChartCount = presetDashboardChartCount;
    }

    @Generated
    public void setPresetDatasets(SortedSet<PresetDataset> presetDatasets) {
        this.presetDatasets = presetDatasets;
    }

    @Generated
    public void setPresetCharts(SortedSet<PresetChart> presetCharts) {
        this.presetCharts = presetCharts;
    }

    @Generated
    public void setPresetWorkspace(PresetWorkspace presetWorkspace) {
        this.presetWorkspace = presetWorkspace;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetDashboard)) {
            return false;
        }
        PresetDashboard other = (PresetDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        Boolean other$presetDashboardIsManagedExternally = other.getPresetDashboardIsManagedExternally();
        if (this$presetDashboardIsManagedExternally == null ? other$presetDashboardIsManagedExternally != null : !((Object)this$presetDashboardIsManagedExternally).equals(other$presetDashboardIsManagedExternally)) {
            return false;
        }
        Boolean this$presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        Boolean other$presetDashboardIsPublished = other.getPresetDashboardIsPublished();
        if (this$presetDashboardIsPublished == null ? other$presetDashboardIsPublished != null : !((Object)this$presetDashboardIsPublished).equals(other$presetDashboardIsPublished)) {
            return false;
        }
        Long this$presetDashboardChartCount = this.getPresetDashboardChartCount();
        Long other$presetDashboardChartCount = other.getPresetDashboardChartCount();
        if (this$presetDashboardChartCount == null ? other$presetDashboardChartCount != null : !((Object)this$presetDashboardChartCount).equals(other$presetDashboardChartCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        String other$presetDashboardChangedByName = other.getPresetDashboardChangedByName();
        if (this$presetDashboardChangedByName == null ? other$presetDashboardChangedByName != null : !this$presetDashboardChangedByName.equals(other$presetDashboardChangedByName)) {
            return false;
        }
        String this$presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        String other$presetDashboardChangedByURL = other.getPresetDashboardChangedByURL();
        if (this$presetDashboardChangedByURL == null ? other$presetDashboardChangedByURL != null : !this$presetDashboardChangedByURL.equals(other$presetDashboardChangedByURL)) {
            return false;
        }
        String this$presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        String other$presetDashboardThumbnailURL = other.getPresetDashboardThumbnailURL();
        if (this$presetDashboardThumbnailURL == null ? other$presetDashboardThumbnailURL != null : !this$presetDashboardThumbnailURL.equals(other$presetDashboardThumbnailURL)) {
            return false;
        }
        SortedSet<PresetDataset> this$presetDatasets = this.getPresetDatasets();
        SortedSet<PresetDataset> other$presetDatasets = other.getPresetDatasets();
        if (this$presetDatasets == null ? other$presetDatasets != null : !this$presetDatasets.equals(other$presetDatasets)) {
            return false;
        }
        SortedSet<PresetChart> this$presetCharts = this.getPresetCharts();
        SortedSet<PresetChart> other$presetCharts = other.getPresetCharts();
        if (this$presetCharts == null ? other$presetCharts != null : !this$presetCharts.equals(other$presetCharts)) {
            return false;
        }
        PresetWorkspace this$presetWorkspace = this.getPresetWorkspace();
        PresetWorkspace other$presetWorkspace = other.getPresetWorkspace();
        return !(this$presetWorkspace == null ? other$presetWorkspace != null : !((Object)this$presetWorkspace).equals(other$presetWorkspace));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        result = result * 59 + ($presetDashboardIsManagedExternally == null ? 43 : ((Object)$presetDashboardIsManagedExternally).hashCode());
        Boolean $presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        result = result * 59 + ($presetDashboardIsPublished == null ? 43 : ((Object)$presetDashboardIsPublished).hashCode());
        Long $presetDashboardChartCount = this.getPresetDashboardChartCount();
        result = result * 59 + ($presetDashboardChartCount == null ? 43 : ((Object)$presetDashboardChartCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        result = result * 59 + ($presetDashboardChangedByName == null ? 43 : $presetDashboardChangedByName.hashCode());
        String $presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        result = result * 59 + ($presetDashboardChangedByURL == null ? 43 : $presetDashboardChangedByURL.hashCode());
        String $presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        result = result * 59 + ($presetDashboardThumbnailURL == null ? 43 : $presetDashboardThumbnailURL.hashCode());
        SortedSet<PresetDataset> $presetDatasets = this.getPresetDatasets();
        result = result * 59 + ($presetDatasets == null ? 43 : $presetDatasets.hashCode());
        SortedSet<PresetChart> $presetCharts = this.getPresetCharts();
        result = result * 59 + ($presetCharts == null ? 43 : $presetCharts.hashCode());
        PresetWorkspace $presetWorkspace = this.getPresetWorkspace();
        result = result * 59 + ($presetWorkspace == null ? 43 : ((Object)$presetWorkspace).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PresetDashboardBuilderImpl
    extends PresetDashboardBuilder<PresetDashboard, PresetDashboardBuilderImpl> {
        @Generated
        private PresetDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetDashboard build() {
            return new PresetDashboard(this);
        }
    }

    @Generated
    public static abstract class PresetDashboardBuilder<C extends PresetDashboard, B extends PresetDashboardBuilder<C, B>>
    extends Preset.PresetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String presetDashboardChangedByName;
        @Generated
        private String presetDashboardChangedByURL;
        @Generated
        private Boolean presetDashboardIsManagedExternally;
        @Generated
        private Boolean presetDashboardIsPublished;
        @Generated
        private String presetDashboardThumbnailURL;
        @Generated
        private Long presetDashboardChartCount;
        @Generated
        private ArrayList<PresetDataset> presetDatasets;
        @Generated
        private ArrayList<PresetChart> presetCharts;
        @Generated
        private PresetWorkspace presetWorkspace;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetDashboard instance, PresetDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.presetDashboardChangedByName(instance.presetDashboardChangedByName);
            b.presetDashboardChangedByURL(instance.presetDashboardChangedByURL);
            b.presetDashboardIsManagedExternally(instance.presetDashboardIsManagedExternally);
            b.presetDashboardIsPublished(instance.presetDashboardIsPublished);
            b.presetDashboardThumbnailURL(instance.presetDashboardThumbnailURL);
            b.presetDashboardChartCount(instance.presetDashboardChartCount);
            b.presetDatasets(instance.presetDatasets == null ? Collections.emptySortedSet() : instance.presetDatasets);
            b.presetCharts(instance.presetCharts == null ? Collections.emptySortedSet() : instance.presetCharts);
            b.presetWorkspace(instance.presetWorkspace);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChangedByName(String presetDashboardChangedByName) {
            this.presetDashboardChangedByName = presetDashboardChangedByName;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChangedByURL(String presetDashboardChangedByURL) {
            this.presetDashboardChangedByURL = presetDashboardChangedByURL;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardIsManagedExternally(Boolean presetDashboardIsManagedExternally) {
            this.presetDashboardIsManagedExternally = presetDashboardIsManagedExternally;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardIsPublished(Boolean presetDashboardIsPublished) {
            this.presetDashboardIsPublished = presetDashboardIsPublished;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardThumbnailURL(String presetDashboardThumbnailURL) {
            this.presetDashboardThumbnailURL = presetDashboardThumbnailURL;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChartCount(Long presetDashboardChartCount) {
            this.presetDashboardChartCount = presetDashboardChartCount;
            return (B)this.self();
        }

        @Generated
        public B presetDataset(PresetDataset presetDataset) {
            if (this.presetDatasets == null) {
                this.presetDatasets = new ArrayList();
            }
            this.presetDatasets.add(presetDataset);
            return (B)this.self();
        }

        @Generated
        public B presetDatasets(Collection<? extends PresetDataset> presetDatasets) {
            if (presetDatasets == null) {
                throw new NullPointerException("presetDatasets cannot be null");
            }
            if (this.presetDatasets == null) {
                this.presetDatasets = new ArrayList();
            }
            this.presetDatasets.addAll(presetDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearPresetDatasets() {
            if (this.presetDatasets != null) {
                this.presetDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetChart(PresetChart presetChart) {
            if (this.presetCharts == null) {
                this.presetCharts = new ArrayList();
            }
            this.presetCharts.add(presetChart);
            return (B)this.self();
        }

        @Generated
        public B presetCharts(Collection<? extends PresetChart> presetCharts) {
            if (presetCharts == null) {
                throw new NullPointerException("presetCharts cannot be null");
            }
            if (this.presetCharts == null) {
                this.presetCharts = new ArrayList();
            }
            this.presetCharts.addAll(presetCharts);
            return (B)this.self();
        }

        @Generated
        public B clearPresetCharts() {
            if (this.presetCharts != null) {
                this.presetCharts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetWorkspace(PresetWorkspace presetWorkspace) {
            this.presetWorkspace = presetWorkspace;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PresetDashboard.PresetDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", presetDashboardChangedByName=" + this.presetDashboardChangedByName + ", presetDashboardChangedByURL=" + this.presetDashboardChangedByURL + ", presetDashboardIsManagedExternally=" + this.presetDashboardIsManagedExternally + ", presetDashboardIsPublished=" + this.presetDashboardIsPublished + ", presetDashboardThumbnailURL=" + this.presetDashboardThumbnailURL + ", presetDashboardChartCount=" + this.presetDashboardChartCount + ", presetDatasets=" + this.presetDatasets + ", presetCharts=" + this.presetCharts + ", presetWorkspace=" + this.presetWorkspace + ")";
        }
    }
}

