/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Preset;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import java.util.List;
import lombok.Generated;

public class PresetDataset
extends Preset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetDataset";
    String typeName;
    @Attribute
    String presetDatasetDatasourceName;
    @Attribute
    Long presetDatasetId;
    @Attribute
    String presetDatasetType;
    @Attribute
    PresetDashboard presetDashboard;

    public static PresetDataset refByGuid(String guid) {
        return ((PresetDatasetBuilder)PresetDataset.builder().guid(guid)).build();
    }

    public static PresetDataset refByQualifiedName(String qualifiedName) {
        return ((PresetDatasetBuilder)PresetDataset.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PresetDatasetBuilder<?, ?> creator(String name, String collectionQualifiedName) {
        String[] tokens = collectionQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String workspaceQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(collectionQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return (PresetDatasetBuilder)((PresetDatasetBuilder)((Preset.PresetBuilder)((PresetDatasetBuilder)((PresetDatasetBuilder)((PresetDatasetBuilder)((PresetDatasetBuilder)PresetDataset.builder().name(name)).qualifiedName(collectionQualifiedName + "/" + name)).connectorType(connectorType)).presetDashboardQualifiedName(collectionQualifiedName)).presetDashboard(PresetDashboard.refByQualifiedName(collectionQualifiedName))).presetWorkspaceQualifiedName(workspaceQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetDatasetBuilder)((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PresetDatasetBuilder<?, ?> trimToRequired() {
        return PresetDataset.updater(this.getQualifiedName(), this.getName());
    }

    public static PresetDataset retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PresetDataset) {
            return (PresetDataset)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PresetDataset.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PresetDataset retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PresetDataset) {
            return (PresetDataset)entity;
        }
        throw new NotFoundException("No PresetDataset found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PresetDataset removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetDataset)Asset.removeDescription(((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDataset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetDataset)Asset.removeUserDescription(((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDataset removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PresetDataset)Asset.removeOwners(((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDataset updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PresetDataset)Asset.updateCertificate(PresetDataset.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetDataset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PresetDataset)Asset.removeCertificate(((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetDataset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetDataset)Asset.updateAnnouncement(PresetDataset.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetDataset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PresetDataset)Asset.removeAnnouncement(((PresetDatasetBuilder)PresetDataset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PresetDataset replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDataset)Asset.replaceTerms(PresetDataset.updater(qualifiedName, name), terms);
    }

    public static PresetDataset appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDataset)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PresetDataset removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetDataset)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetDataset(PresetDatasetBuilder<?, ?> b) {
        super((Preset.PresetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PresetDataset.$default$typeName();
        this.presetDatasetDatasourceName = b.presetDatasetDatasourceName;
        this.presetDatasetId = b.presetDatasetId;
        this.presetDatasetType = b.presetDatasetType;
        this.presetDashboard = b.presetDashboard;
    }

    @Generated
    public static PresetDatasetBuilder<?, ?> builder() {
        return new PresetDatasetBuilderImpl();
    }

    @Generated
    public PresetDatasetBuilder<?, ?> toBuilder() {
        return new PresetDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getPresetDatasetDatasourceName() {
        return this.presetDatasetDatasourceName;
    }

    @Generated
    public Long getPresetDatasetId() {
        return this.presetDatasetId;
    }

    @Generated
    public String getPresetDatasetType() {
        return this.presetDatasetType;
    }

    @Generated
    public PresetDashboard getPresetDashboard() {
        return this.presetDashboard;
    }

    @Generated
    public void setPresetDatasetDatasourceName(String presetDatasetDatasourceName) {
        this.presetDatasetDatasourceName = presetDatasetDatasourceName;
    }

    @Generated
    public void setPresetDatasetId(Long presetDatasetId) {
        this.presetDatasetId = presetDatasetId;
    }

    @Generated
    public void setPresetDatasetType(String presetDatasetType) {
        this.presetDatasetType = presetDatasetType;
    }

    @Generated
    public void setPresetDashboard(PresetDashboard presetDashboard) {
        this.presetDashboard = presetDashboard;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetDataset)) {
            return false;
        }
        PresetDataset other = (PresetDataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$presetDatasetId = this.getPresetDatasetId();
        Long other$presetDatasetId = other.getPresetDatasetId();
        if (this$presetDatasetId == null ? other$presetDatasetId != null : !((Object)this$presetDatasetId).equals(other$presetDatasetId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$presetDatasetDatasourceName = this.getPresetDatasetDatasourceName();
        String other$presetDatasetDatasourceName = other.getPresetDatasetDatasourceName();
        if (this$presetDatasetDatasourceName == null ? other$presetDatasetDatasourceName != null : !this$presetDatasetDatasourceName.equals(other$presetDatasetDatasourceName)) {
            return false;
        }
        String this$presetDatasetType = this.getPresetDatasetType();
        String other$presetDatasetType = other.getPresetDatasetType();
        if (this$presetDatasetType == null ? other$presetDatasetType != null : !this$presetDatasetType.equals(other$presetDatasetType)) {
            return false;
        }
        PresetDashboard this$presetDashboard = this.getPresetDashboard();
        PresetDashboard other$presetDashboard = other.getPresetDashboard();
        return !(this$presetDashboard == null ? other$presetDashboard != null : !((Object)this$presetDashboard).equals(other$presetDashboard));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $presetDatasetId = this.getPresetDatasetId();
        result = result * 59 + ($presetDatasetId == null ? 43 : ((Object)$presetDatasetId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $presetDatasetDatasourceName = this.getPresetDatasetDatasourceName();
        result = result * 59 + ($presetDatasetDatasourceName == null ? 43 : $presetDatasetDatasourceName.hashCode());
        String $presetDatasetType = this.getPresetDatasetType();
        result = result * 59 + ($presetDatasetType == null ? 43 : $presetDatasetType.hashCode());
        PresetDashboard $presetDashboard = this.getPresetDashboard();
        result = result * 59 + ($presetDashboard == null ? 43 : ((Object)$presetDashboard).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PresetDatasetBuilderImpl
    extends PresetDatasetBuilder<PresetDataset, PresetDatasetBuilderImpl> {
        @Generated
        private PresetDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetDataset build() {
            return new PresetDataset(this);
        }
    }

    @Generated
    public static abstract class PresetDatasetBuilder<C extends PresetDataset, B extends PresetDatasetBuilder<C, B>>
    extends Preset.PresetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String presetDatasetDatasourceName;
        @Generated
        private Long presetDatasetId;
        @Generated
        private String presetDatasetType;
        @Generated
        private PresetDashboard presetDashboard;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetDataset instance, PresetDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.presetDatasetDatasourceName(instance.presetDatasetDatasourceName);
            b.presetDatasetId(instance.presetDatasetId);
            b.presetDatasetType(instance.presetDatasetType);
            b.presetDashboard(instance.presetDashboard);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B presetDatasetDatasourceName(String presetDatasetDatasourceName) {
            this.presetDatasetDatasourceName = presetDatasetDatasourceName;
            return (B)this.self();
        }

        @Generated
        public B presetDatasetId(Long presetDatasetId) {
            this.presetDatasetId = presetDatasetId;
            return (B)this.self();
        }

        @Generated
        public B presetDatasetType(String presetDatasetType) {
            this.presetDatasetType = presetDatasetType;
            return (B)this.self();
        }

        @Generated
        public B presetDashboard(PresetDashboard presetDashboard) {
            this.presetDashboard = presetDashboard;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PresetDataset.PresetDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", presetDatasetDatasourceName=" + this.presetDatasetDatasourceName + ", presetDatasetId=" + this.presetDatasetId + ", presetDatasetType=" + this.presetDatasetType + ", presetDashboard=" + this.presetDashboard + ")";
        }
    }
}

