/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Preset;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class PresetWorkspace
extends Preset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetWorkspace";
    String typeName;
    @Attribute
    Boolean presetWorkspacePublicDashboardsAllowed;
    @Attribute
    Long presetWorkspaceClusterId;
    @Attribute
    String presetWorkspaceHostname;
    @Attribute
    Boolean presetWorkspaceIsInMaintenanceMode;
    @Attribute
    String presetWorkspaceRegion;
    @Attribute
    String presetWorkspaceStatus;
    @Attribute
    Long presetWorkspaceDeploymentId;
    @Attribute
    Long presetWorkspaceDashboardCount;
    @Attribute
    Long presetWorkspaceDatasetCount;
    @Attribute
    SortedSet<PresetDashboard> presetDashboards;

    public static PresetWorkspace refByGuid(String guid) {
        return ((PresetWorkspaceBuilder)PresetWorkspace.builder().guid(guid)).build();
    }

    public static PresetWorkspace refByQualifiedName(String qualifiedName) {
        return ((PresetWorkspaceBuilder)PresetWorkspace.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static PresetWorkspaceBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (PresetWorkspaceBuilder)((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(PresetWorkspace.generateQualifiedName(connectionQualifiedName, name))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.PRESET);
    }

    public static PresetWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected PresetWorkspaceBuilder<?, ?> trimToRequired() {
        return PresetWorkspace.updater(this.getQualifiedName(), this.getName());
    }

    private static String generateQualifiedName(String connectionQualifiedName, String name) {
        return connectionQualifiedName + "/" + name;
    }

    public static PresetWorkspace retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof PresetWorkspace) {
            return (PresetWorkspace)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a PresetWorkspace.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static PresetWorkspace retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof PresetWorkspace) {
            return (PresetWorkspace)entity;
        }
        throw new NotFoundException("No PresetWorkspace found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static PresetWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeDescription(((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeUserDescription(((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeOwners(((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetWorkspace updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (PresetWorkspace)Asset.updateCertificate(PresetWorkspace.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeCertificate(((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static PresetWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetWorkspace)Asset.updateAnnouncement(PresetWorkspace.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeAnnouncement(((PresetWorkspaceBuilder)PresetWorkspace.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static PresetWorkspace replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.replaceTerms(PresetWorkspace.updater(qualifiedName, name), terms);
    }

    public static PresetWorkspace appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static PresetWorkspace removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetWorkspace(PresetWorkspaceBuilder<?, ?> b) {
        super((Preset.PresetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PresetWorkspace.$default$typeName();
        this.presetWorkspacePublicDashboardsAllowed = b.presetWorkspacePublicDashboardsAllowed;
        this.presetWorkspaceClusterId = b.presetWorkspaceClusterId;
        this.presetWorkspaceHostname = b.presetWorkspaceHostname;
        this.presetWorkspaceIsInMaintenanceMode = b.presetWorkspaceIsInMaintenanceMode;
        this.presetWorkspaceRegion = b.presetWorkspaceRegion;
        this.presetWorkspaceStatus = b.presetWorkspaceStatus;
        this.presetWorkspaceDeploymentId = b.presetWorkspaceDeploymentId;
        this.presetWorkspaceDashboardCount = b.presetWorkspaceDashboardCount;
        this.presetWorkspaceDatasetCount = b.presetWorkspaceDatasetCount;
        SortedSet<PresetDashboard> presetDashboards = new TreeSet<PresetDashboard>();
        if (b.presetDashboards != null) {
            presetDashboards.addAll(b.presetDashboards);
        }
        presetDashboards = Collections.unmodifiableSortedSet(presetDashboards);
        this.presetDashboards = presetDashboards;
    }

    @Generated
    public static PresetWorkspaceBuilder<?, ?> builder() {
        return new PresetWorkspaceBuilderImpl();
    }

    @Generated
    public PresetWorkspaceBuilder<?, ?> toBuilder() {
        return new PresetWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Boolean getPresetWorkspacePublicDashboardsAllowed() {
        return this.presetWorkspacePublicDashboardsAllowed;
    }

    @Generated
    public Long getPresetWorkspaceClusterId() {
        return this.presetWorkspaceClusterId;
    }

    @Generated
    public String getPresetWorkspaceHostname() {
        return this.presetWorkspaceHostname;
    }

    @Generated
    public Boolean getPresetWorkspaceIsInMaintenanceMode() {
        return this.presetWorkspaceIsInMaintenanceMode;
    }

    @Generated
    public String getPresetWorkspaceRegion() {
        return this.presetWorkspaceRegion;
    }

    @Generated
    public String getPresetWorkspaceStatus() {
        return this.presetWorkspaceStatus;
    }

    @Generated
    public Long getPresetWorkspaceDeploymentId() {
        return this.presetWorkspaceDeploymentId;
    }

    @Generated
    public Long getPresetWorkspaceDashboardCount() {
        return this.presetWorkspaceDashboardCount;
    }

    @Generated
    public Long getPresetWorkspaceDatasetCount() {
        return this.presetWorkspaceDatasetCount;
    }

    @Generated
    public SortedSet<PresetDashboard> getPresetDashboards() {
        return this.presetDashboards;
    }

    @Generated
    public void setPresetWorkspacePublicDashboardsAllowed(Boolean presetWorkspacePublicDashboardsAllowed) {
        this.presetWorkspacePublicDashboardsAllowed = presetWorkspacePublicDashboardsAllowed;
    }

    @Generated
    public void setPresetWorkspaceClusterId(Long presetWorkspaceClusterId) {
        this.presetWorkspaceClusterId = presetWorkspaceClusterId;
    }

    @Generated
    public void setPresetWorkspaceHostname(String presetWorkspaceHostname) {
        this.presetWorkspaceHostname = presetWorkspaceHostname;
    }

    @Generated
    public void setPresetWorkspaceIsInMaintenanceMode(Boolean presetWorkspaceIsInMaintenanceMode) {
        this.presetWorkspaceIsInMaintenanceMode = presetWorkspaceIsInMaintenanceMode;
    }

    @Generated
    public void setPresetWorkspaceRegion(String presetWorkspaceRegion) {
        this.presetWorkspaceRegion = presetWorkspaceRegion;
    }

    @Generated
    public void setPresetWorkspaceStatus(String presetWorkspaceStatus) {
        this.presetWorkspaceStatus = presetWorkspaceStatus;
    }

    @Generated
    public void setPresetWorkspaceDeploymentId(Long presetWorkspaceDeploymentId) {
        this.presetWorkspaceDeploymentId = presetWorkspaceDeploymentId;
    }

    @Generated
    public void setPresetWorkspaceDashboardCount(Long presetWorkspaceDashboardCount) {
        this.presetWorkspaceDashboardCount = presetWorkspaceDashboardCount;
    }

    @Generated
    public void setPresetWorkspaceDatasetCount(Long presetWorkspaceDatasetCount) {
        this.presetWorkspaceDatasetCount = presetWorkspaceDatasetCount;
    }

    @Generated
    public void setPresetDashboards(SortedSet<PresetDashboard> presetDashboards) {
        this.presetDashboards = presetDashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetWorkspace)) {
            return false;
        }
        PresetWorkspace other = (PresetWorkspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        Boolean other$presetWorkspacePublicDashboardsAllowed = other.getPresetWorkspacePublicDashboardsAllowed();
        if (this$presetWorkspacePublicDashboardsAllowed == null ? other$presetWorkspacePublicDashboardsAllowed != null : !((Object)this$presetWorkspacePublicDashboardsAllowed).equals(other$presetWorkspacePublicDashboardsAllowed)) {
            return false;
        }
        Long this$presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        Long other$presetWorkspaceClusterId = other.getPresetWorkspaceClusterId();
        if (this$presetWorkspaceClusterId == null ? other$presetWorkspaceClusterId != null : !((Object)this$presetWorkspaceClusterId).equals(other$presetWorkspaceClusterId)) {
            return false;
        }
        Boolean this$presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        Boolean other$presetWorkspaceIsInMaintenanceMode = other.getPresetWorkspaceIsInMaintenanceMode();
        if (this$presetWorkspaceIsInMaintenanceMode == null ? other$presetWorkspaceIsInMaintenanceMode != null : !((Object)this$presetWorkspaceIsInMaintenanceMode).equals(other$presetWorkspaceIsInMaintenanceMode)) {
            return false;
        }
        Long this$presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        Long other$presetWorkspaceDeploymentId = other.getPresetWorkspaceDeploymentId();
        if (this$presetWorkspaceDeploymentId == null ? other$presetWorkspaceDeploymentId != null : !((Object)this$presetWorkspaceDeploymentId).equals(other$presetWorkspaceDeploymentId)) {
            return false;
        }
        Long this$presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        Long other$presetWorkspaceDashboardCount = other.getPresetWorkspaceDashboardCount();
        if (this$presetWorkspaceDashboardCount == null ? other$presetWorkspaceDashboardCount != null : !((Object)this$presetWorkspaceDashboardCount).equals(other$presetWorkspaceDashboardCount)) {
            return false;
        }
        Long this$presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        Long other$presetWorkspaceDatasetCount = other.getPresetWorkspaceDatasetCount();
        if (this$presetWorkspaceDatasetCount == null ? other$presetWorkspaceDatasetCount != null : !((Object)this$presetWorkspaceDatasetCount).equals(other$presetWorkspaceDatasetCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        String other$presetWorkspaceHostname = other.getPresetWorkspaceHostname();
        if (this$presetWorkspaceHostname == null ? other$presetWorkspaceHostname != null : !this$presetWorkspaceHostname.equals(other$presetWorkspaceHostname)) {
            return false;
        }
        String this$presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        String other$presetWorkspaceRegion = other.getPresetWorkspaceRegion();
        if (this$presetWorkspaceRegion == null ? other$presetWorkspaceRegion != null : !this$presetWorkspaceRegion.equals(other$presetWorkspaceRegion)) {
            return false;
        }
        String this$presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        String other$presetWorkspaceStatus = other.getPresetWorkspaceStatus();
        if (this$presetWorkspaceStatus == null ? other$presetWorkspaceStatus != null : !this$presetWorkspaceStatus.equals(other$presetWorkspaceStatus)) {
            return false;
        }
        SortedSet<PresetDashboard> this$presetDashboards = this.getPresetDashboards();
        SortedSet<PresetDashboard> other$presetDashboards = other.getPresetDashboards();
        return !(this$presetDashboards == null ? other$presetDashboards != null : !this$presetDashboards.equals(other$presetDashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetWorkspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        result = result * 59 + ($presetWorkspacePublicDashboardsAllowed == null ? 43 : ((Object)$presetWorkspacePublicDashboardsAllowed).hashCode());
        Long $presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        result = result * 59 + ($presetWorkspaceClusterId == null ? 43 : ((Object)$presetWorkspaceClusterId).hashCode());
        Boolean $presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        result = result * 59 + ($presetWorkspaceIsInMaintenanceMode == null ? 43 : ((Object)$presetWorkspaceIsInMaintenanceMode).hashCode());
        Long $presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        result = result * 59 + ($presetWorkspaceDeploymentId == null ? 43 : ((Object)$presetWorkspaceDeploymentId).hashCode());
        Long $presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        result = result * 59 + ($presetWorkspaceDashboardCount == null ? 43 : ((Object)$presetWorkspaceDashboardCount).hashCode());
        Long $presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        result = result * 59 + ($presetWorkspaceDatasetCount == null ? 43 : ((Object)$presetWorkspaceDatasetCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        result = result * 59 + ($presetWorkspaceHostname == null ? 43 : $presetWorkspaceHostname.hashCode());
        String $presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        result = result * 59 + ($presetWorkspaceRegion == null ? 43 : $presetWorkspaceRegion.hashCode());
        String $presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        result = result * 59 + ($presetWorkspaceStatus == null ? 43 : $presetWorkspaceStatus.hashCode());
        SortedSet<PresetDashboard> $presetDashboards = this.getPresetDashboards();
        result = result * 59 + ($presetDashboards == null ? 43 : $presetDashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class PresetWorkspaceBuilderImpl
    extends PresetWorkspaceBuilder<PresetWorkspace, PresetWorkspaceBuilderImpl> {
        @Generated
        private PresetWorkspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetWorkspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetWorkspace build() {
            return new PresetWorkspace(this);
        }
    }

    @Generated
    public static abstract class PresetWorkspaceBuilder<C extends PresetWorkspace, B extends PresetWorkspaceBuilder<C, B>>
    extends Preset.PresetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean presetWorkspacePublicDashboardsAllowed;
        @Generated
        private Long presetWorkspaceClusterId;
        @Generated
        private String presetWorkspaceHostname;
        @Generated
        private Boolean presetWorkspaceIsInMaintenanceMode;
        @Generated
        private String presetWorkspaceRegion;
        @Generated
        private String presetWorkspaceStatus;
        @Generated
        private Long presetWorkspaceDeploymentId;
        @Generated
        private Long presetWorkspaceDashboardCount;
        @Generated
        private Long presetWorkspaceDatasetCount;
        @Generated
        private ArrayList<PresetDashboard> presetDashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetWorkspace instance, PresetWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.presetWorkspacePublicDashboardsAllowed(instance.presetWorkspacePublicDashboardsAllowed);
            b.presetWorkspaceClusterId(instance.presetWorkspaceClusterId);
            b.presetWorkspaceHostname(instance.presetWorkspaceHostname);
            b.presetWorkspaceIsInMaintenanceMode(instance.presetWorkspaceIsInMaintenanceMode);
            b.presetWorkspaceRegion(instance.presetWorkspaceRegion);
            b.presetWorkspaceStatus(instance.presetWorkspaceStatus);
            b.presetWorkspaceDeploymentId(instance.presetWorkspaceDeploymentId);
            b.presetWorkspaceDashboardCount(instance.presetWorkspaceDashboardCount);
            b.presetWorkspaceDatasetCount(instance.presetWorkspaceDatasetCount);
            b.presetDashboards(instance.presetDashboards == null ? Collections.emptySortedSet() : instance.presetDashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspacePublicDashboardsAllowed(Boolean presetWorkspacePublicDashboardsAllowed) {
            this.presetWorkspacePublicDashboardsAllowed = presetWorkspacePublicDashboardsAllowed;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceClusterId(Long presetWorkspaceClusterId) {
            this.presetWorkspaceClusterId = presetWorkspaceClusterId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceHostname(String presetWorkspaceHostname) {
            this.presetWorkspaceHostname = presetWorkspaceHostname;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceIsInMaintenanceMode(Boolean presetWorkspaceIsInMaintenanceMode) {
            this.presetWorkspaceIsInMaintenanceMode = presetWorkspaceIsInMaintenanceMode;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceRegion(String presetWorkspaceRegion) {
            this.presetWorkspaceRegion = presetWorkspaceRegion;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceStatus(String presetWorkspaceStatus) {
            this.presetWorkspaceStatus = presetWorkspaceStatus;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDeploymentId(Long presetWorkspaceDeploymentId) {
            this.presetWorkspaceDeploymentId = presetWorkspaceDeploymentId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDashboardCount(Long presetWorkspaceDashboardCount) {
            this.presetWorkspaceDashboardCount = presetWorkspaceDashboardCount;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDatasetCount(Long presetWorkspaceDatasetCount) {
            this.presetWorkspaceDatasetCount = presetWorkspaceDatasetCount;
            return (B)this.self();
        }

        @Generated
        public B presetDashboard(PresetDashboard presetDashboard) {
            if (this.presetDashboards == null) {
                this.presetDashboards = new ArrayList();
            }
            this.presetDashboards.add(presetDashboard);
            return (B)this.self();
        }

        @Generated
        public B presetDashboards(Collection<? extends PresetDashboard> presetDashboards) {
            if (presetDashboards == null) {
                throw new NullPointerException("presetDashboards cannot be null");
            }
            if (this.presetDashboards == null) {
                this.presetDashboards = new ArrayList();
            }
            this.presetDashboards.addAll(presetDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearPresetDashboards() {
            if (this.presetDashboards != null) {
                this.presetDashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PresetWorkspace.PresetWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", presetWorkspacePublicDashboardsAllowed=" + this.presetWorkspacePublicDashboardsAllowed + ", presetWorkspaceClusterId=" + this.presetWorkspaceClusterId + ", presetWorkspaceHostname=" + this.presetWorkspaceHostname + ", presetWorkspaceIsInMaintenanceMode=" + this.presetWorkspaceIsInMaintenanceMode + ", presetWorkspaceRegion=" + this.presetWorkspaceRegion + ", presetWorkspaceStatus=" + this.presetWorkspaceStatus + ", presetWorkspaceDeploymentId=" + this.presetWorkspaceDeploymentId + ", presetWorkspaceDashboardCount=" + this.presetWorkspaceDashboardCount + ", presetWorkspaceDatasetCount=" + this.presetWorkspaceDatasetCount + ", presetDashboards=" + this.presetDashboards + ")";
        }
    }
}

