/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;

public class Procedure
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Procedure";
    String typeName;
    @Attribute
    String definition;
    @Attribute
    @JsonProperty(value="atlanSchema")
    Schema schema;

    public static Procedure refByGuid(String guid) {
        return ((ProcedureBuilder)Procedure.builder().guid(guid)).build();
    }

    public static Procedure refByQualifiedName(String qualifiedName) {
        return ((ProcedureBuilder)Procedure.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ProcedureBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ProcedureBuilder)((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ProcedureBuilder<?, ?> trimToRequired() {
        return Procedure.updater(this.getQualifiedName(), this.getName());
    }

    public static Procedure retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Procedure) {
            return (Procedure)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Procedure.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Procedure retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Procedure) {
            return (Procedure)entity;
        }
        throw new NotFoundException("No Procedure found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Procedure removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Procedure)Asset.removeDescription(((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Procedure removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Procedure)Asset.removeUserDescription(((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Procedure removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Procedure)Asset.removeOwners(((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Procedure updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Procedure)Asset.updateCertificate(Procedure.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Procedure removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Procedure)Asset.removeCertificate(((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Procedure updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Procedure)Asset.updateAnnouncement(Procedure.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Procedure removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Procedure)Asset.removeAnnouncement(((ProcedureBuilder)Procedure.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Procedure replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Procedure)Asset.replaceTerms(Procedure.updater(qualifiedName, name), terms);
    }

    public static Procedure appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Procedure)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Procedure removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Procedure)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Procedure(ProcedureBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Procedure.$default$typeName();
        this.definition = b.definition;
        this.schema = b.schema;
    }

    @Generated
    public static ProcedureBuilder<?, ?> builder() {
        return new ProcedureBuilderImpl();
    }

    @Generated
    public ProcedureBuilder<?, ?> toBuilder() {
        return new ProcedureBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDefinition() {
        return this.definition;
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }

    @Generated
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @JsonProperty(value="atlanSchema")
    @Generated
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Procedure)) {
            return false;
        }
        Procedure other = (Procedure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Procedure;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ProcedureBuilderImpl
    extends ProcedureBuilder<Procedure, ProcedureBuilderImpl> {
        @Generated
        private ProcedureBuilderImpl() {
        }

        @Override
        @Generated
        protected ProcedureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Procedure build() {
            return new Procedure(this);
        }
    }

    @Generated
    public static abstract class ProcedureBuilder<C extends Procedure, B extends ProcedureBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String definition;
        @Generated
        private Schema schema;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProcedureBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Procedure instance, ProcedureBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.definition(instance.definition);
            b.schema(instance.schema);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B definition(String definition) {
            this.definition = definition;
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(Schema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Procedure.ProcedureBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", definition=" + this.definition + ", schema=" + this.schema + ")";
        }
    }
}

