/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Resource;
import com.atlan.model.core.Entity;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Readme
extends Resource {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Readme";
    String typeName;
    @Attribute
    Asset asset;
    @Attribute
    SortedSet<Readme> seeAlso;

    public static Readme refByGuid(String guid) {
        return ((ReadmeBuilder)Readme.builder().guid(guid)).build();
    }

    public static Readme refByQualifiedName(String qualifiedName) {
        return ((ReadmeBuilder)Readme.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ReadmeBuilder<?, ?> creator(Asset reference, String assetName, String content) {
        return ((ReadmeBuilder)((ReadmeBuilder)((ReadmeBuilder)Readme.builder().qualifiedName(Readme.generateQualifiedName(reference.getGuid()))).name(Readme.generateName(assetName))).description(content)).asset(reference);
    }

    public static ReadmeBuilder<?, ?> updater(String assetGuid, String assetName) {
        return (ReadmeBuilder)((ReadmeBuilder)Readme.builder().qualifiedName(Readme.generateQualifiedName(assetGuid))).name(Readme.generateName(assetName));
    }

    protected ReadmeBuilder<?, ?> trimToRequired() {
        return (ReadmeBuilder)((ReadmeBuilder)Readme.builder().qualifiedName(this.getQualifiedName())).name(this.getName());
    }

    private static String generateQualifiedName(String assetGuid) {
        return assetGuid + "/readme";
    }

    private static String generateName(String assetName) {
        return assetName + " Readme";
    }

    public static Readme retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Readme) {
            return (Readme)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Readme.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Readme retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Readme) {
            return (Readme)entity;
        }
        throw new NotFoundException("No Readme found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Readme removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Readme)Asset.removeDescription(((ReadmeBuilder)Readme.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Readme removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Readme)Asset.removeUserDescription(((ReadmeBuilder)Readme.builder().qualifiedName(qualifiedName)).name(name));
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Readme(ReadmeBuilder<?, ?> b) {
        super((Resource.ResourceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Readme.$default$typeName();
        this.asset = b.asset;
        SortedSet<Readme> seeAlso = new TreeSet<Readme>();
        if (b.seeAlso != null) {
            seeAlso.addAll(b.seeAlso);
        }
        seeAlso = Collections.unmodifiableSortedSet(seeAlso);
        this.seeAlso = seeAlso;
    }

    @Generated
    public static ReadmeBuilder<?, ?> builder() {
        return new ReadmeBuilderImpl();
    }

    @Generated
    public ReadmeBuilder<?, ?> toBuilder() {
        return new ReadmeBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public SortedSet<Readme> getSeeAlso() {
        return this.seeAlso;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Generated
    public void setSeeAlso(SortedSet<Readme> seeAlso) {
        this.seeAlso = seeAlso;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Readme)) {
            return false;
        }
        Readme other = (Readme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        SortedSet<Readme> this$seeAlso = this.getSeeAlso();
        SortedSet<Readme> other$seeAlso = other.getSeeAlso();
        return !(this$seeAlso == null ? other$seeAlso != null : !this$seeAlso.equals(other$seeAlso));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Readme;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        SortedSet<Readme> $seeAlso = this.getSeeAlso();
        result = result * 59 + ($seeAlso == null ? 43 : $seeAlso.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ReadmeBuilderImpl
    extends ReadmeBuilder<Readme, ReadmeBuilderImpl> {
        @Generated
        private ReadmeBuilderImpl() {
        }

        @Override
        @Generated
        protected ReadmeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Readme build() {
            return new Readme(this);
        }
    }

    @Generated
    public static abstract class ReadmeBuilder<C extends Readme, B extends ReadmeBuilder<C, B>>
    extends Resource.ResourceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Asset asset;
        @Generated
        private ArrayList<Readme> seeAlso;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadmeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Readme instance, ReadmeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.asset(instance.asset);
            b.seeAlso(instance.seeAlso == null ? Collections.emptySortedSet() : instance.seeAlso);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B asset(Asset asset) {
            this.asset = asset;
            return (B)this.self();
        }

        @Generated
        public B seeAlsoOne(Readme seeAlsoOne) {
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.add(seeAlsoOne);
            return (B)this.self();
        }

        @Generated
        public B seeAlso(Collection<? extends Readme> seeAlso) {
            if (seeAlso == null) {
                throw new NullPointerException("seeAlso cannot be null");
            }
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.addAll(seeAlso);
            return (B)this.self();
        }

        @Generated
        public B clearSeeAlso() {
            if (this.seeAlso != null) {
                this.seeAlso.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Readme.ReadmeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", asset=" + this.asset + ", seeAlso=" + this.seeAlso + ")";
        }
    }
}

