/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Resource;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.LinkIconType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class ReadmeTemplate
extends Resource {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ReadmeTemplate";
    String typeName;
    @Attribute
    String icon;
    @Attribute
    LinkIconType iconType;

    public static ReadmeTemplate refByGuid(String guid) {
        return ((ReadmeTemplateBuilder)ReadmeTemplate.builder().guid(guid)).build();
    }

    public static ReadmeTemplate refByQualifiedName(String qualifiedName) {
        return ((ReadmeTemplateBuilder)ReadmeTemplate.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ReadmeTemplateBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ReadmeTemplateBuilder)((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ReadmeTemplateBuilder<?, ?> trimToRequired() {
        return ReadmeTemplate.updater(this.getQualifiedName(), this.getName());
    }

    public static ReadmeTemplate retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ReadmeTemplate) {
            return (ReadmeTemplate)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ReadmeTemplate.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ReadmeTemplate retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ReadmeTemplate) {
            return (ReadmeTemplate)entity;
        }
        throw new NotFoundException("No ReadmeTemplate found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ReadmeTemplate removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeDescription(((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ReadmeTemplate removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeUserDescription(((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ReadmeTemplate removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeOwners(((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ReadmeTemplate updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ReadmeTemplate)Asset.updateCertificate(ReadmeTemplate.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ReadmeTemplate removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeCertificate(((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ReadmeTemplate updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ReadmeTemplate)Asset.updateAnnouncement(ReadmeTemplate.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ReadmeTemplate removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeAnnouncement(((ReadmeTemplateBuilder)ReadmeTemplate.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ReadmeTemplate replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ReadmeTemplate)Asset.replaceTerms(ReadmeTemplate.updater(qualifiedName, name), terms);
    }

    public static ReadmeTemplate appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ReadmeTemplate)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ReadmeTemplate removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ReadmeTemplate)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ReadmeTemplate(ReadmeTemplateBuilder<?, ?> b) {
        super((Resource.ResourceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ReadmeTemplate.$default$typeName();
        this.icon = b.icon;
        this.iconType = b.iconType;
    }

    @Generated
    public static ReadmeTemplateBuilder<?, ?> builder() {
        return new ReadmeTemplateBuilderImpl();
    }

    @Generated
    public ReadmeTemplateBuilder<?, ?> toBuilder() {
        return new ReadmeTemplateBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public LinkIconType getIconType() {
        return this.iconType;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setIconType(LinkIconType iconType) {
        this.iconType = iconType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadmeTemplate)) {
            return false;
        }
        ReadmeTemplate other = (ReadmeTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        LinkIconType this$iconType = this.getIconType();
        LinkIconType other$iconType = other.getIconType();
        return !(this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReadmeTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        LinkIconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ReadmeTemplateBuilderImpl
    extends ReadmeTemplateBuilder<ReadmeTemplate, ReadmeTemplateBuilderImpl> {
        @Generated
        private ReadmeTemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected ReadmeTemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ReadmeTemplate build() {
            return new ReadmeTemplate(this);
        }
    }

    @Generated
    public static abstract class ReadmeTemplateBuilder<C extends ReadmeTemplate, B extends ReadmeTemplateBuilder<C, B>>
    extends Resource.ResourceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String icon;
        @Generated
        private LinkIconType iconType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadmeTemplateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ReadmeTemplate instance, ReadmeTemplateBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.icon(instance.icon);
            b.iconType(instance.iconType);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B icon(String icon) {
            this.icon = icon;
            return (B)this.self();
        }

        @Generated
        public B iconType(LinkIconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ReadmeTemplate.ReadmeTemplateBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", icon=" + this.icon + ", iconType=" + this.iconType + ")";
        }
    }
}

