/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.Link;
import com.atlan.model.assets.Readme;
import com.atlan.model.assets.ReadmeTemplate;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonSubTypes(value={@JsonSubTypes.Type(value=ReadmeTemplate.class, name="ReadmeTemplate"), @JsonSubTypes.Type(value=Readme.class, name="Readme"), @JsonSubTypes.Type(value=Link.class, name="Link")})
public abstract class Resource
extends Catalog {
    public static final String TYPE_NAME = "Resource";
    @Attribute
    String link;
    @Attribute
    Boolean isGlobal;
    @Attribute
    String reference;
    @Attribute
    Map<String, String> resourceMetadata;

    @Generated
    protected Resource(ResourceBuilder<?, ?> b) {
        super((Catalog.CatalogBuilder<?, ?>)b);
        Map<Object, Object> resourceMetadata;
        this.link = b.link;
        this.isGlobal = b.isGlobal;
        this.reference = b.reference;
        switch (b.resourceMetadata$key == null ? 0 : b.resourceMetadata$key.size()) {
            case 0: {
                resourceMetadata = Collections.emptyMap();
                break;
            }
            case 1: {
                resourceMetadata = Collections.singletonMap(b.resourceMetadata$key.get(0), b.resourceMetadata$value.get(0));
                break;
            }
            default: {
                resourceMetadata = new LinkedHashMap(b.resourceMetadata$key.size() < 0x40000000 ? 1 + b.resourceMetadata$key.size() + (b.resourceMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.resourceMetadata$key.size(); ++$i) {
                    resourceMetadata.put(b.resourceMetadata$key.get($i), b.resourceMetadata$value.get($i));
                }
                resourceMetadata = Collections.unmodifiableMap(resourceMetadata);
            }
        }
        this.resourceMetadata = resourceMetadata;
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public Map<String, String> getResourceMetadata() {
        return this.resourceMetadata;
    }

    @Generated
    public void setLink(String link) {
        this.link = link;
    }

    @Generated
    public void setIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setResourceMetadata(Map<String, String> resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isGlobal = this.getIsGlobal();
        Boolean other$isGlobal = other.getIsGlobal();
        if (this$isGlobal == null ? other$isGlobal != null : !((Object)this$isGlobal).equals(other$isGlobal)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Map<String, String> this$resourceMetadata = this.getResourceMetadata();
        Map<String, String> other$resourceMetadata = other.getResourceMetadata();
        return !(this$resourceMetadata == null ? other$resourceMetadata != null : !((Object)this$resourceMetadata).equals(other$resourceMetadata));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isGlobal = this.getIsGlobal();
        result = result * 59 + ($isGlobal == null ? 43 : ((Object)$isGlobal).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Map<String, String> $resourceMetadata = this.getResourceMetadata();
        result = result * 59 + ($resourceMetadata == null ? 43 : ((Object)$resourceMetadata).hashCode());
        return result;
    }

    @Generated
    public static abstract class ResourceBuilder<C extends Resource, B extends ResourceBuilder<C, B>>
    extends Catalog.CatalogBuilder<C, B> {
        @Generated
        private String link;
        @Generated
        private Boolean isGlobal;
        @Generated
        private String reference;
        @Generated
        private ArrayList<String> resourceMetadata$key;
        @Generated
        private ArrayList<String> resourceMetadata$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ResourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Resource instance, ResourceBuilder<?, ?> b) {
            b.link(instance.link);
            b.isGlobal(instance.isGlobal);
            b.reference(instance.reference);
            b.resourceMetadata(instance.resourceMetadata == null ? Collections.emptyMap() : instance.resourceMetadata);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B link(String link) {
            this.link = link;
            return (B)this.self();
        }

        @Generated
        public B isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return (B)this.self();
        }

        @Generated
        public B reference(String reference) {
            this.reference = reference;
            return (B)this.self();
        }

        @Generated
        public B putResourceMetadata(String putResourceMetadataKey, String putResourceMetadataValue) {
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            this.resourceMetadata$key.add(putResourceMetadataKey);
            this.resourceMetadata$value.add(putResourceMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B resourceMetadata(Map<? extends String, ? extends String> resourceMetadata) {
            if (resourceMetadata == null) {
                throw new NullPointerException("resourceMetadata cannot be null");
            }
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : resourceMetadata.entrySet()) {
                this.resourceMetadata$key.add($lombokEntry.getKey());
                this.resourceMetadata$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearResourceMetadata() {
            if (this.resourceMetadata$key != null) {
                this.resourceMetadata$key.clear();
                this.resourceMetadata$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Resource.ResourceBuilder(super=" + super.toString() + ", link=" + this.link + ", isGlobal=" + this.isGlobal + ", reference=" + this.reference + ", resourceMetadata$key=" + this.resourceMetadata$key + ", resourceMetadata$value=" + this.resourceMetadata$value + ")";
        }
    }
}

