/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.S3;
import com.atlan.model.assets.S3Object;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class S3Bucket
extends S3 {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "S3Bucket";
    String typeName;
    @Attribute
    Long s3ObjectCount;
    @Attribute
    Boolean s3BucketVersioningEnabled;
    @Attribute
    SortedSet<S3Object> objects;

    public static S3Bucket refByGuid(String guid) {
        return ((S3BucketBuilder)S3Bucket.builder().guid(guid)).build();
    }

    public static S3Bucket refByQualifiedName(String qualifiedName) {
        return ((S3BucketBuilder)S3Bucket.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static S3BucketBuilder<?, ?> creator(String name, String connectionQualifiedName, String awsArn) {
        return (S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)S3Bucket.builder().qualifiedName(S3Bucket.generateQualifiedName(connectionQualifiedName, awsArn))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.S3)).awsArn(awsArn);
    }

    public static S3BucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return (S3BucketBuilder)((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected S3BucketBuilder<?, ?> trimToRequired() {
        return S3Bucket.updater(this.getQualifiedName(), this.getName());
    }

    public static S3Bucket retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof S3Bucket) {
            return (S3Bucket)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a S3Bucket.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static S3Bucket retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof S3Bucket) {
            return (S3Bucket)entity;
        }
        throw new NotFoundException("No S3Bucket found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static S3Bucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeDescription(((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Bucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeUserDescription(((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Bucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeOwners(((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Bucket updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (S3Bucket)Asset.updateCertificate(S3Bucket.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static S3Bucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeCertificate(((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Bucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (S3Bucket)Asset.updateAnnouncement(S3Bucket.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static S3Bucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeAnnouncement(((S3BucketBuilder)S3Bucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static S3Bucket replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.replaceTerms(S3Bucket.updater(qualifiedName, name), terms);
    }

    public static S3Bucket appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static S3Bucket removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected S3Bucket(S3BucketBuilder<?, ?> b) {
        super((S3.S3Builder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : S3Bucket.$default$typeName();
        this.s3ObjectCount = b.s3ObjectCount;
        this.s3BucketVersioningEnabled = b.s3BucketVersioningEnabled;
        SortedSet<S3Object> objects = new TreeSet<S3Object>();
        if (b.objects != null) {
            objects.addAll(b.objects);
        }
        objects = Collections.unmodifiableSortedSet(objects);
        this.objects = objects;
    }

    @Generated
    public static S3BucketBuilder<?, ?> builder() {
        return new S3BucketBuilderImpl();
    }

    @Generated
    public S3BucketBuilder<?, ?> toBuilder() {
        return new S3BucketBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getS3ObjectCount() {
        return this.s3ObjectCount;
    }

    @Generated
    public Boolean getS3BucketVersioningEnabled() {
        return this.s3BucketVersioningEnabled;
    }

    @Generated
    public SortedSet<S3Object> getObjects() {
        return this.objects;
    }

    @Generated
    public void setS3ObjectCount(Long s3ObjectCount) {
        this.s3ObjectCount = s3ObjectCount;
    }

    @Generated
    public void setS3BucketVersioningEnabled(Boolean s3BucketVersioningEnabled) {
        this.s3BucketVersioningEnabled = s3BucketVersioningEnabled;
    }

    @Generated
    public void setObjects(SortedSet<S3Object> objects) {
        this.objects = objects;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$s3ObjectCount = this.getS3ObjectCount();
        Long other$s3ObjectCount = other.getS3ObjectCount();
        if (this$s3ObjectCount == null ? other$s3ObjectCount != null : !((Object)this$s3ObjectCount).equals(other$s3ObjectCount)) {
            return false;
        }
        Boolean this$s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        Boolean other$s3BucketVersioningEnabled = other.getS3BucketVersioningEnabled();
        if (this$s3BucketVersioningEnabled == null ? other$s3BucketVersioningEnabled != null : !((Object)this$s3BucketVersioningEnabled).equals(other$s3BucketVersioningEnabled)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<S3Object> this$objects = this.getObjects();
        SortedSet<S3Object> other$objects = other.getObjects();
        return !(this$objects == null ? other$objects != null : !this$objects.equals(other$objects));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3Bucket;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $s3ObjectCount = this.getS3ObjectCount();
        result = result * 59 + ($s3ObjectCount == null ? 43 : ((Object)$s3ObjectCount).hashCode());
        Boolean $s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        result = result * 59 + ($s3BucketVersioningEnabled == null ? 43 : ((Object)$s3BucketVersioningEnabled).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<S3Object> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class S3BucketBuilderImpl
    extends S3BucketBuilder<S3Bucket, S3BucketBuilderImpl> {
        @Generated
        private S3BucketBuilderImpl() {
        }

        @Override
        @Generated
        protected S3BucketBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public S3Bucket build() {
            return new S3Bucket(this);
        }
    }

    @Generated
    public static abstract class S3BucketBuilder<C extends S3Bucket, B extends S3BucketBuilder<C, B>>
    extends S3.S3Builder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long s3ObjectCount;
        @Generated
        private Boolean s3BucketVersioningEnabled;
        @Generated
        private ArrayList<S3Object> objects;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            S3BucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(S3Bucket instance, S3BucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.s3ObjectCount(instance.s3ObjectCount);
            b.s3BucketVersioningEnabled(instance.s3BucketVersioningEnabled);
            b.objects(instance.objects == null ? Collections.emptySortedSet() : instance.objects);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectCount(Long s3ObjectCount) {
            this.s3ObjectCount = s3ObjectCount;
            return (B)this.self();
        }

        @Generated
        public B s3BucketVersioningEnabled(Boolean s3BucketVersioningEnabled) {
            this.s3BucketVersioningEnabled = s3BucketVersioningEnabled;
            return (B)this.self();
        }

        @Generated
        public B object(S3Object object) {
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.add(object);
            return (B)this.self();
        }

        @Generated
        public B objects(Collection<? extends S3Object> objects) {
            if (objects == null) {
                throw new NullPointerException("objects cannot be null");
            }
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.addAll(objects);
            return (B)this.self();
        }

        @Generated
        public B clearObjects() {
            if (this.objects != null) {
                this.objects.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "S3Bucket.S3BucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", s3ObjectCount=" + this.s3ObjectCount + ", s3BucketVersioningEnabled=" + this.s3BucketVersioningEnabled + ", objects=" + this.objects + ")";
        }
    }
}

