/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.S3;
import com.atlan.model.assets.S3Bucket;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class S3Object
extends S3 {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "S3Object";
    String typeName;
    @Attribute
    Long s3ObjectLastModifiedTime;
    @Attribute
    String s3BucketName;
    @Attribute
    String s3BucketQualifiedName;
    @Attribute
    Long s3ObjectSize;
    @Attribute
    String s3ObjectStorageClass;
    @Attribute
    String s3ObjectKey;
    @Attribute
    String s3ObjectContentType;
    @Attribute
    String s3ObjectContentDisposition;
    @Attribute
    String s3ObjectVersionId;
    @Attribute
    S3Bucket bucket;

    public static S3Object refByGuid(String guid) {
        return ((S3ObjectBuilder)S3Object.builder().guid(guid)).build();
    }

    public static S3Object refByQualifiedName(String qualifiedName) {
        return ((S3ObjectBuilder)S3Object.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static S3ObjectBuilder<?, ?> creator(String name, String connectionQualifiedName, String awsArn) {
        return (S3ObjectBuilder)((S3ObjectBuilder)((S3ObjectBuilder)((S3ObjectBuilder)((S3ObjectBuilder)S3Object.builder().qualifiedName(S3Object.generateQualifiedName(connectionQualifiedName, awsArn))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.S3)).awsArn(awsArn);
    }

    public static S3ObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (S3ObjectBuilder)((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected S3ObjectBuilder<?, ?> trimToRequired() {
        return S3Object.updater(this.getQualifiedName(), this.getName());
    }

    public static S3Object retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof S3Object) {
            return (S3Object)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a S3Object.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static S3Object retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof S3Object) {
            return (S3Object)entity;
        }
        throw new NotFoundException("No S3Object found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static S3Object removeDescription(String qualifiedName, String name) throws AtlanException {
        return (S3Object)Asset.removeDescription(((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Object removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (S3Object)Asset.removeUserDescription(((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Object removeOwners(String qualifiedName, String name) throws AtlanException {
        return (S3Object)Asset.removeOwners(((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Object updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (S3Object)Asset.updateCertificate(S3Object.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static S3Object removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (S3Object)Asset.removeCertificate(((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static S3Object updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (S3Object)Asset.updateAnnouncement(S3Object.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static S3Object removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (S3Object)Asset.removeAnnouncement(((S3ObjectBuilder)S3Object.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static S3Object replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Object)Asset.replaceTerms(S3Object.updater(qualifiedName, name), terms);
    }

    public static S3Object appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Object)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static S3Object removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (S3Object)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected S3Object(S3ObjectBuilder<?, ?> b) {
        super((S3.S3Builder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : S3Object.$default$typeName();
        this.s3ObjectLastModifiedTime = b.s3ObjectLastModifiedTime;
        this.s3BucketName = b.s3BucketName;
        this.s3BucketQualifiedName = b.s3BucketQualifiedName;
        this.s3ObjectSize = b.s3ObjectSize;
        this.s3ObjectStorageClass = b.s3ObjectStorageClass;
        this.s3ObjectKey = b.s3ObjectKey;
        this.s3ObjectContentType = b.s3ObjectContentType;
        this.s3ObjectContentDisposition = b.s3ObjectContentDisposition;
        this.s3ObjectVersionId = b.s3ObjectVersionId;
        this.bucket = b.bucket;
    }

    @Generated
    public static S3ObjectBuilder<?, ?> builder() {
        return new S3ObjectBuilderImpl();
    }

    @Generated
    public S3ObjectBuilder<?, ?> toBuilder() {
        return new S3ObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getS3ObjectLastModifiedTime() {
        return this.s3ObjectLastModifiedTime;
    }

    @Generated
    public String getS3BucketName() {
        return this.s3BucketName;
    }

    @Generated
    public String getS3BucketQualifiedName() {
        return this.s3BucketQualifiedName;
    }

    @Generated
    public Long getS3ObjectSize() {
        return this.s3ObjectSize;
    }

    @Generated
    public String getS3ObjectStorageClass() {
        return this.s3ObjectStorageClass;
    }

    @Generated
    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    @Generated
    public String getS3ObjectContentType() {
        return this.s3ObjectContentType;
    }

    @Generated
    public String getS3ObjectContentDisposition() {
        return this.s3ObjectContentDisposition;
    }

    @Generated
    public String getS3ObjectVersionId() {
        return this.s3ObjectVersionId;
    }

    @Generated
    public S3Bucket getBucket() {
        return this.bucket;
    }

    @Generated
    public void setS3ObjectLastModifiedTime(Long s3ObjectLastModifiedTime) {
        this.s3ObjectLastModifiedTime = s3ObjectLastModifiedTime;
    }

    @Generated
    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    @Generated
    public void setS3BucketQualifiedName(String s3BucketQualifiedName) {
        this.s3BucketQualifiedName = s3BucketQualifiedName;
    }

    @Generated
    public void setS3ObjectSize(Long s3ObjectSize) {
        this.s3ObjectSize = s3ObjectSize;
    }

    @Generated
    public void setS3ObjectStorageClass(String s3ObjectStorageClass) {
        this.s3ObjectStorageClass = s3ObjectStorageClass;
    }

    @Generated
    public void setS3ObjectKey(String s3ObjectKey) {
        this.s3ObjectKey = s3ObjectKey;
    }

    @Generated
    public void setS3ObjectContentType(String s3ObjectContentType) {
        this.s3ObjectContentType = s3ObjectContentType;
    }

    @Generated
    public void setS3ObjectContentDisposition(String s3ObjectContentDisposition) {
        this.s3ObjectContentDisposition = s3ObjectContentDisposition;
    }

    @Generated
    public void setS3ObjectVersionId(String s3ObjectVersionId) {
        this.s3ObjectVersionId = s3ObjectVersionId;
    }

    @Generated
    public void setBucket(S3Bucket bucket) {
        this.bucket = bucket;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$s3ObjectLastModifiedTime = this.getS3ObjectLastModifiedTime();
        Long other$s3ObjectLastModifiedTime = other.getS3ObjectLastModifiedTime();
        if (this$s3ObjectLastModifiedTime == null ? other$s3ObjectLastModifiedTime != null : !((Object)this$s3ObjectLastModifiedTime).equals(other$s3ObjectLastModifiedTime)) {
            return false;
        }
        Long this$s3ObjectSize = this.getS3ObjectSize();
        Long other$s3ObjectSize = other.getS3ObjectSize();
        if (this$s3ObjectSize == null ? other$s3ObjectSize != null : !((Object)this$s3ObjectSize).equals(other$s3ObjectSize)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$s3BucketName = this.getS3BucketName();
        String other$s3BucketName = other.getS3BucketName();
        if (this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName)) {
            return false;
        }
        String this$s3BucketQualifiedName = this.getS3BucketQualifiedName();
        String other$s3BucketQualifiedName = other.getS3BucketQualifiedName();
        if (this$s3BucketQualifiedName == null ? other$s3BucketQualifiedName != null : !this$s3BucketQualifiedName.equals(other$s3BucketQualifiedName)) {
            return false;
        }
        String this$s3ObjectStorageClass = this.getS3ObjectStorageClass();
        String other$s3ObjectStorageClass = other.getS3ObjectStorageClass();
        if (this$s3ObjectStorageClass == null ? other$s3ObjectStorageClass != null : !this$s3ObjectStorageClass.equals(other$s3ObjectStorageClass)) {
            return false;
        }
        String this$s3ObjectKey = this.getS3ObjectKey();
        String other$s3ObjectKey = other.getS3ObjectKey();
        if (this$s3ObjectKey == null ? other$s3ObjectKey != null : !this$s3ObjectKey.equals(other$s3ObjectKey)) {
            return false;
        }
        String this$s3ObjectContentType = this.getS3ObjectContentType();
        String other$s3ObjectContentType = other.getS3ObjectContentType();
        if (this$s3ObjectContentType == null ? other$s3ObjectContentType != null : !this$s3ObjectContentType.equals(other$s3ObjectContentType)) {
            return false;
        }
        String this$s3ObjectContentDisposition = this.getS3ObjectContentDisposition();
        String other$s3ObjectContentDisposition = other.getS3ObjectContentDisposition();
        if (this$s3ObjectContentDisposition == null ? other$s3ObjectContentDisposition != null : !this$s3ObjectContentDisposition.equals(other$s3ObjectContentDisposition)) {
            return false;
        }
        String this$s3ObjectVersionId = this.getS3ObjectVersionId();
        String other$s3ObjectVersionId = other.getS3ObjectVersionId();
        if (this$s3ObjectVersionId == null ? other$s3ObjectVersionId != null : !this$s3ObjectVersionId.equals(other$s3ObjectVersionId)) {
            return false;
        }
        S3Bucket this$bucket = this.getBucket();
        S3Bucket other$bucket = other.getBucket();
        return !(this$bucket == null ? other$bucket != null : !((Object)this$bucket).equals(other$bucket));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3Object;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $s3ObjectLastModifiedTime = this.getS3ObjectLastModifiedTime();
        result = result * 59 + ($s3ObjectLastModifiedTime == null ? 43 : ((Object)$s3ObjectLastModifiedTime).hashCode());
        Long $s3ObjectSize = this.getS3ObjectSize();
        result = result * 59 + ($s3ObjectSize == null ? 43 : ((Object)$s3ObjectSize).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $s3BucketName = this.getS3BucketName();
        result = result * 59 + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
        String $s3BucketQualifiedName = this.getS3BucketQualifiedName();
        result = result * 59 + ($s3BucketQualifiedName == null ? 43 : $s3BucketQualifiedName.hashCode());
        String $s3ObjectStorageClass = this.getS3ObjectStorageClass();
        result = result * 59 + ($s3ObjectStorageClass == null ? 43 : $s3ObjectStorageClass.hashCode());
        String $s3ObjectKey = this.getS3ObjectKey();
        result = result * 59 + ($s3ObjectKey == null ? 43 : $s3ObjectKey.hashCode());
        String $s3ObjectContentType = this.getS3ObjectContentType();
        result = result * 59 + ($s3ObjectContentType == null ? 43 : $s3ObjectContentType.hashCode());
        String $s3ObjectContentDisposition = this.getS3ObjectContentDisposition();
        result = result * 59 + ($s3ObjectContentDisposition == null ? 43 : $s3ObjectContentDisposition.hashCode());
        String $s3ObjectVersionId = this.getS3ObjectVersionId();
        result = result * 59 + ($s3ObjectVersionId == null ? 43 : $s3ObjectVersionId.hashCode());
        S3Bucket $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : ((Object)$bucket).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class S3ObjectBuilderImpl
    extends S3ObjectBuilder<S3Object, S3ObjectBuilderImpl> {
        @Generated
        private S3ObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected S3ObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public S3Object build() {
            return new S3Object(this);
        }
    }

    @Generated
    public static abstract class S3ObjectBuilder<C extends S3Object, B extends S3ObjectBuilder<C, B>>
    extends S3.S3Builder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long s3ObjectLastModifiedTime;
        @Generated
        private String s3BucketName;
        @Generated
        private String s3BucketQualifiedName;
        @Generated
        private Long s3ObjectSize;
        @Generated
        private String s3ObjectStorageClass;
        @Generated
        private String s3ObjectKey;
        @Generated
        private String s3ObjectContentType;
        @Generated
        private String s3ObjectContentDisposition;
        @Generated
        private String s3ObjectVersionId;
        @Generated
        private S3Bucket bucket;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            S3ObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(S3Object instance, S3ObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.s3ObjectLastModifiedTime(instance.s3ObjectLastModifiedTime);
            b.s3BucketName(instance.s3BucketName);
            b.s3BucketQualifiedName(instance.s3BucketQualifiedName);
            b.s3ObjectSize(instance.s3ObjectSize);
            b.s3ObjectStorageClass(instance.s3ObjectStorageClass);
            b.s3ObjectKey(instance.s3ObjectKey);
            b.s3ObjectContentType(instance.s3ObjectContentType);
            b.s3ObjectContentDisposition(instance.s3ObjectContentDisposition);
            b.s3ObjectVersionId(instance.s3ObjectVersionId);
            b.bucket(instance.bucket);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectLastModifiedTime(Long s3ObjectLastModifiedTime) {
            this.s3ObjectLastModifiedTime = s3ObjectLastModifiedTime;
            return (B)this.self();
        }

        @Generated
        public B s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return (B)this.self();
        }

        @Generated
        public B s3BucketQualifiedName(String s3BucketQualifiedName) {
            this.s3BucketQualifiedName = s3BucketQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectSize(Long s3ObjectSize) {
            this.s3ObjectSize = s3ObjectSize;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectStorageClass(String s3ObjectStorageClass) {
            this.s3ObjectStorageClass = s3ObjectStorageClass;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectContentType(String s3ObjectContentType) {
            this.s3ObjectContentType = s3ObjectContentType;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectContentDisposition(String s3ObjectContentDisposition) {
            this.s3ObjectContentDisposition = s3ObjectContentDisposition;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectVersionId(String s3ObjectVersionId) {
            this.s3ObjectVersionId = s3ObjectVersionId;
            return (B)this.self();
        }

        @Generated
        public B bucket(S3Bucket bucket) {
            this.bucket = bucket;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "S3Object.S3ObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", s3ObjectLastModifiedTime=" + this.s3ObjectLastModifiedTime + ", s3BucketName=" + this.s3BucketName + ", s3BucketQualifiedName=" + this.s3BucketQualifiedName + ", s3ObjectSize=" + this.s3ObjectSize + ", s3ObjectStorageClass=" + this.s3ObjectStorageClass + ", s3ObjectKey=" + this.s3ObjectKey + ", s3ObjectContentType=" + this.s3ObjectContentType + ", s3ObjectContentDisposition=" + this.s3ObjectContentDisposition + ", s3ObjectVersionId=" + this.s3ObjectVersionId + ", bucket=" + this.bucket + ")";
        }
    }
}

