/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Salesforce;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.assets.SalesforceReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class SalesforceDashboard
extends Salesforce {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceDashboard";
    String typeName;
    @Attribute
    String sourceId;
    @Attribute
    String dashboardType;
    @Attribute
    Long reportCount;
    @Attribute
    SortedSet<SalesforceReport> reports;
    @Attribute
    SalesforceOrganization organization;

    public static SalesforceDashboard refByGuid(String guid) {
        return ((SalesforceDashboardBuilder)SalesforceDashboard.builder().guid(guid)).build();
    }

    public static SalesforceDashboard refByQualifiedName(String qualifiedName) {
        return ((SalesforceDashboardBuilder)SalesforceDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SalesforceDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceDashboardBuilder)((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SalesforceDashboardBuilder<?, ?> trimToRequired() {
        return SalesforceDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof SalesforceDashboard) {
            return (SalesforceDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a SalesforceDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static SalesforceDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof SalesforceDashboard) {
            return (SalesforceDashboard)entity;
        }
        throw new NotFoundException("No SalesforceDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static SalesforceDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceDashboard)Asset.removeDescription(((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceDashboard)Asset.removeUserDescription(((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (SalesforceDashboard)Asset.removeOwners(((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceDashboard)Asset.updateCertificate(SalesforceDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (SalesforceDashboard)Asset.removeCertificate(((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceDashboard)Asset.updateAnnouncement(SalesforceDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (SalesforceDashboard)Asset.removeAnnouncement(((SalesforceDashboardBuilder)SalesforceDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static SalesforceDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceDashboard)Asset.replaceTerms(SalesforceDashboard.updater(qualifiedName, name), terms);
    }

    public static SalesforceDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceDashboard(SalesforceDashboardBuilder<?, ?> b) {
        super((Salesforce.SalesforceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceDashboard.$default$typeName();
        this.sourceId = b.sourceId;
        this.dashboardType = b.dashboardType;
        this.reportCount = b.reportCount;
        SortedSet<SalesforceReport> reports = new TreeSet<SalesforceReport>();
        if (b.reports != null) {
            reports.addAll(b.reports);
        }
        reports = Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        this.organization = b.organization;
    }

    @Generated
    public static SalesforceDashboardBuilder<?, ?> builder() {
        return new SalesforceDashboardBuilderImpl();
    }

    @Generated
    public SalesforceDashboardBuilder<?, ?> toBuilder() {
        return new SalesforceDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public String getDashboardType() {
        return this.dashboardType;
    }

    @Generated
    public Long getReportCount() {
        return this.reportCount;
    }

    @Generated
    public SortedSet<SalesforceReport> getReports() {
        return this.reports;
    }

    @Generated
    public SalesforceOrganization getOrganization() {
        return this.organization;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setDashboardType(String dashboardType) {
        this.dashboardType = dashboardType;
    }

    @Generated
    public void setReportCount(Long reportCount) {
        this.reportCount = reportCount;
    }

    @Generated
    public void setReports(SortedSet<SalesforceReport> reports) {
        this.reports = reports;
    }

    @Generated
    public void setOrganization(SalesforceOrganization organization) {
        this.organization = organization;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceDashboard)) {
            return false;
        }
        SalesforceDashboard other = (SalesforceDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$reportCount = this.getReportCount();
        Long other$reportCount = other.getReportCount();
        if (this$reportCount == null ? other$reportCount != null : !((Object)this$reportCount).equals(other$reportCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        String this$dashboardType = this.getDashboardType();
        String other$dashboardType = other.getDashboardType();
        if (this$dashboardType == null ? other$dashboardType != null : !this$dashboardType.equals(other$dashboardType)) {
            return false;
        }
        SortedSet<SalesforceReport> this$reports = this.getReports();
        SortedSet<SalesforceReport> other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) {
            return false;
        }
        SalesforceOrganization this$organization = this.getOrganization();
        SalesforceOrganization other$organization = other.getOrganization();
        return !(this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $reportCount = this.getReportCount();
        result = result * 59 + ($reportCount == null ? 43 : ((Object)$reportCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        String $dashboardType = this.getDashboardType();
        result = result * 59 + ($dashboardType == null ? 43 : $dashboardType.hashCode());
        SortedSet<SalesforceReport> $reports = this.getReports();
        result = result * 59 + ($reports == null ? 43 : $reports.hashCode());
        SalesforceOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SalesforceDashboardBuilderImpl
    extends SalesforceDashboardBuilder<SalesforceDashboard, SalesforceDashboardBuilderImpl> {
        @Generated
        private SalesforceDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceDashboard build() {
            return new SalesforceDashboard(this);
        }
    }

    @Generated
    public static abstract class SalesforceDashboardBuilder<C extends SalesforceDashboard, B extends SalesforceDashboardBuilder<C, B>>
    extends Salesforce.SalesforceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String sourceId;
        @Generated
        private String dashboardType;
        @Generated
        private Long reportCount;
        @Generated
        private ArrayList<SalesforceReport> reports;
        @Generated
        private SalesforceOrganization organization;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceDashboard instance, SalesforceDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceId(instance.sourceId);
            b.dashboardType(instance.dashboardType);
            b.reportCount(instance.reportCount);
            b.reports(instance.reports == null ? Collections.emptySortedSet() : instance.reports);
            b.organization(instance.organization);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceId(String sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        @Generated
        public B dashboardType(String dashboardType) {
            this.dashboardType = dashboardType;
            return (B)this.self();
        }

        @Generated
        public B reportCount(Long reportCount) {
            this.reportCount = reportCount;
            return (B)this.self();
        }

        @Generated
        public B report(SalesforceReport report) {
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.add(report);
            return (B)this.self();
        }

        @Generated
        public B reports(Collection<? extends SalesforceReport> reports) {
            if (reports == null) {
                throw new NullPointerException("reports cannot be null");
            }
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.addAll(reports);
            return (B)this.self();
        }

        @Generated
        public B clearReports() {
            if (this.reports != null) {
                this.reports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B organization(SalesforceOrganization organization) {
            this.organization = organization;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceDashboard.SalesforceDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceId=" + this.sourceId + ", dashboardType=" + this.dashboardType + ", reportCount=" + this.reportCount + ", reports=" + this.reports + ", organization=" + this.organization + ")";
        }
    }
}

