/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Salesforce;
import com.atlan.model.assets.SalesforceObject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class SalesforceField
extends Salesforce {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceField";
    String typeName;
    @Attribute
    String dataType;
    @Attribute
    String objectQualifiedName;
    @Attribute
    Integer order;
    @Attribute
    String inlineHelpText;
    @Attribute
    Boolean isCalculated;
    @Attribute
    String formula;
    @Attribute
    Boolean isCaseSensitive;
    @Attribute
    Boolean isEncrypted;
    @Attribute
    Long maxLength;
    @Attribute
    Boolean isNullable;
    @Attribute
    Integer precision;
    @Attribute
    Double numericScale;
    @Attribute
    Boolean isUnique;
    @Attribute
    SortedSet<String> picklistValues;
    @Attribute
    Boolean isPolymorphicForeignKey;
    @Attribute
    String defaultValueFormula;
    @Attribute
    SortedSet<SalesforceObject> lookupObjects;
    @Attribute
    SalesforceObject object;

    public static SalesforceField refByGuid(String guid) {
        return ((SalesforceFieldBuilder)SalesforceField.builder().guid(guid)).build();
    }

    public static SalesforceField refByQualifiedName(String qualifiedName) {
        return ((SalesforceFieldBuilder)SalesforceField.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SalesforceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceFieldBuilder)((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SalesforceFieldBuilder<?, ?> trimToRequired() {
        return SalesforceField.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceField retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof SalesforceField) {
            return (SalesforceField)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a SalesforceField.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static SalesforceField retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof SalesforceField) {
            return (SalesforceField)entity;
        }
        throw new NotFoundException("No SalesforceField found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static SalesforceField removeDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeDescription(((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeUserDescription(((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceField removeOwners(String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeOwners(((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceField updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceField)Asset.updateCertificate(SalesforceField.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeCertificate(((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceField)Asset.updateAnnouncement(SalesforceField.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeAnnouncement(((SalesforceFieldBuilder)SalesforceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static SalesforceField replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.replaceTerms(SalesforceField.updater(qualifiedName, name), terms);
    }

    public static SalesforceField appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceField removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceField(SalesforceFieldBuilder<?, ?> b) {
        super((Salesforce.SalesforceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceField.$default$typeName();
        this.dataType = b.dataType;
        this.objectQualifiedName = b.objectQualifiedName;
        this.order = b.order;
        this.inlineHelpText = b.inlineHelpText;
        this.isCalculated = b.isCalculated;
        this.formula = b.formula;
        this.isCaseSensitive = b.isCaseSensitive;
        this.isEncrypted = b.isEncrypted;
        this.maxLength = b.maxLength;
        this.isNullable = b.isNullable;
        this.precision = b.precision;
        this.numericScale = b.numericScale;
        this.isUnique = b.isUnique;
        SortedSet<String> picklistValues = new TreeSet<String>();
        if (b.picklistValues != null) {
            picklistValues.addAll(b.picklistValues);
        }
        picklistValues = Collections.unmodifiableSortedSet(picklistValues);
        this.picklistValues = picklistValues;
        this.isPolymorphicForeignKey = b.isPolymorphicForeignKey;
        this.defaultValueFormula = b.defaultValueFormula;
        SortedSet<SalesforceObject> lookupObjects = new TreeSet<SalesforceObject>();
        if (b.lookupObjects != null) {
            lookupObjects.addAll(b.lookupObjects);
        }
        lookupObjects = Collections.unmodifiableSortedSet(lookupObjects);
        this.lookupObjects = lookupObjects;
        this.object = b.object;
    }

    @Generated
    public static SalesforceFieldBuilder<?, ?> builder() {
        return new SalesforceFieldBuilderImpl();
    }

    @Generated
    public SalesforceFieldBuilder<?, ?> toBuilder() {
        return new SalesforceFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public String getObjectQualifiedName() {
        return this.objectQualifiedName;
    }

    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Generated
    public String getInlineHelpText() {
        return this.inlineHelpText;
    }

    @Generated
    public Boolean getIsCalculated() {
        return this.isCalculated;
    }

    @Generated
    public String getFormula() {
        return this.formula;
    }

    @Generated
    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Generated
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    @Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    @Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    @Generated
    public Boolean getIsUnique() {
        return this.isUnique;
    }

    @Generated
    public SortedSet<String> getPicklistValues() {
        return this.picklistValues;
    }

    @Generated
    public Boolean getIsPolymorphicForeignKey() {
        return this.isPolymorphicForeignKey;
    }

    @Generated
    public String getDefaultValueFormula() {
        return this.defaultValueFormula;
    }

    @Generated
    public SortedSet<SalesforceObject> getLookupObjects() {
        return this.lookupObjects;
    }

    @Generated
    public SalesforceObject getObject() {
        return this.object;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setObjectQualifiedName(String objectQualifiedName) {
        this.objectQualifiedName = objectQualifiedName;
    }

    @Generated
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Generated
    public void setInlineHelpText(String inlineHelpText) {
        this.inlineHelpText = inlineHelpText;
    }

    @Generated
    public void setIsCalculated(Boolean isCalculated) {
        this.isCalculated = isCalculated;
    }

    @Generated
    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Generated
    public void setIsCaseSensitive(Boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    @Generated
    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @Generated
    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    @Generated
    public void setIsNullable(Boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Generated
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Generated
    public void setNumericScale(Double numericScale) {
        this.numericScale = numericScale;
    }

    @Generated
    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    @Generated
    public void setPicklistValues(SortedSet<String> picklistValues) {
        this.picklistValues = picklistValues;
    }

    @Generated
    public void setIsPolymorphicForeignKey(Boolean isPolymorphicForeignKey) {
        this.isPolymorphicForeignKey = isPolymorphicForeignKey;
    }

    @Generated
    public void setDefaultValueFormula(String defaultValueFormula) {
        this.defaultValueFormula = defaultValueFormula;
    }

    @Generated
    public void setLookupObjects(SortedSet<SalesforceObject> lookupObjects) {
        this.lookupObjects = lookupObjects;
    }

    @Generated
    public void setObject(SalesforceObject object) {
        this.object = object;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceField)) {
            return false;
        }
        SalesforceField other = (SalesforceField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Boolean this$isCalculated = this.getIsCalculated();
        Boolean other$isCalculated = other.getIsCalculated();
        if (this$isCalculated == null ? other$isCalculated != null : !((Object)this$isCalculated).equals(other$isCalculated)) {
            return false;
        }
        Boolean this$isCaseSensitive = this.getIsCaseSensitive();
        Boolean other$isCaseSensitive = other.getIsCaseSensitive();
        if (this$isCaseSensitive == null ? other$isCaseSensitive != null : !((Object)this$isCaseSensitive).equals(other$isCaseSensitive)) {
            return false;
        }
        Boolean this$isEncrypted = this.getIsEncrypted();
        Boolean other$isEncrypted = other.getIsEncrypted();
        if (this$isEncrypted == null ? other$isEncrypted != null : !((Object)this$isEncrypted).equals(other$isEncrypted)) {
            return false;
        }
        Long this$maxLength = this.getMaxLength();
        Long other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Boolean this$isNullable = this.getIsNullable();
        Boolean other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Double this$numericScale = this.getNumericScale();
        Double other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !((Object)this$numericScale).equals(other$numericScale)) {
            return false;
        }
        Boolean this$isUnique = this.getIsUnique();
        Boolean other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !((Object)this$isUnique).equals(other$isUnique)) {
            return false;
        }
        Boolean this$isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        Boolean other$isPolymorphicForeignKey = other.getIsPolymorphicForeignKey();
        if (this$isPolymorphicForeignKey == null ? other$isPolymorphicForeignKey != null : !((Object)this$isPolymorphicForeignKey).equals(other$isPolymorphicForeignKey)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$objectQualifiedName = this.getObjectQualifiedName();
        String other$objectQualifiedName = other.getObjectQualifiedName();
        if (this$objectQualifiedName == null ? other$objectQualifiedName != null : !this$objectQualifiedName.equals(other$objectQualifiedName)) {
            return false;
        }
        String this$inlineHelpText = this.getInlineHelpText();
        String other$inlineHelpText = other.getInlineHelpText();
        if (this$inlineHelpText == null ? other$inlineHelpText != null : !this$inlineHelpText.equals(other$inlineHelpText)) {
            return false;
        }
        String this$formula = this.getFormula();
        String other$formula = other.getFormula();
        if (this$formula == null ? other$formula != null : !this$formula.equals(other$formula)) {
            return false;
        }
        SortedSet<String> this$picklistValues = this.getPicklistValues();
        SortedSet<String> other$picklistValues = other.getPicklistValues();
        if (this$picklistValues == null ? other$picklistValues != null : !this$picklistValues.equals(other$picklistValues)) {
            return false;
        }
        String this$defaultValueFormula = this.getDefaultValueFormula();
        String other$defaultValueFormula = other.getDefaultValueFormula();
        if (this$defaultValueFormula == null ? other$defaultValueFormula != null : !this$defaultValueFormula.equals(other$defaultValueFormula)) {
            return false;
        }
        SortedSet<SalesforceObject> this$lookupObjects = this.getLookupObjects();
        SortedSet<SalesforceObject> other$lookupObjects = other.getLookupObjects();
        if (this$lookupObjects == null ? other$lookupObjects != null : !this$lookupObjects.equals(other$lookupObjects)) {
            return false;
        }
        SalesforceObject this$object = this.getObject();
        SalesforceObject other$object = other.getObject();
        return !(this$object == null ? other$object != null : !((Object)this$object).equals(other$object));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Boolean $isCalculated = this.getIsCalculated();
        result = result * 59 + ($isCalculated == null ? 43 : ((Object)$isCalculated).hashCode());
        Boolean $isCaseSensitive = this.getIsCaseSensitive();
        result = result * 59 + ($isCaseSensitive == null ? 43 : ((Object)$isCaseSensitive).hashCode());
        Boolean $isEncrypted = this.getIsEncrypted();
        result = result * 59 + ($isEncrypted == null ? 43 : ((Object)$isEncrypted).hashCode());
        Long $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Boolean $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Double $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : ((Object)$numericScale).hashCode());
        Boolean $isUnique = this.getIsUnique();
        result = result * 59 + ($isUnique == null ? 43 : ((Object)$isUnique).hashCode());
        Boolean $isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        result = result * 59 + ($isPolymorphicForeignKey == null ? 43 : ((Object)$isPolymorphicForeignKey).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $objectQualifiedName = this.getObjectQualifiedName();
        result = result * 59 + ($objectQualifiedName == null ? 43 : $objectQualifiedName.hashCode());
        String $inlineHelpText = this.getInlineHelpText();
        result = result * 59 + ($inlineHelpText == null ? 43 : $inlineHelpText.hashCode());
        String $formula = this.getFormula();
        result = result * 59 + ($formula == null ? 43 : $formula.hashCode());
        SortedSet<String> $picklistValues = this.getPicklistValues();
        result = result * 59 + ($picklistValues == null ? 43 : $picklistValues.hashCode());
        String $defaultValueFormula = this.getDefaultValueFormula();
        result = result * 59 + ($defaultValueFormula == null ? 43 : $defaultValueFormula.hashCode());
        SortedSet<SalesforceObject> $lookupObjects = this.getLookupObjects();
        result = result * 59 + ($lookupObjects == null ? 43 : $lookupObjects.hashCode());
        SalesforceObject $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : ((Object)$object).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SalesforceFieldBuilderImpl
    extends SalesforceFieldBuilder<SalesforceField, SalesforceFieldBuilderImpl> {
        @Generated
        private SalesforceFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceField build() {
            return new SalesforceField(this);
        }
    }

    @Generated
    public static abstract class SalesforceFieldBuilder<C extends SalesforceField, B extends SalesforceFieldBuilder<C, B>>
    extends Salesforce.SalesforceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dataType;
        @Generated
        private String objectQualifiedName;
        @Generated
        private Integer order;
        @Generated
        private String inlineHelpText;
        @Generated
        private Boolean isCalculated;
        @Generated
        private String formula;
        @Generated
        private Boolean isCaseSensitive;
        @Generated
        private Boolean isEncrypted;
        @Generated
        private Long maxLength;
        @Generated
        private Boolean isNullable;
        @Generated
        private Integer precision;
        @Generated
        private Double numericScale;
        @Generated
        private Boolean isUnique;
        @Generated
        private ArrayList<String> picklistValues;
        @Generated
        private Boolean isPolymorphicForeignKey;
        @Generated
        private String defaultValueFormula;
        @Generated
        private ArrayList<SalesforceObject> lookupObjects;
        @Generated
        private SalesforceObject object;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceField instance, SalesforceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataType(instance.dataType);
            b.objectQualifiedName(instance.objectQualifiedName);
            b.order(instance.order);
            b.inlineHelpText(instance.inlineHelpText);
            b.isCalculated(instance.isCalculated);
            b.formula(instance.formula);
            b.isCaseSensitive(instance.isCaseSensitive);
            b.isEncrypted(instance.isEncrypted);
            b.maxLength(instance.maxLength);
            b.isNullable(instance.isNullable);
            b.precision(instance.precision);
            b.numericScale(instance.numericScale);
            b.isUnique(instance.isUnique);
            b.picklistValues(instance.picklistValues == null ? Collections.emptySortedSet() : instance.picklistValues);
            b.isPolymorphicForeignKey(instance.isPolymorphicForeignKey);
            b.defaultValueFormula(instance.defaultValueFormula);
            b.lookupObjects(instance.lookupObjects == null ? Collections.emptySortedSet() : instance.lookupObjects);
            b.object(instance.object);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataType(String dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        @Generated
        public B objectQualifiedName(String objectQualifiedName) {
            this.objectQualifiedName = objectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B order(Integer order) {
            this.order = order;
            return (B)this.self();
        }

        @Generated
        public B inlineHelpText(String inlineHelpText) {
            this.inlineHelpText = inlineHelpText;
            return (B)this.self();
        }

        @Generated
        public B isCalculated(Boolean isCalculated) {
            this.isCalculated = isCalculated;
            return (B)this.self();
        }

        @Generated
        public B formula(String formula) {
            this.formula = formula;
            return (B)this.self();
        }

        @Generated
        public B isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            return (B)this.self();
        }

        @Generated
        public B isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return (B)this.self();
        }

        @Generated
        public B maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        @Generated
        public B isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return (B)this.self();
        }

        @Generated
        public B precision(Integer precision) {
            this.precision = precision;
            return (B)this.self();
        }

        @Generated
        public B numericScale(Double numericScale) {
            this.numericScale = numericScale;
            return (B)this.self();
        }

        @Generated
        public B isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return (B)this.self();
        }

        @Generated
        public B picklistValue(String picklistValue) {
            if (this.picklistValues == null) {
                this.picklistValues = new ArrayList();
            }
            this.picklistValues.add(picklistValue);
            return (B)this.self();
        }

        @Generated
        public B picklistValues(Collection<? extends String> picklistValues) {
            if (picklistValues == null) {
                throw new NullPointerException("picklistValues cannot be null");
            }
            if (this.picklistValues == null) {
                this.picklistValues = new ArrayList();
            }
            this.picklistValues.addAll(picklistValues);
            return (B)this.self();
        }

        @Generated
        public B clearPicklistValues() {
            if (this.picklistValues != null) {
                this.picklistValues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isPolymorphicForeignKey(Boolean isPolymorphicForeignKey) {
            this.isPolymorphicForeignKey = isPolymorphicForeignKey;
            return (B)this.self();
        }

        @Generated
        public B defaultValueFormula(String defaultValueFormula) {
            this.defaultValueFormula = defaultValueFormula;
            return (B)this.self();
        }

        @Generated
        public B lookupObject(SalesforceObject lookupObject) {
            if (this.lookupObjects == null) {
                this.lookupObjects = new ArrayList();
            }
            this.lookupObjects.add(lookupObject);
            return (B)this.self();
        }

        @Generated
        public B lookupObjects(Collection<? extends SalesforceObject> lookupObjects) {
            if (lookupObjects == null) {
                throw new NullPointerException("lookupObjects cannot be null");
            }
            if (this.lookupObjects == null) {
                this.lookupObjects = new ArrayList();
            }
            this.lookupObjects.addAll(lookupObjects);
            return (B)this.self();
        }

        @Generated
        public B clearLookupObjects() {
            if (this.lookupObjects != null) {
                this.lookupObjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B object(SalesforceObject object) {
            this.object = object;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceField.SalesforceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataType=" + this.dataType + ", objectQualifiedName=" + this.objectQualifiedName + ", order=" + this.order + ", inlineHelpText=" + this.inlineHelpText + ", isCalculated=" + this.isCalculated + ", formula=" + this.formula + ", isCaseSensitive=" + this.isCaseSensitive + ", isEncrypted=" + this.isEncrypted + ", maxLength=" + this.maxLength + ", isNullable=" + this.isNullable + ", precision=" + this.precision + ", numericScale=" + this.numericScale + ", isUnique=" + this.isUnique + ", picklistValues=" + this.picklistValues + ", isPolymorphicForeignKey=" + this.isPolymorphicForeignKey + ", defaultValueFormula=" + this.defaultValueFormula + ", lookupObjects=" + this.lookupObjects + ", object=" + this.object + ")";
        }
    }
}

