/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Salesforce;
import com.atlan.model.assets.SalesforceField;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class SalesforceObject
extends Salesforce {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceObject";
    String typeName;
    @Attribute
    Boolean isCustom;
    @Attribute
    Boolean isMergable;
    @Attribute
    Boolean isQueryable;
    @Attribute
    Long fieldCount;
    @Attribute
    SalesforceOrganization organization;
    @Attribute
    SortedSet<SalesforceField> lookupFields;
    @Attribute
    SortedSet<SalesforceField> fields;

    public static SalesforceObject refByGuid(String guid) {
        return ((SalesforceObjectBuilder)SalesforceObject.builder().guid(guid)).build();
    }

    public static SalesforceObject refByQualifiedName(String qualifiedName) {
        return ((SalesforceObjectBuilder)SalesforceObject.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SalesforceObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SalesforceObjectBuilder<?, ?> trimToRequired() {
        return SalesforceObject.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceObject retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof SalesforceObject) {
            return (SalesforceObject)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a SalesforceObject.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static SalesforceObject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof SalesforceObject) {
            return (SalesforceObject)entity;
        }
        throw new NotFoundException("No SalesforceObject found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static SalesforceObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeDescription(((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeUserDescription(((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeOwners(((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceObject updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateCertificate(SalesforceObject.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeCertificate(((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateAnnouncement(SalesforceObject.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeAnnouncement(((SalesforceObjectBuilder)SalesforceObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static SalesforceObject replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.replaceTerms(SalesforceObject.updater(qualifiedName, name), terms);
    }

    public static SalesforceObject appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceObject removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceObject(SalesforceObjectBuilder<?, ?> b) {
        super((Salesforce.SalesforceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceObject.$default$typeName();
        this.isCustom = b.isCustom;
        this.isMergable = b.isMergable;
        this.isQueryable = b.isQueryable;
        this.fieldCount = b.fieldCount;
        this.organization = b.organization;
        SortedSet<SalesforceField> lookupFields = new TreeSet<SalesforceField>();
        if (b.lookupFields != null) {
            lookupFields.addAll(b.lookupFields);
        }
        lookupFields = Collections.unmodifiableSortedSet(lookupFields);
        this.lookupFields = lookupFields;
        SortedSet<SalesforceField> fields = new TreeSet<SalesforceField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
    }

    @Generated
    public static SalesforceObjectBuilder<?, ?> builder() {
        return new SalesforceObjectBuilderImpl();
    }

    @Generated
    public SalesforceObjectBuilder<?, ?> toBuilder() {
        return new SalesforceObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Boolean getIsCustom() {
        return this.isCustom;
    }

    @Generated
    public Boolean getIsMergable() {
        return this.isMergable;
    }

    @Generated
    public Boolean getIsQueryable() {
        return this.isQueryable;
    }

    @Generated
    public Long getFieldCount() {
        return this.fieldCount;
    }

    @Generated
    public SalesforceOrganization getOrganization() {
        return this.organization;
    }

    @Generated
    public SortedSet<SalesforceField> getLookupFields() {
        return this.lookupFields;
    }

    @Generated
    public SortedSet<SalesforceField> getFields() {
        return this.fields;
    }

    @Generated
    public void setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
    }

    @Generated
    public void setIsMergable(Boolean isMergable) {
        this.isMergable = isMergable;
    }

    @Generated
    public void setIsQueryable(Boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    @Generated
    public void setFieldCount(Long fieldCount) {
        this.fieldCount = fieldCount;
    }

    @Generated
    public void setOrganization(SalesforceOrganization organization) {
        this.organization = organization;
    }

    @Generated
    public void setLookupFields(SortedSet<SalesforceField> lookupFields) {
        this.lookupFields = lookupFields;
    }

    @Generated
    public void setFields(SortedSet<SalesforceField> fields) {
        this.fields = fields;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceObject)) {
            return false;
        }
        SalesforceObject other = (SalesforceObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isCustom = this.getIsCustom();
        Boolean other$isCustom = other.getIsCustom();
        if (this$isCustom == null ? other$isCustom != null : !((Object)this$isCustom).equals(other$isCustom)) {
            return false;
        }
        Boolean this$isMergable = this.getIsMergable();
        Boolean other$isMergable = other.getIsMergable();
        if (this$isMergable == null ? other$isMergable != null : !((Object)this$isMergable).equals(other$isMergable)) {
            return false;
        }
        Boolean this$isQueryable = this.getIsQueryable();
        Boolean other$isQueryable = other.getIsQueryable();
        if (this$isQueryable == null ? other$isQueryable != null : !((Object)this$isQueryable).equals(other$isQueryable)) {
            return false;
        }
        Long this$fieldCount = this.getFieldCount();
        Long other$fieldCount = other.getFieldCount();
        if (this$fieldCount == null ? other$fieldCount != null : !((Object)this$fieldCount).equals(other$fieldCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SalesforceOrganization this$organization = this.getOrganization();
        SalesforceOrganization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        SortedSet<SalesforceField> this$lookupFields = this.getLookupFields();
        SortedSet<SalesforceField> other$lookupFields = other.getLookupFields();
        if (this$lookupFields == null ? other$lookupFields != null : !this$lookupFields.equals(other$lookupFields)) {
            return false;
        }
        SortedSet<SalesforceField> this$fields = this.getFields();
        SortedSet<SalesforceField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isCustom = this.getIsCustom();
        result = result * 59 + ($isCustom == null ? 43 : ((Object)$isCustom).hashCode());
        Boolean $isMergable = this.getIsMergable();
        result = result * 59 + ($isMergable == null ? 43 : ((Object)$isMergable).hashCode());
        Boolean $isQueryable = this.getIsQueryable();
        result = result * 59 + ($isQueryable == null ? 43 : ((Object)$isQueryable).hashCode());
        Long $fieldCount = this.getFieldCount();
        result = result * 59 + ($fieldCount == null ? 43 : ((Object)$fieldCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SalesforceOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        SortedSet<SalesforceField> $lookupFields = this.getLookupFields();
        result = result * 59 + ($lookupFields == null ? 43 : $lookupFields.hashCode());
        SortedSet<SalesforceField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SalesforceObjectBuilderImpl
    extends SalesforceObjectBuilder<SalesforceObject, SalesforceObjectBuilderImpl> {
        @Generated
        private SalesforceObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceObject build() {
            return new SalesforceObject(this);
        }
    }

    @Generated
    public static abstract class SalesforceObjectBuilder<C extends SalesforceObject, B extends SalesforceObjectBuilder<C, B>>
    extends Salesforce.SalesforceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean isCustom;
        @Generated
        private Boolean isMergable;
        @Generated
        private Boolean isQueryable;
        @Generated
        private Long fieldCount;
        @Generated
        private SalesforceOrganization organization;
        @Generated
        private ArrayList<SalesforceField> lookupFields;
        @Generated
        private ArrayList<SalesforceField> fields;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceObject instance, SalesforceObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.isCustom(instance.isCustom);
            b.isMergable(instance.isMergable);
            b.isQueryable(instance.isQueryable);
            b.fieldCount(instance.fieldCount);
            b.organization(instance.organization);
            b.lookupFields(instance.lookupFields == null ? Collections.emptySortedSet() : instance.lookupFields);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B isCustom(Boolean isCustom) {
            this.isCustom = isCustom;
            return (B)this.self();
        }

        @Generated
        public B isMergable(Boolean isMergable) {
            this.isMergable = isMergable;
            return (B)this.self();
        }

        @Generated
        public B isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return (B)this.self();
        }

        @Generated
        public B fieldCount(Long fieldCount) {
            this.fieldCount = fieldCount;
            return (B)this.self();
        }

        @Generated
        public B organization(SalesforceOrganization organization) {
            this.organization = organization;
            return (B)this.self();
        }

        @Generated
        public B lookupField(SalesforceField lookupField) {
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.add(lookupField);
            return (B)this.self();
        }

        @Generated
        public B lookupFields(Collection<? extends SalesforceField> lookupFields) {
            if (lookupFields == null) {
                throw new NullPointerException("lookupFields cannot be null");
            }
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.addAll(lookupFields);
            return (B)this.self();
        }

        @Generated
        public B clearLookupFields() {
            if (this.lookupFields != null) {
                this.lookupFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B field(SalesforceField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends SalesforceField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceObject.SalesforceObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", isCustom=" + this.isCustom + ", isMergable=" + this.isMergable + ", isQueryable=" + this.isQueryable + ", fieldCount=" + this.fieldCount + ", organization=" + this.organization + ", lookupFields=" + this.lookupFields + ", fields=" + this.fields + ")";
        }
    }
}

