/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Salesforce;
import com.atlan.model.assets.SalesforceDashboard;
import com.atlan.model.assets.SalesforceObject;
import com.atlan.model.assets.SalesforceReport;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class SalesforceOrganization
extends Salesforce {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceOrganization";
    String typeName;
    @Attribute
    String sourceId;
    @Attribute
    SortedSet<SalesforceReport> reports;
    @Attribute
    SortedSet<SalesforceObject> objects;
    @Attribute
    SortedSet<SalesforceDashboard> dashboards;

    public static SalesforceOrganization refByGuid(String guid) {
        return ((SalesforceOrganizationBuilder)SalesforceOrganization.builder().guid(guid)).build();
    }

    public static SalesforceOrganization refByQualifiedName(String qualifiedName) {
        return ((SalesforceOrganizationBuilder)SalesforceOrganization.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SalesforceOrganizationBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceOrganizationBuilder)((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SalesforceOrganizationBuilder<?, ?> trimToRequired() {
        return SalesforceOrganization.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceOrganization retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof SalesforceOrganization) {
            return (SalesforceOrganization)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a SalesforceOrganization.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static SalesforceOrganization retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof SalesforceOrganization) {
            return (SalesforceOrganization)entity;
        }
        throw new NotFoundException("No SalesforceOrganization found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static SalesforceOrganization removeDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeDescription(((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceOrganization removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeUserDescription(((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceOrganization removeOwners(String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeOwners(((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceOrganization updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceOrganization)Asset.updateCertificate(SalesforceOrganization.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceOrganization removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeCertificate(((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceOrganization updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceOrganization)Asset.updateAnnouncement(SalesforceOrganization.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceOrganization removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeAnnouncement(((SalesforceOrganizationBuilder)SalesforceOrganization.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static SalesforceOrganization replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.replaceTerms(SalesforceOrganization.updater(qualifiedName, name), terms);
    }

    public static SalesforceOrganization appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceOrganization removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceOrganization(SalesforceOrganizationBuilder<?, ?> b) {
        super((Salesforce.SalesforceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceOrganization.$default$typeName();
        this.sourceId = b.sourceId;
        SortedSet<SalesforceReport> reports = new TreeSet<SalesforceReport>();
        if (b.reports != null) {
            reports.addAll(b.reports);
        }
        reports = Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        SortedSet<SalesforceObject> objects = new TreeSet<SalesforceObject>();
        if (b.objects != null) {
            objects.addAll(b.objects);
        }
        objects = Collections.unmodifiableSortedSet(objects);
        this.objects = objects;
        SortedSet<SalesforceDashboard> dashboards = new TreeSet<SalesforceDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
    }

    @Generated
    public static SalesforceOrganizationBuilder<?, ?> builder() {
        return new SalesforceOrganizationBuilderImpl();
    }

    @Generated
    public SalesforceOrganizationBuilder<?, ?> toBuilder() {
        return new SalesforceOrganizationBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public SortedSet<SalesforceReport> getReports() {
        return this.reports;
    }

    @Generated
    public SortedSet<SalesforceObject> getObjects() {
        return this.objects;
    }

    @Generated
    public SortedSet<SalesforceDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setReports(SortedSet<SalesforceReport> reports) {
        this.reports = reports;
    }

    @Generated
    public void setObjects(SortedSet<SalesforceObject> objects) {
        this.objects = objects;
    }

    @Generated
    public void setDashboards(SortedSet<SalesforceDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceOrganization)) {
            return false;
        }
        SalesforceOrganization other = (SalesforceOrganization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        SortedSet<SalesforceReport> this$reports = this.getReports();
        SortedSet<SalesforceReport> other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) {
            return false;
        }
        SortedSet<SalesforceObject> this$objects = this.getObjects();
        SortedSet<SalesforceObject> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) {
            return false;
        }
        SortedSet<SalesforceDashboard> this$dashboards = this.getDashboards();
        SortedSet<SalesforceDashboard> other$dashboards = other.getDashboards();
        return !(this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceOrganization;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        SortedSet<SalesforceReport> $reports = this.getReports();
        result = result * 59 + ($reports == null ? 43 : $reports.hashCode());
        SortedSet<SalesforceObject> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
        SortedSet<SalesforceDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SalesforceOrganizationBuilderImpl
    extends SalesforceOrganizationBuilder<SalesforceOrganization, SalesforceOrganizationBuilderImpl> {
        @Generated
        private SalesforceOrganizationBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceOrganizationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceOrganization build() {
            return new SalesforceOrganization(this);
        }
    }

    @Generated
    public static abstract class SalesforceOrganizationBuilder<C extends SalesforceOrganization, B extends SalesforceOrganizationBuilder<C, B>>
    extends Salesforce.SalesforceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String sourceId;
        @Generated
        private ArrayList<SalesforceReport> reports;
        @Generated
        private ArrayList<SalesforceObject> objects;
        @Generated
        private ArrayList<SalesforceDashboard> dashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceOrganizationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceOrganization instance, SalesforceOrganizationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceId(instance.sourceId);
            b.reports(instance.reports == null ? Collections.emptySortedSet() : instance.reports);
            b.objects(instance.objects == null ? Collections.emptySortedSet() : instance.objects);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceId(String sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        @Generated
        public B report(SalesforceReport report) {
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.add(report);
            return (B)this.self();
        }

        @Generated
        public B reports(Collection<? extends SalesforceReport> reports) {
            if (reports == null) {
                throw new NullPointerException("reports cannot be null");
            }
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.addAll(reports);
            return (B)this.self();
        }

        @Generated
        public B clearReports() {
            if (this.reports != null) {
                this.reports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B object(SalesforceObject object) {
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.add(object);
            return (B)this.self();
        }

        @Generated
        public B objects(Collection<? extends SalesforceObject> objects) {
            if (objects == null) {
                throw new NullPointerException("objects cannot be null");
            }
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.addAll(objects);
            return (B)this.self();
        }

        @Generated
        public B clearObjects() {
            if (this.objects != null) {
                this.objects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dashboard(SalesforceDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends SalesforceDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceOrganization.SalesforceOrganizationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceId=" + this.sourceId + ", reports=" + this.reports + ", objects=" + this.objects + ", dashboards=" + this.dashboards + ")";
        }
    }
}

