/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Salesforce;
import com.atlan.model.assets.SalesforceDashboard;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class SalesforceReport
extends Salesforce {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceReport";
    String typeName;
    @Attribute
    String sourceId;
    @Attribute
    Map<String, String> reportType;
    @Attribute
    SortedSet<String> detailColumns;
    @Attribute
    SalesforceOrganization organization;
    @Attribute
    SortedSet<SalesforceDashboard> dashboards;

    public static SalesforceReport refByGuid(String guid) {
        return ((SalesforceReportBuilder)SalesforceReport.builder().guid(guid)).build();
    }

    public static SalesforceReport refByQualifiedName(String qualifiedName) {
        return ((SalesforceReportBuilder)SalesforceReport.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SalesforceReportBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceReportBuilder)((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SalesforceReportBuilder<?, ?> trimToRequired() {
        return SalesforceReport.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceReport retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof SalesforceReport) {
            return (SalesforceReport)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a SalesforceReport.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static SalesforceReport retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof SalesforceReport) {
            return (SalesforceReport)entity;
        }
        throw new NotFoundException("No SalesforceReport found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static SalesforceReport removeDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceReport)Asset.removeDescription(((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceReport removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (SalesforceReport)Asset.removeUserDescription(((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceReport removeOwners(String qualifiedName, String name) throws AtlanException {
        return (SalesforceReport)Asset.removeOwners(((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceReport updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceReport)Asset.updateCertificate(SalesforceReport.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceReport removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (SalesforceReport)Asset.removeCertificate(((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static SalesforceReport updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceReport)Asset.updateAnnouncement(SalesforceReport.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceReport removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (SalesforceReport)Asset.removeAnnouncement(((SalesforceReportBuilder)SalesforceReport.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static SalesforceReport replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceReport)Asset.replaceTerms(SalesforceReport.updater(qualifiedName, name), terms);
    }

    public static SalesforceReport appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceReport)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceReport removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (SalesforceReport)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceReport(SalesforceReportBuilder<?, ?> b) {
        super((Salesforce.SalesforceBuilder<?, ?>)b);
        Map<Object, Object> reportType;
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceReport.$default$typeName();
        this.sourceId = b.sourceId;
        switch (b.reportType$key == null ? 0 : b.reportType$key.size()) {
            case 0: {
                reportType = Collections.emptyMap();
                break;
            }
            case 1: {
                reportType = Collections.singletonMap(b.reportType$key.get(0), b.reportType$value.get(0));
                break;
            }
            default: {
                reportType = new LinkedHashMap(b.reportType$key.size() < 0x40000000 ? 1 + b.reportType$key.size() + (b.reportType$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.reportType$key.size(); ++$i) {
                    reportType.put(b.reportType$key.get($i), b.reportType$value.get($i));
                }
                reportType = Collections.unmodifiableMap(reportType);
            }
        }
        this.reportType = reportType;
        SortedSet<String> detailColumns = new TreeSet<String>();
        if (b.detailColumns != null) {
            detailColumns.addAll(b.detailColumns);
        }
        detailColumns = Collections.unmodifiableSortedSet(detailColumns);
        this.detailColumns = detailColumns;
        this.organization = b.organization;
        SortedSet<SalesforceDashboard> dashboards = new TreeSet<SalesforceDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
    }

    @Generated
    public static SalesforceReportBuilder<?, ?> builder() {
        return new SalesforceReportBuilderImpl();
    }

    @Generated
    public SalesforceReportBuilder<?, ?> toBuilder() {
        return new SalesforceReportBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public Map<String, String> getReportType() {
        return this.reportType;
    }

    @Generated
    public SortedSet<String> getDetailColumns() {
        return this.detailColumns;
    }

    @Generated
    public SalesforceOrganization getOrganization() {
        return this.organization;
    }

    @Generated
    public SortedSet<SalesforceDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setReportType(Map<String, String> reportType) {
        this.reportType = reportType;
    }

    @Generated
    public void setDetailColumns(SortedSet<String> detailColumns) {
        this.detailColumns = detailColumns;
    }

    @Generated
    public void setOrganization(SalesforceOrganization organization) {
        this.organization = organization;
    }

    @Generated
    public void setDashboards(SortedSet<SalesforceDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceReport)) {
            return false;
        }
        SalesforceReport other = (SalesforceReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        Map<String, String> this$reportType = this.getReportType();
        Map<String, String> other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !((Object)this$reportType).equals(other$reportType)) {
            return false;
        }
        SortedSet<String> this$detailColumns = this.getDetailColumns();
        SortedSet<String> other$detailColumns = other.getDetailColumns();
        if (this$detailColumns == null ? other$detailColumns != null : !this$detailColumns.equals(other$detailColumns)) {
            return false;
        }
        SalesforceOrganization this$organization = this.getOrganization();
        SalesforceOrganization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        SortedSet<SalesforceDashboard> this$dashboards = this.getDashboards();
        SortedSet<SalesforceDashboard> other$dashboards = other.getDashboards();
        return !(this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceReport;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        Map<String, String> $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : ((Object)$reportType).hashCode());
        SortedSet<String> $detailColumns = this.getDetailColumns();
        result = result * 59 + ($detailColumns == null ? 43 : $detailColumns.hashCode());
        SalesforceOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        SortedSet<SalesforceDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SalesforceReportBuilderImpl
    extends SalesforceReportBuilder<SalesforceReport, SalesforceReportBuilderImpl> {
        @Generated
        private SalesforceReportBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceReportBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceReport build() {
            return new SalesforceReport(this);
        }
    }

    @Generated
    public static abstract class SalesforceReportBuilder<C extends SalesforceReport, B extends SalesforceReportBuilder<C, B>>
    extends Salesforce.SalesforceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String sourceId;
        @Generated
        private ArrayList<String> reportType$key;
        @Generated
        private ArrayList<String> reportType$value;
        @Generated
        private ArrayList<String> detailColumns;
        @Generated
        private SalesforceOrganization organization;
        @Generated
        private ArrayList<SalesforceDashboard> dashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceReportBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceReport instance, SalesforceReportBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceId(instance.sourceId);
            b.reportType(instance.reportType == null ? Collections.emptyMap() : instance.reportType);
            b.detailColumns(instance.detailColumns == null ? Collections.emptySortedSet() : instance.detailColumns);
            b.organization(instance.organization);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceId(String sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        @Generated
        public B putReportType(String putReportTypeKey, String putReportTypeValue) {
            if (this.reportType$key == null) {
                this.reportType$key = new ArrayList();
                this.reportType$value = new ArrayList();
            }
            this.reportType$key.add(putReportTypeKey);
            this.reportType$value.add(putReportTypeValue);
            return (B)this.self();
        }

        @Generated
        public B reportType(Map<? extends String, ? extends String> reportType) {
            if (reportType == null) {
                throw new NullPointerException("reportType cannot be null");
            }
            if (this.reportType$key == null) {
                this.reportType$key = new ArrayList();
                this.reportType$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : reportType.entrySet()) {
                this.reportType$key.add($lombokEntry.getKey());
                this.reportType$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearReportType() {
            if (this.reportType$key != null) {
                this.reportType$key.clear();
                this.reportType$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B detailColumn(String detailColumn) {
            if (this.detailColumns == null) {
                this.detailColumns = new ArrayList();
            }
            this.detailColumns.add(detailColumn);
            return (B)this.self();
        }

        @Generated
        public B detailColumns(Collection<? extends String> detailColumns) {
            if (detailColumns == null) {
                throw new NullPointerException("detailColumns cannot be null");
            }
            if (this.detailColumns == null) {
                this.detailColumns = new ArrayList();
            }
            this.detailColumns.addAll(detailColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDetailColumns() {
            if (this.detailColumns != null) {
                this.detailColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B organization(SalesforceOrganization organization) {
            this.organization = organization;
            return (B)this.self();
        }

        @Generated
        public B dashboard(SalesforceDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends SalesforceDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceReport.SalesforceReportBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceId=" + this.sourceId + ", reportType$key=" + this.reportType$key + ", reportType$value=" + this.reportType$value + ", detailColumns=" + this.detailColumns + ", organization=" + this.organization + ", dashboards=" + this.dashboards + ")";
        }
    }
}

