/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Database;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.Procedure;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.View;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Schema
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Schema";
    String typeName;
    @Attribute
    Integer tableCount;
    @Attribute
    @JsonProperty(value="viewsCount")
    Integer viewCount;
    @Attribute
    @JsonProperty(value="materialisedViews")
    SortedSet<MaterializedView> materializedViews;
    @Attribute
    SortedSet<Table> tables;
    @Attribute
    Database database;
    @Attribute
    SortedSet<Procedure> procedures;
    @Attribute
    SortedSet<View> views;

    public static Schema refByGuid(String guid) {
        return ((SchemaBuilder)Schema.builder().guid(guid)).build();
    }

    public static Schema refByQualifiedName(String qualifiedName) {
        return ((SchemaBuilder)Schema.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static SchemaBuilder<?, ?> creator(String name, String databaseQualifiedName) {
        String[] tokens = databaseQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return (SchemaBuilder)((Asset.AssetBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)Schema.builder().name(name)).qualifiedName(databaseQualifiedName + "/" + name)).connectorType(connectorType)).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).database(Database.refByQualifiedName(databaseQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static SchemaBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SchemaBuilder)((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected SchemaBuilder<?, ?> trimToRequired() {
        return Schema.updater(this.getQualifiedName(), this.getName());
    }

    public static Schema retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Schema) {
            return (Schema)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Schema.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Schema retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Schema) {
            return (Schema)entity;
        }
        throw new NotFoundException("No Schema found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Schema removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeDescription(((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Schema removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeUserDescription(((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Schema removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeOwners(((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Schema updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Schema)Asset.updateCertificate(Schema.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Schema removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeCertificate(((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Schema updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Schema)Asset.updateAnnouncement(Schema.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Schema removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeAnnouncement(((SchemaBuilder)Schema.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Schema replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.replaceTerms(Schema.updater(qualifiedName, name), terms);
    }

    public static Schema appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Schema removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Schema(SchemaBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Schema.$default$typeName();
        this.tableCount = b.tableCount;
        this.viewCount = b.viewCount;
        SortedSet<MaterializedView> materializedViews = new TreeSet<MaterializedView>();
        if (b.materializedViews != null) {
            materializedViews.addAll(b.materializedViews);
        }
        materializedViews = Collections.unmodifiableSortedSet(materializedViews);
        this.materializedViews = materializedViews;
        SortedSet<Table> tables = new TreeSet<Table>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.database = b.database;
        SortedSet<Procedure> procedures = new TreeSet<Procedure>();
        if (b.procedures != null) {
            procedures.addAll(b.procedures);
        }
        procedures = Collections.unmodifiableSortedSet(procedures);
        this.procedures = procedures;
        SortedSet<View> views = new TreeSet<View>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @Generated
    public static SchemaBuilder<?, ?> builder() {
        return new SchemaBuilderImpl();
    }

    @Generated
    public SchemaBuilder<?, ?> toBuilder() {
        return new SchemaBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Integer getTableCount() {
        return this.tableCount;
    }

    @Generated
    public Integer getViewCount() {
        return this.viewCount;
    }

    @Generated
    public SortedSet<MaterializedView> getMaterializedViews() {
        return this.materializedViews;
    }

    @Generated
    public SortedSet<Table> getTables() {
        return this.tables;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public SortedSet<Procedure> getProcedures() {
        return this.procedures;
    }

    @Generated
    public SortedSet<View> getViews() {
        return this.views;
    }

    @Generated
    public void setTableCount(Integer tableCount) {
        this.tableCount = tableCount;
    }

    @JsonProperty(value="viewsCount")
    @Generated
    public void setViewCount(Integer viewCount) {
        this.viewCount = viewCount;
    }

    @JsonProperty(value="materialisedViews")
    @Generated
    public void setMaterializedViews(SortedSet<MaterializedView> materializedViews) {
        this.materializedViews = materializedViews;
    }

    @Generated
    public void setTables(SortedSet<Table> tables) {
        this.tables = tables;
    }

    @Generated
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Generated
    public void setProcedures(SortedSet<Procedure> procedures) {
        this.procedures = procedures;
    }

    @Generated
    public void setViews(SortedSet<View> views) {
        this.views = views;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$tableCount = this.getTableCount();
        Integer other$tableCount = other.getTableCount();
        if (this$tableCount == null ? other$tableCount != null : !((Object)this$tableCount).equals(other$tableCount)) {
            return false;
        }
        Integer this$viewCount = this.getViewCount();
        Integer other$viewCount = other.getViewCount();
        if (this$viewCount == null ? other$viewCount != null : !((Object)this$viewCount).equals(other$viewCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<MaterializedView> this$materializedViews = this.getMaterializedViews();
        SortedSet<MaterializedView> other$materializedViews = other.getMaterializedViews();
        if (this$materializedViews == null ? other$materializedViews != null : !this$materializedViews.equals(other$materializedViews)) {
            return false;
        }
        SortedSet<Table> this$tables = this.getTables();
        SortedSet<Table> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        Database this$database = this.getDatabase();
        Database other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        SortedSet<Procedure> this$procedures = this.getProcedures();
        SortedSet<Procedure> other$procedures = other.getProcedures();
        if (this$procedures == null ? other$procedures != null : !this$procedures.equals(other$procedures)) {
            return false;
        }
        SortedSet<View> this$views = this.getViews();
        SortedSet<View> other$views = other.getViews();
        return !(this$views == null ? other$views != null : !this$views.equals(other$views));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $tableCount = this.getTableCount();
        result = result * 59 + ($tableCount == null ? 43 : ((Object)$tableCount).hashCode());
        Integer $viewCount = this.getViewCount();
        result = result * 59 + ($viewCount == null ? 43 : ((Object)$viewCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<MaterializedView> $materializedViews = this.getMaterializedViews();
        result = result * 59 + ($materializedViews == null ? 43 : $materializedViews.hashCode());
        SortedSet<Table> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        Database $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        SortedSet<Procedure> $procedures = this.getProcedures();
        result = result * 59 + ($procedures == null ? 43 : $procedures.hashCode());
        SortedSet<View> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class SchemaBuilderImpl
    extends SchemaBuilder<Schema, SchemaBuilderImpl> {
        @Generated
        private SchemaBuilderImpl() {
        }

        @Override
        @Generated
        protected SchemaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Schema build() {
            return new Schema(this);
        }
    }

    @Generated
    public static abstract class SchemaBuilder<C extends Schema, B extends SchemaBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Integer tableCount;
        @Generated
        private Integer viewCount;
        @Generated
        private ArrayList<MaterializedView> materializedViews;
        @Generated
        private ArrayList<Table> tables;
        @Generated
        private Database database;
        @Generated
        private ArrayList<Procedure> procedures;
        @Generated
        private ArrayList<View> views;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SchemaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Schema instance, SchemaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.tableCount(instance.tableCount);
            b.viewCount(instance.viewCount);
            b.materializedViews(instance.materializedViews == null ? Collections.emptySortedSet() : instance.materializedViews);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.database(instance.database);
            b.procedures(instance.procedures == null ? Collections.emptySortedSet() : instance.procedures);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B tableCount(Integer tableCount) {
            this.tableCount = tableCount;
            return (B)this.self();
        }

        @JsonProperty(value="viewsCount")
        @Generated
        public B viewCount(Integer viewCount) {
            this.viewCount = viewCount;
            return (B)this.self();
        }

        @Generated
        public B materializedView(MaterializedView materializedView) {
            if (this.materializedViews == null) {
                this.materializedViews = new ArrayList();
            }
            this.materializedViews.add(materializedView);
            return (B)this.self();
        }

        @JsonProperty(value="materialisedViews")
        @Generated
        public B materializedViews(Collection<? extends MaterializedView> materializedViews) {
            if (materializedViews == null) {
                throw new NullPointerException("materializedViews cannot be null");
            }
            if (this.materializedViews == null) {
                this.materializedViews = new ArrayList();
            }
            this.materializedViews.addAll(materializedViews);
            return (B)this.self();
        }

        @Generated
        public B clearMaterializedViews() {
            if (this.materializedViews != null) {
                this.materializedViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B table(Table table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends Table> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B database(Database database) {
            this.database = database;
            return (B)this.self();
        }

        @Generated
        public B procedure(Procedure procedure) {
            if (this.procedures == null) {
                this.procedures = new ArrayList();
            }
            this.procedures.add(procedure);
            return (B)this.self();
        }

        @Generated
        public B procedures(Collection<? extends Procedure> procedures) {
            if (procedures == null) {
                throw new NullPointerException("procedures cannot be null");
            }
            if (this.procedures == null) {
                this.procedures = new ArrayList();
            }
            this.procedures.addAll(procedures);
            return (B)this.self();
        }

        @Generated
        public B clearProcedures() {
            if (this.procedures != null) {
                this.procedures.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(View view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends View> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Schema.SchemaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", tableCount=" + this.tableCount + ", viewCount=" + this.viewCount + ", materializedViews=" + this.materializedViews + ", tables=" + this.tables + ", database=" + this.database + ", procedures=" + this.procedures + ", views=" + this.views + ")";
        }
    }
}

