/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanQuery;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Schema;
import com.atlan.model.assets.TablePartition;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Table
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Table";
    String typeName;
    @Attribute
    Long columnCount;
    @Attribute
    Long rowCount;
    @Attribute
    Long sizeBytes;
    @Attribute
    String alias;
    @Attribute
    Boolean isTemporary;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    String externalLocation;
    @Attribute
    String externalLocationRegion;
    @Attribute
    String externalLocationFormat;
    @Attribute
    Boolean isPartitioned;
    @Attribute
    String partitionStrategy;
    @Attribute
    Long partitionCount;
    @Attribute
    String partitionList;
    @Attribute
    SortedSet<TablePartition> partitions;
    @Attribute
    @JsonProperty(value="atlanSchema")
    Schema schema;
    @Attribute
    SortedSet<Column> columns;
    @Attribute
    SortedSet<AtlanQuery> queries;

    public static Table refByGuid(String guid) {
        return ((TableBuilder)Table.builder().guid(guid)).build();
    }

    public static Table refByQualifiedName(String qualifiedName) {
        return ((TableBuilder)Table.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableBuilder<?, ?> creator(String name, String schemaQualifiedName) {
        String[] tokens = schemaQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return (TableBuilder)((TableBuilder)((TableBuilder)((SQL.SQLBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)Table.builder().name(name)).qualifiedName(schemaQualifiedName + "/" + name)).connectorType(connectorType)).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).schema(Schema.refByQualifiedName(schemaQualifiedName))).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static TableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableBuilder)((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableBuilder<?, ?> trimToRequired() {
        return Table.updater(this.getQualifiedName(), this.getName());
    }

    public static Table retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Table) {
            return (Table)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Table.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Table retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Table) {
            return (Table)entity;
        }
        throw new NotFoundException("No Table found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Table removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Table)Asset.removeDescription(((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Table removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Table)Asset.removeUserDescription(((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Table removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Table)Asset.removeOwners(((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Table updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Table)Asset.updateCertificate(Table.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Table removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Table)Asset.removeCertificate(((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Table updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Table)Asset.updateAnnouncement(Table.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Table removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Table)Asset.removeAnnouncement(((TableBuilder)Table.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Table replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Table)Asset.replaceTerms(Table.updater(qualifiedName, name), terms);
    }

    public static Table appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Table)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Table removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Table)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Table(TableBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : Table.$default$typeName();
        this.columnCount = b.columnCount;
        this.rowCount = b.rowCount;
        this.sizeBytes = b.sizeBytes;
        this.alias = b.alias;
        this.isTemporary = b.isTemporary;
        this.isQueryPreview = b.isQueryPreview;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.externalLocation = b.externalLocation;
        this.externalLocationRegion = b.externalLocationRegion;
        this.externalLocationFormat = b.externalLocationFormat;
        this.isPartitioned = b.isPartitioned;
        this.partitionStrategy = b.partitionStrategy;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        SortedSet<TablePartition> partitions = new TreeSet<TablePartition>();
        if (b.partitions != null) {
            partitions.addAll(b.partitions);
        }
        partitions = Collections.unmodifiableSortedSet(partitions);
        this.partitions = partitions;
        this.schema = b.schema;
        SortedSet<Column> columns = new TreeSet<Column>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        SortedSet<AtlanQuery> queries = new TreeSet<AtlanQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
    }

    @Generated
    public static TableBuilder<?, ?> builder() {
        return new TableBuilderImpl();
    }

    @Generated
    public TableBuilder<?, ?> toBuilder() {
        return new TableBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Generated
    public String getExternalLocation() {
        return this.externalLocation;
    }

    @Generated
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    @Generated
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    @Generated
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Generated
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    @Generated
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    @Generated
    public String getPartitionList() {
        return this.partitionList;
    }

    @Generated
    public SortedSet<TablePartition> getPartitions() {
        return this.partitions;
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }

    @Generated
    public SortedSet<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public SortedSet<AtlanQuery> getQueries() {
        return this.queries;
    }

    @Generated
    public void setColumnCount(Long columnCount) {
        this.columnCount = columnCount;
    }

    @Generated
    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setIsTemporary(Boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @Generated
    public void setIsQueryPreview(Boolean isQueryPreview) {
        this.isQueryPreview = isQueryPreview;
    }

    @Generated
    public void setQueryPreviewConfig(Map<String, String> queryPreviewConfig) {
        this.queryPreviewConfig = queryPreviewConfig;
    }

    @Generated
    public void setExternalLocation(String externalLocation) {
        this.externalLocation = externalLocation;
    }

    @Generated
    public void setExternalLocationRegion(String externalLocationRegion) {
        this.externalLocationRegion = externalLocationRegion;
    }

    @Generated
    public void setExternalLocationFormat(String externalLocationFormat) {
        this.externalLocationFormat = externalLocationFormat;
    }

    @Generated
    public void setIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    @Generated
    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    @Generated
    public void setPartitionCount(Long partitionCount) {
        this.partitionCount = partitionCount;
    }

    @Generated
    public void setPartitionList(String partitionList) {
        this.partitionList = partitionList;
    }

    @Generated
    public void setPartitions(SortedSet<TablePartition> partitions) {
        this.partitions = partitions;
    }

    @JsonProperty(value="atlanSchema")
    @Generated
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Generated
    public void setColumns(SortedSet<Column> columns) {
        this.columns = columns;
    }

    @Generated
    public void setQueries(SortedSet<AtlanQuery> queries) {
        this.queries = queries;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Long this$partitionCount = this.getPartitionCount();
        Long other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        String this$externalLocation = this.getExternalLocation();
        String other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) {
            return false;
        }
        String this$externalLocationRegion = this.getExternalLocationRegion();
        String other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) {
            return false;
        }
        String this$externalLocationFormat = this.getExternalLocationFormat();
        String other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        String this$partitionList = this.getPartitionList();
        String other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) {
            return false;
        }
        SortedSet<TablePartition> this$partitions = this.getPartitions();
        SortedSet<TablePartition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !this$partitions.equals(other$partitions)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        SortedSet<Column> this$columns = this.getColumns();
        SortedSet<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        SortedSet<AtlanQuery> this$queries = this.getQueries();
        SortedSet<AtlanQuery> other$queries = other.getQueries();
        return !(this$queries == null ? other$queries != null : !this$queries.equals(other$queries));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Long $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        String $externalLocation = this.getExternalLocation();
        result = result * 59 + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        String $externalLocationRegion = this.getExternalLocationRegion();
        result = result * 59 + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        String $externalLocationFormat = this.getExternalLocationFormat();
        result = result * 59 + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        String $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : $partitionList.hashCode());
        SortedSet<TablePartition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : $partitions.hashCode());
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        SortedSet<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        SortedSet<AtlanQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableBuilderImpl
    extends TableBuilder<Table, TableBuilderImpl> {
        @Generated
        private TableBuilderImpl() {
        }

        @Override
        @Generated
        protected TableBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Table build() {
            return new Table(this);
        }
    }

    @Generated
    public static abstract class TableBuilder<C extends Table, B extends TableBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long columnCount;
        @Generated
        private Long rowCount;
        @Generated
        private Long sizeBytes;
        @Generated
        private String alias;
        @Generated
        private Boolean isTemporary;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private String externalLocation;
        @Generated
        private String externalLocationRegion;
        @Generated
        private String externalLocationFormat;
        @Generated
        private Boolean isPartitioned;
        @Generated
        private String partitionStrategy;
        @Generated
        private Long partitionCount;
        @Generated
        private String partitionList;
        @Generated
        private ArrayList<TablePartition> partitions;
        @Generated
        private Schema schema;
        @Generated
        private ArrayList<Column> columns;
        @Generated
        private ArrayList<AtlanQuery> queries;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Table instance, TableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.columnCount(instance.columnCount);
            b.rowCount(instance.rowCount);
            b.sizeBytes(instance.sizeBytes);
            b.alias(instance.alias);
            b.isTemporary(instance.isTemporary);
            b.isQueryPreview(instance.isQueryPreview);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.externalLocation(instance.externalLocation);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.isPartitioned(instance.isPartitioned);
            b.partitionStrategy(instance.partitionStrategy);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.partitions(instance.partitions == null ? Collections.emptySortedSet() : instance.partitions);
            b.schema(instance.schema);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B externalLocation(String externalLocation) {
            this.externalLocation = externalLocation;
            return (B)this.self();
        }

        @Generated
        public B externalLocationRegion(String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return (B)this.self();
        }

        @Generated
        public B externalLocationFormat(String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return (B)this.self();
        }

        @Generated
        public B isPartitioned(Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return (B)this.self();
        }

        @Generated
        public B partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return (B)this.self();
        }

        @Generated
        public B partitionCount(Long partitionCount) {
            this.partitionCount = partitionCount;
            return (B)this.self();
        }

        @Generated
        public B partitionList(String partitionList) {
            this.partitionList = partitionList;
            return (B)this.self();
        }

        @Generated
        public B partition(TablePartition partition) {
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.add(partition);
            return (B)this.self();
        }

        @Generated
        public B partitions(Collection<? extends TablePartition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("partitions cannot be null");
            }
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.addAll(partitions);
            return (B)this.self();
        }

        @Generated
        public B clearPartitions() {
            if (this.partitions != null) {
                this.partitions.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(Schema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Generated
        public B column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B query(AtlanQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        @Generated
        public B queries(Collection<? extends AtlanQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        @Generated
        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Table.TableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", columnCount=" + this.columnCount + ", rowCount=" + this.rowCount + ", sizeBytes=" + this.sizeBytes + ", alias=" + this.alias + ", isTemporary=" + this.isTemporary + ", isQueryPreview=" + this.isQueryPreview + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", externalLocation=" + this.externalLocation + ", externalLocationRegion=" + this.externalLocationRegion + ", externalLocationFormat=" + this.externalLocationFormat + ", isPartitioned=" + this.isPartitioned + ", partitionStrategy=" + this.partitionStrategy + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", partitions=" + this.partitions + ", schema=" + this.schema + ", columns=" + this.columns + ", queries=" + this.queries + ")";
        }
    }
}

