/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Table;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TablePartition
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TablePartition";
    String typeName;
    @Attribute
    String constraint;
    @Attribute
    Long columnCount;
    @Attribute
    Long rowCount;
    @Attribute
    Long sizeBytes;
    @Attribute
    String alias;
    @Attribute
    Boolean isTemporary;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    String externalLocation;
    @Attribute
    String externalLocationRegion;
    @Attribute
    String externalLocationFormat;
    @Attribute
    Boolean isPartitioned;
    @Attribute
    String partitionStrategy;
    @Attribute
    Long partitionCount;
    @Attribute
    String partitionList;
    @Attribute
    SortedSet<Column> columns;
    @Attribute
    Table parentTable;

    public static TablePartition refByGuid(String guid) {
        return ((TablePartitionBuilder)TablePartition.builder().guid(guid)).build();
    }

    public static TablePartition refByQualifiedName(String qualifiedName) {
        return ((TablePartitionBuilder)TablePartition.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TablePartitionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TablePartitionBuilder)((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TablePartitionBuilder<?, ?> trimToRequired() {
        return TablePartition.updater(this.getQualifiedName(), this.getName());
    }

    public static TablePartition retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TablePartition) {
            return (TablePartition)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TablePartition.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TablePartition retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TablePartition) {
            return (TablePartition)entity;
        }
        throw new NotFoundException("No TablePartition found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TablePartition removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeDescription(((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TablePartition removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeUserDescription(((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TablePartition removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeOwners(((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TablePartition updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TablePartition)Asset.updateCertificate(TablePartition.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TablePartition removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeCertificate(((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TablePartition updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TablePartition)Asset.updateAnnouncement(TablePartition.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TablePartition removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeAnnouncement(((TablePartitionBuilder)TablePartition.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TablePartition replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.replaceTerms(TablePartition.updater(qualifiedName, name), terms);
    }

    public static TablePartition appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TablePartition removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TablePartition(TablePartitionBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : TablePartition.$default$typeName();
        this.constraint = b.constraint;
        this.columnCount = b.columnCount;
        this.rowCount = b.rowCount;
        this.sizeBytes = b.sizeBytes;
        this.alias = b.alias;
        this.isTemporary = b.isTemporary;
        this.isQueryPreview = b.isQueryPreview;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.externalLocation = b.externalLocation;
        this.externalLocationRegion = b.externalLocationRegion;
        this.externalLocationFormat = b.externalLocationFormat;
        this.isPartitioned = b.isPartitioned;
        this.partitionStrategy = b.partitionStrategy;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        SortedSet<Column> columns = new TreeSet<Column>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.parentTable = b.parentTable;
    }

    @Generated
    public static TablePartitionBuilder<?, ?> builder() {
        return new TablePartitionBuilderImpl();
    }

    @Generated
    public TablePartitionBuilder<?, ?> toBuilder() {
        return new TablePartitionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getConstraint() {
        return this.constraint;
    }

    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Generated
    public String getExternalLocation() {
        return this.externalLocation;
    }

    @Generated
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    @Generated
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    @Generated
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Generated
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    @Generated
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    @Generated
    public String getPartitionList() {
        return this.partitionList;
    }

    @Generated
    public SortedSet<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public Table getParentTable() {
        return this.parentTable;
    }

    @Generated
    public void setConstraint(String constraint) {
        this.constraint = constraint;
    }

    @Generated
    public void setColumnCount(Long columnCount) {
        this.columnCount = columnCount;
    }

    @Generated
    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setIsTemporary(Boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @Generated
    public void setIsQueryPreview(Boolean isQueryPreview) {
        this.isQueryPreview = isQueryPreview;
    }

    @Generated
    public void setQueryPreviewConfig(Map<String, String> queryPreviewConfig) {
        this.queryPreviewConfig = queryPreviewConfig;
    }

    @Generated
    public void setExternalLocation(String externalLocation) {
        this.externalLocation = externalLocation;
    }

    @Generated
    public void setExternalLocationRegion(String externalLocationRegion) {
        this.externalLocationRegion = externalLocationRegion;
    }

    @Generated
    public void setExternalLocationFormat(String externalLocationFormat) {
        this.externalLocationFormat = externalLocationFormat;
    }

    @Generated
    public void setIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    @Generated
    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    @Generated
    public void setPartitionCount(Long partitionCount) {
        this.partitionCount = partitionCount;
    }

    @Generated
    public void setPartitionList(String partitionList) {
        this.partitionList = partitionList;
    }

    @Generated
    public void setColumns(SortedSet<Column> columns) {
        this.columns = columns;
    }

    @Generated
    public void setParentTable(Table parentTable) {
        this.parentTable = parentTable;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablePartition)) {
            return false;
        }
        TablePartition other = (TablePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Long this$partitionCount = this.getPartitionCount();
        Long other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$constraint = this.getConstraint();
        String other$constraint = other.getConstraint();
        if (this$constraint == null ? other$constraint != null : !this$constraint.equals(other$constraint)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        String this$externalLocation = this.getExternalLocation();
        String other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) {
            return false;
        }
        String this$externalLocationRegion = this.getExternalLocationRegion();
        String other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) {
            return false;
        }
        String this$externalLocationFormat = this.getExternalLocationFormat();
        String other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        String this$partitionList = this.getPartitionList();
        String other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) {
            return false;
        }
        SortedSet<Column> this$columns = this.getColumns();
        SortedSet<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        Table this$parentTable = this.getParentTable();
        Table other$parentTable = other.getParentTable();
        return !(this$parentTable == null ? other$parentTable != null : !((Object)this$parentTable).equals(other$parentTable));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TablePartition;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Long $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $constraint = this.getConstraint();
        result = result * 59 + ($constraint == null ? 43 : $constraint.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        String $externalLocation = this.getExternalLocation();
        result = result * 59 + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        String $externalLocationRegion = this.getExternalLocationRegion();
        result = result * 59 + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        String $externalLocationFormat = this.getExternalLocationFormat();
        result = result * 59 + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        String $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : $partitionList.hashCode());
        SortedSet<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        Table $parentTable = this.getParentTable();
        result = result * 59 + ($parentTable == null ? 43 : ((Object)$parentTable).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TablePartitionBuilderImpl
    extends TablePartitionBuilder<TablePartition, TablePartitionBuilderImpl> {
        @Generated
        private TablePartitionBuilderImpl() {
        }

        @Override
        @Generated
        protected TablePartitionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TablePartition build() {
            return new TablePartition(this);
        }
    }

    @Generated
    public static abstract class TablePartitionBuilder<C extends TablePartition, B extends TablePartitionBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String constraint;
        @Generated
        private Long columnCount;
        @Generated
        private Long rowCount;
        @Generated
        private Long sizeBytes;
        @Generated
        private String alias;
        @Generated
        private Boolean isTemporary;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private String externalLocation;
        @Generated
        private String externalLocationRegion;
        @Generated
        private String externalLocationFormat;
        @Generated
        private Boolean isPartitioned;
        @Generated
        private String partitionStrategy;
        @Generated
        private Long partitionCount;
        @Generated
        private String partitionList;
        @Generated
        private ArrayList<Column> columns;
        @Generated
        private Table parentTable;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TablePartitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TablePartition instance, TablePartitionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.constraint(instance.constraint);
            b.columnCount(instance.columnCount);
            b.rowCount(instance.rowCount);
            b.sizeBytes(instance.sizeBytes);
            b.alias(instance.alias);
            b.isTemporary(instance.isTemporary);
            b.isQueryPreview(instance.isQueryPreview);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.externalLocation(instance.externalLocation);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.isPartitioned(instance.isPartitioned);
            b.partitionStrategy(instance.partitionStrategy);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.parentTable(instance.parentTable);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B constraint(String constraint) {
            this.constraint = constraint;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B externalLocation(String externalLocation) {
            this.externalLocation = externalLocation;
            return (B)this.self();
        }

        @Generated
        public B externalLocationRegion(String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return (B)this.self();
        }

        @Generated
        public B externalLocationFormat(String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return (B)this.self();
        }

        @Generated
        public B isPartitioned(Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return (B)this.self();
        }

        @Generated
        public B partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return (B)this.self();
        }

        @Generated
        public B partitionCount(Long partitionCount) {
            this.partitionCount = partitionCount;
            return (B)this.self();
        }

        @Generated
        public B partitionList(String partitionList) {
            this.partitionList = partitionList;
            return (B)this.self();
        }

        @Generated
        public B column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentTable(Table parentTable) {
            this.parentTable = parentTable;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TablePartition.TablePartitionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", constraint=" + this.constraint + ", columnCount=" + this.columnCount + ", rowCount=" + this.rowCount + ", sizeBytes=" + this.sizeBytes + ", alias=" + this.alias + ", isTemporary=" + this.isTemporary + ", isQueryPreview=" + this.isQueryPreview + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", externalLocation=" + this.externalLocation + ", externalLocationRegion=" + this.externalLocationRegion + ", externalLocationFormat=" + this.externalLocationFormat + ", isPartitioned=" + this.isPartitioned + ", partitionStrategy=" + this.partitionStrategy + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", columns=" + this.columns + ", parentTable=" + this.parentTable + ")";
        }
    }
}

