/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauCalculatedField
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauCalculatedField";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    String datasourceQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String dataCategory;
    @Attribute
    String role;
    @Attribute
    String tableauDataType;
    @Attribute
    String formula;
    @Attribute
    List<Map<String, String>> upstreamFields;
    @Attribute
    SortedSet<TableauWorksheet> worksheets;
    @Attribute
    TableauDatasource datasource;

    public static TableauCalculatedField refByGuid(String guid) {
        return ((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().guid(guid)).build();
    }

    public static TableauCalculatedField refByQualifiedName(String qualifiedName) {
        return ((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauCalculatedFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauCalculatedFieldBuilder)((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauCalculatedFieldBuilder<?, ?> trimToRequired() {
        return TableauCalculatedField.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauCalculatedField retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauCalculatedField) {
            return (TableauCalculatedField)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauCalculatedField.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauCalculatedField retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauCalculatedField) {
            return (TableauCalculatedField)entity;
        }
        throw new NotFoundException("No TableauCalculatedField found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauCalculatedField removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField)Asset.removeDescription(((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauCalculatedField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField)Asset.removeUserDescription(((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauCalculatedField removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField)Asset.removeOwners(((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauCalculatedField updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauCalculatedField)Asset.updateCertificate(TableauCalculatedField.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauCalculatedField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField)Asset.removeCertificate(((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauCalculatedField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauCalculatedField)Asset.updateAnnouncement(TableauCalculatedField.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauCalculatedField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField)Asset.removeAnnouncement(((TableauCalculatedFieldBuilder)TableauCalculatedField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauCalculatedField replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField)Asset.replaceTerms(TableauCalculatedField.updater(qualifiedName, name), terms);
    }

    public static TableauCalculatedField appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauCalculatedField removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauCalculatedField(TableauCalculatedFieldBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> upstreamFields;
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauCalculatedField.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        this.workbookQualifiedName = b.workbookQualifiedName;
        this.datasourceQualifiedName = b.datasourceQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.dataCategory = b.dataCategory;
        this.role = b.role;
        this.tableauDataType = b.tableauDataType;
        this.formula = b.formula;
        switch (b.upstreamFields == null ? 0 : b.upstreamFields.size()) {
            case 0: {
                upstreamFields = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamFields = Collections.singletonList(b.upstreamFields.get(0));
                break;
            }
            default: {
                upstreamFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamFields));
            }
        }
        this.upstreamFields = upstreamFields;
        SortedSet<TableauWorksheet> worksheets = new TreeSet<TableauWorksheet>();
        if (b.worksheets != null) {
            worksheets.addAll(b.worksheets);
        }
        worksheets = Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
        this.datasource = b.datasource;
    }

    @Generated
    public static TableauCalculatedFieldBuilder<?, ?> builder() {
        return new TableauCalculatedFieldBuilderImpl();
    }

    @Generated
    public TableauCalculatedFieldBuilder<?, ?> toBuilder() {
        return new TableauCalculatedFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Generated
    public String getDatasourceQualifiedName() {
        return this.datasourceQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public String getDataCategory() {
        return this.dataCategory;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getTableauDataType() {
        return this.tableauDataType;
    }

    @Generated
    public String getFormula() {
        return this.formula;
    }

    @Generated
    public List<Map<String, String>> getUpstreamFields() {
        return this.upstreamFields;
    }

    @Generated
    public SortedSet<TableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @Generated
    public TableauDatasource getDatasource() {
        return this.datasource;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setWorkbookQualifiedName(String workbookQualifiedName) {
        this.workbookQualifiedName = workbookQualifiedName;
    }

    @Generated
    public void setDatasourceQualifiedName(String datasourceQualifiedName) {
        this.datasourceQualifiedName = datasourceQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setDataCategory(String dataCategory) {
        this.dataCategory = dataCategory;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setTableauDataType(String tableauDataType) {
        this.tableauDataType = tableauDataType;
    }

    @Generated
    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Generated
    public void setUpstreamFields(List<Map<String, String>> upstreamFields) {
        this.upstreamFields = upstreamFields;
    }

    @Generated
    public void setWorksheets(SortedSet<TableauWorksheet> worksheets) {
        this.worksheets = worksheets;
    }

    @Generated
    public void setDatasource(TableauDatasource datasource) {
        this.datasource = datasource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauCalculatedField)) {
            return false;
        }
        TableauCalculatedField other = (TableauCalculatedField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        String this$datasourceQualifiedName = this.getDatasourceQualifiedName();
        String other$datasourceQualifiedName = other.getDatasourceQualifiedName();
        if (this$datasourceQualifiedName == null ? other$datasourceQualifiedName != null : !this$datasourceQualifiedName.equals(other$datasourceQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$dataCategory = this.getDataCategory();
        String other$dataCategory = other.getDataCategory();
        if (this$dataCategory == null ? other$dataCategory != null : !this$dataCategory.equals(other$dataCategory)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$tableauDataType = this.getTableauDataType();
        String other$tableauDataType = other.getTableauDataType();
        if (this$tableauDataType == null ? other$tableauDataType != null : !this$tableauDataType.equals(other$tableauDataType)) {
            return false;
        }
        String this$formula = this.getFormula();
        String other$formula = other.getFormula();
        if (this$formula == null ? other$formula != null : !this$formula.equals(other$formula)) {
            return false;
        }
        List<Map<String, String>> this$upstreamFields = this.getUpstreamFields();
        List<Map<String, String>> other$upstreamFields = other.getUpstreamFields();
        if (this$upstreamFields == null ? other$upstreamFields != null : !((Object)this$upstreamFields).equals(other$upstreamFields)) {
            return false;
        }
        SortedSet<TableauWorksheet> this$worksheets = this.getWorksheets();
        SortedSet<TableauWorksheet> other$worksheets = other.getWorksheets();
        if (this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets)) {
            return false;
        }
        TableauDatasource this$datasource = this.getDatasource();
        TableauDatasource other$datasource = other.getDatasource();
        return !(this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauCalculatedField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        String $datasourceQualifiedName = this.getDatasourceQualifiedName();
        result = result * 59 + ($datasourceQualifiedName == null ? 43 : $datasourceQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $dataCategory = this.getDataCategory();
        result = result * 59 + ($dataCategory == null ? 43 : $dataCategory.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $tableauDataType = this.getTableauDataType();
        result = result * 59 + ($tableauDataType == null ? 43 : $tableauDataType.hashCode());
        String $formula = this.getFormula();
        result = result * 59 + ($formula == null ? 43 : $formula.hashCode());
        List<Map<String, String>> $upstreamFields = this.getUpstreamFields();
        result = result * 59 + ($upstreamFields == null ? 43 : ((Object)$upstreamFields).hashCode());
        SortedSet<TableauWorksheet> $worksheets = this.getWorksheets();
        result = result * 59 + ($worksheets == null ? 43 : $worksheets.hashCode());
        TableauDatasource $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauCalculatedFieldBuilderImpl
    extends TableauCalculatedFieldBuilder<TableauCalculatedField, TableauCalculatedFieldBuilderImpl> {
        @Generated
        private TableauCalculatedFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauCalculatedFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauCalculatedField build() {
            return new TableauCalculatedField(this);
        }
    }

    @Generated
    public static abstract class TableauCalculatedFieldBuilder<C extends TableauCalculatedField, B extends TableauCalculatedFieldBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private String datasourceQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String dataCategory;
        @Generated
        private String role;
        @Generated
        private String tableauDataType;
        @Generated
        private String formula;
        @Generated
        private ArrayList<Map<String, String>> upstreamFields;
        @Generated
        private ArrayList<TableauWorksheet> worksheets;
        @Generated
        private TableauDatasource datasource;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauCalculatedFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauCalculatedField instance, TableauCalculatedFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.datasourceQualifiedName(instance.datasourceQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.dataCategory(instance.dataCategory);
            b.role(instance.role);
            b.tableauDataType(instance.tableauDataType);
            b.formula(instance.formula);
            b.upstreamFields(instance.upstreamFields == null ? Collections.emptyList() : instance.upstreamFields);
            b.worksheets(instance.worksheets == null ? Collections.emptySortedSet() : instance.worksheets);
            b.datasource(instance.datasource);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasourceQualifiedName(String datasourceQualifiedName) {
            this.datasourceQualifiedName = datasourceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataCategory(String dataCategory) {
            this.dataCategory = dataCategory;
            return (B)this.self();
        }

        @Generated
        public B role(String role) {
            this.role = role;
            return (B)this.self();
        }

        @Generated
        public B tableauDataType(String tableauDataType) {
            this.tableauDataType = tableauDataType;
            return (B)this.self();
        }

        @Generated
        public B formula(String formula) {
            this.formula = formula;
            return (B)this.self();
        }

        @Generated
        public B upstreamField(Map<String, String> upstreamField) {
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.add(upstreamField);
            return (B)this.self();
        }

        @Generated
        public B upstreamFields(Collection<? extends Map<String, String>> upstreamFields) {
            if (upstreamFields == null) {
                throw new NullPointerException("upstreamFields cannot be null");
            }
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.addAll(upstreamFields);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamFields() {
            if (this.upstreamFields != null) {
                this.upstreamFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B worksheet(TableauWorksheet worksheet) {
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.add(worksheet);
            return (B)this.self();
        }

        @Generated
        public B worksheets(Collection<? extends TableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.addAll(worksheets);
            return (B)this.self();
        }

        @Generated
        public B clearWorksheets() {
            if (this.worksheets != null) {
                this.worksheets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasource(TableauDatasource datasource) {
            this.datasource = datasource;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauCalculatedField.TableauCalculatedFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", workbookQualifiedName=" + this.workbookQualifiedName + ", datasourceQualifiedName=" + this.datasourceQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", dataCategory=" + this.dataCategory + ", role=" + this.role + ", tableauDataType=" + this.tableauDataType + ", formula=" + this.formula + ", upstreamFields=" + this.upstreamFields + ", worksheets=" + this.worksheets + ", datasource=" + this.datasource + ")";
        }
    }
}

