/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauDashboard
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDashboard";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    TableauWorkbook workbook;
    @Attribute
    SortedSet<TableauWorksheet> worksheets;

    public static TableauDashboard refByGuid(String guid) {
        return ((TableauDashboardBuilder)TableauDashboard.builder().guid(guid)).build();
    }

    public static TableauDashboard refByQualifiedName(String qualifiedName) {
        return ((TableauDashboardBuilder)TableauDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDashboardBuilder)((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauDashboardBuilder<?, ?> trimToRequired() {
        return TableauDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauDashboard) {
            return (TableauDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauDashboard) {
            return (TableauDashboard)entity;
        }
        throw new NotFoundException("No TableauDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDashboard)Asset.removeDescription(((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDashboard)Asset.removeUserDescription(((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauDashboard)Asset.removeOwners(((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauDashboard)Asset.updateCertificate(TableauDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauDashboard)Asset.removeCertificate(((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDashboard)Asset.updateAnnouncement(TableauDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauDashboard)Asset.removeAnnouncement(((TableauDashboardBuilder)TableauDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDashboard)Asset.replaceTerms(TableauDashboard.updater(qualifiedName, name), terms);
    }

    public static TableauDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDashboard(TableauDashboardBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauDashboard.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.workbookQualifiedName = b.workbookQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.workbook = b.workbook;
        SortedSet<TableauWorksheet> worksheets = new TreeSet<TableauWorksheet>();
        if (b.worksheets != null) {
            worksheets.addAll(b.worksheets);
        }
        worksheets = Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
    }

    @Generated
    public static TableauDashboardBuilder<?, ?> builder() {
        return new TableauDashboardBuilderImpl();
    }

    @Generated
    public TableauDashboardBuilder<?, ?> toBuilder() {
        return new TableauDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public TableauWorkbook getWorkbook() {
        return this.workbook;
    }

    @Generated
    public SortedSet<TableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setWorkbookQualifiedName(String workbookQualifiedName) {
        this.workbookQualifiedName = workbookQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setWorkbook(TableauWorkbook workbook) {
        this.workbook = workbook;
    }

    @Generated
    public void setWorksheets(SortedSet<TableauWorksheet> worksheets) {
        this.worksheets = worksheets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDashboard)) {
            return false;
        }
        TableauDashboard other = (TableauDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        TableauWorkbook this$workbook = this.getWorkbook();
        TableauWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !((Object)this$workbook).equals(other$workbook)) {
            return false;
        }
        SortedSet<TableauWorksheet> this$worksheets = this.getWorksheets();
        SortedSet<TableauWorksheet> other$worksheets = other.getWorksheets();
        return !(this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        TableauWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : ((Object)$workbook).hashCode());
        SortedSet<TableauWorksheet> $worksheets = this.getWorksheets();
        result = result * 59 + ($worksheets == null ? 43 : $worksheets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauDashboardBuilderImpl
    extends TableauDashboardBuilder<TableauDashboard, TableauDashboardBuilderImpl> {
        @Generated
        private TableauDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDashboard build() {
            return new TableauDashboard(this);
        }
    }

    @Generated
    public static abstract class TableauDashboardBuilder<C extends TableauDashboard, B extends TableauDashboardBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private TableauWorkbook workbook;
        @Generated
        private ArrayList<TableauWorksheet> worksheets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDashboard instance, TableauDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.workbook(instance.workbook);
            b.worksheets(instance.worksheets == null ? Collections.emptySortedSet() : instance.worksheets);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbook(TableauWorkbook workbook) {
            this.workbook = workbook;
            return (B)this.self();
        }

        @Generated
        public B worksheet(TableauWorksheet worksheet) {
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.add(worksheet);
            return (B)this.self();
        }

        @Generated
        public B worksheets(Collection<? extends TableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.addAll(worksheets);
            return (B)this.self();
        }

        @Generated
        public B clearWorksheets() {
            if (this.worksheets != null) {
                this.worksheets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauDashboard.TableauDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", workbookQualifiedName=" + this.workbookQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", workbook=" + this.workbook + ", worksheets=" + this.worksheets + ")";
        }
    }
}

