/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauCalculatedField;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauDatasource
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasource";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    Boolean isPublished;
    @Attribute
    Boolean hasExtracts;
    @Attribute
    Boolean isCertified;
    @Attribute
    Map<String, String> certifier;
    @Attribute
    String certificationNote;
    @Attribute
    String certifierDisplayName;
    @Attribute
    List<Map<String, String>> upstreamTables;
    @Attribute
    List<Map<String, String>> upstreamDatasources;
    @Attribute
    TableauWorkbook workbook;
    @Attribute
    TableauProject project;
    @Attribute
    SortedSet<TableauCalculatedField> fields;

    public static TableauDatasource refByGuid(String guid) {
        return ((TableauDatasourceBuilder)TableauDatasource.builder().guid(guid)).build();
    }

    public static TableauDatasource refByQualifiedName(String qualifiedName) {
        return ((TableauDatasourceBuilder)TableauDatasource.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauDatasourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDatasourceBuilder)((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauDatasourceBuilder<?, ?> trimToRequired() {
        return TableauDatasource.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDatasource retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauDatasource) {
            return (TableauDatasource)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauDatasource.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauDatasource retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauDatasource) {
            return (TableauDatasource)entity;
        }
        throw new NotFoundException("No TableauDatasource found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauDatasource removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeDescription(((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeUserDescription(((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasource removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeOwners(((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasource updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasource)Asset.updateCertificate(TableauDatasource.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDatasource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeCertificate(((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasource)Asset.updateAnnouncement(TableauDatasource.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDatasource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeAnnouncement(((TableauDatasourceBuilder)TableauDatasource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauDatasource replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.replaceTerms(TableauDatasource.updater(qualifiedName, name), terms);
    }

    public static TableauDatasource appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauDatasource removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDatasource(TableauDatasourceBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> upstreamDatasources;
        List<Object> upstreamTables;
        Map<Object, Object> certifier;
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauDatasource.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        this.workbookQualifiedName = b.workbookQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.isPublished = b.isPublished;
        this.hasExtracts = b.hasExtracts;
        this.isCertified = b.isCertified;
        switch (b.certifier$key == null ? 0 : b.certifier$key.size()) {
            case 0: {
                certifier = Collections.emptyMap();
                break;
            }
            case 1: {
                certifier = Collections.singletonMap(b.certifier$key.get(0), b.certifier$value.get(0));
                break;
            }
            default: {
                certifier = new LinkedHashMap(b.certifier$key.size() < 0x40000000 ? 1 + b.certifier$key.size() + (b.certifier$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.certifier$key.size(); ++$i) {
                    certifier.put(b.certifier$key.get($i), b.certifier$value.get($i));
                }
                certifier = Collections.unmodifiableMap(certifier);
            }
        }
        this.certifier = certifier;
        this.certificationNote = b.certificationNote;
        this.certifierDisplayName = b.certifierDisplayName;
        switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
            case 0: {
                upstreamTables = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamTables = Collections.singletonList(b.upstreamTables.get(0));
                break;
            }
            default: {
                upstreamTables = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamTables));
            }
        }
        this.upstreamTables = upstreamTables;
        switch (b.upstreamDatasources == null ? 0 : b.upstreamDatasources.size()) {
            case 0: {
                upstreamDatasources = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamDatasources = Collections.singletonList(b.upstreamDatasources.get(0));
                break;
            }
            default: {
                upstreamDatasources = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamDatasources));
            }
        }
        this.upstreamDatasources = upstreamDatasources;
        this.workbook = b.workbook;
        this.project = b.project;
        SortedSet<TableauCalculatedField> fields = new TreeSet<TableauCalculatedField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
    }

    @Generated
    public static TableauDatasourceBuilder<?, ?> builder() {
        return new TableauDatasourceBuilderImpl();
    }

    @Generated
    public TableauDatasourceBuilder<?, ?> toBuilder() {
        return new TableauDatasourceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    @Generated
    public Boolean getHasExtracts() {
        return this.hasExtracts;
    }

    @Generated
    public Boolean getIsCertified() {
        return this.isCertified;
    }

    @Generated
    public Map<String, String> getCertifier() {
        return this.certifier;
    }

    @Generated
    public String getCertificationNote() {
        return this.certificationNote;
    }

    @Generated
    public String getCertifierDisplayName() {
        return this.certifierDisplayName;
    }

    @Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    @Generated
    public List<Map<String, String>> getUpstreamDatasources() {
        return this.upstreamDatasources;
    }

    @Generated
    public TableauWorkbook getWorkbook() {
        return this.workbook;
    }

    @Generated
    public TableauProject getProject() {
        return this.project;
    }

    @Generated
    public SortedSet<TableauCalculatedField> getFields() {
        return this.fields;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setWorkbookQualifiedName(String workbookQualifiedName) {
        this.workbookQualifiedName = workbookQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setIsPublished(Boolean isPublished) {
        this.isPublished = isPublished;
    }

    @Generated
    public void setHasExtracts(Boolean hasExtracts) {
        this.hasExtracts = hasExtracts;
    }

    @Generated
    public void setIsCertified(Boolean isCertified) {
        this.isCertified = isCertified;
    }

    @Generated
    public void setCertifier(Map<String, String> certifier) {
        this.certifier = certifier;
    }

    @Generated
    public void setCertificationNote(String certificationNote) {
        this.certificationNote = certificationNote;
    }

    @Generated
    public void setCertifierDisplayName(String certifierDisplayName) {
        this.certifierDisplayName = certifierDisplayName;
    }

    @Generated
    public void setUpstreamTables(List<Map<String, String>> upstreamTables) {
        this.upstreamTables = upstreamTables;
    }

    @Generated
    public void setUpstreamDatasources(List<Map<String, String>> upstreamDatasources) {
        this.upstreamDatasources = upstreamDatasources;
    }

    @Generated
    public void setWorkbook(TableauWorkbook workbook) {
        this.workbook = workbook;
    }

    @Generated
    public void setProject(TableauProject project) {
        this.project = project;
    }

    @Generated
    public void setFields(SortedSet<TableauCalculatedField> fields) {
        this.fields = fields;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDatasource)) {
            return false;
        }
        TableauDatasource other = (TableauDatasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isPublished = this.getIsPublished();
        Boolean other$isPublished = other.getIsPublished();
        if (this$isPublished == null ? other$isPublished != null : !((Object)this$isPublished).equals(other$isPublished)) {
            return false;
        }
        Boolean this$hasExtracts = this.getHasExtracts();
        Boolean other$hasExtracts = other.getHasExtracts();
        if (this$hasExtracts == null ? other$hasExtracts != null : !((Object)this$hasExtracts).equals(other$hasExtracts)) {
            return false;
        }
        Boolean this$isCertified = this.getIsCertified();
        Boolean other$isCertified = other.getIsCertified();
        if (this$isCertified == null ? other$isCertified != null : !((Object)this$isCertified).equals(other$isCertified)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        Map<String, String> this$certifier = this.getCertifier();
        Map<String, String> other$certifier = other.getCertifier();
        if (this$certifier == null ? other$certifier != null : !((Object)this$certifier).equals(other$certifier)) {
            return false;
        }
        String this$certificationNote = this.getCertificationNote();
        String other$certificationNote = other.getCertificationNote();
        if (this$certificationNote == null ? other$certificationNote != null : !this$certificationNote.equals(other$certificationNote)) {
            return false;
        }
        String this$certifierDisplayName = this.getCertifierDisplayName();
        String other$certifierDisplayName = other.getCertifierDisplayName();
        if (this$certifierDisplayName == null ? other$certifierDisplayName != null : !this$certifierDisplayName.equals(other$certifierDisplayName)) {
            return false;
        }
        List<Map<String, String>> this$upstreamTables = this.getUpstreamTables();
        List<Map<String, String>> other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !((Object)this$upstreamTables).equals(other$upstreamTables)) {
            return false;
        }
        List<Map<String, String>> this$upstreamDatasources = this.getUpstreamDatasources();
        List<Map<String, String>> other$upstreamDatasources = other.getUpstreamDatasources();
        if (this$upstreamDatasources == null ? other$upstreamDatasources != null : !((Object)this$upstreamDatasources).equals(other$upstreamDatasources)) {
            return false;
        }
        TableauWorkbook this$workbook = this.getWorkbook();
        TableauWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !((Object)this$workbook).equals(other$workbook)) {
            return false;
        }
        TableauProject this$project = this.getProject();
        TableauProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        SortedSet<TableauCalculatedField> this$fields = this.getFields();
        SortedSet<TableauCalculatedField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDatasource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isPublished = this.getIsPublished();
        result = result * 59 + ($isPublished == null ? 43 : ((Object)$isPublished).hashCode());
        Boolean $hasExtracts = this.getHasExtracts();
        result = result * 59 + ($hasExtracts == null ? 43 : ((Object)$hasExtracts).hashCode());
        Boolean $isCertified = this.getIsCertified();
        result = result * 59 + ($isCertified == null ? 43 : ((Object)$isCertified).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        Map<String, String> $certifier = this.getCertifier();
        result = result * 59 + ($certifier == null ? 43 : ((Object)$certifier).hashCode());
        String $certificationNote = this.getCertificationNote();
        result = result * 59 + ($certificationNote == null ? 43 : $certificationNote.hashCode());
        String $certifierDisplayName = this.getCertifierDisplayName();
        result = result * 59 + ($certifierDisplayName == null ? 43 : $certifierDisplayName.hashCode());
        List<Map<String, String>> $upstreamTables = this.getUpstreamTables();
        result = result * 59 + ($upstreamTables == null ? 43 : ((Object)$upstreamTables).hashCode());
        List<Map<String, String>> $upstreamDatasources = this.getUpstreamDatasources();
        result = result * 59 + ($upstreamDatasources == null ? 43 : ((Object)$upstreamDatasources).hashCode());
        TableauWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : ((Object)$workbook).hashCode());
        TableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        SortedSet<TableauCalculatedField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauDatasourceBuilderImpl
    extends TableauDatasourceBuilder<TableauDatasource, TableauDatasourceBuilderImpl> {
        @Generated
        private TableauDatasourceBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDatasourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDatasource build() {
            return new TableauDatasource(this);
        }
    }

    @Generated
    public static abstract class TableauDatasourceBuilder<C extends TableauDatasource, B extends TableauDatasourceBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private Boolean isPublished;
        @Generated
        private Boolean hasExtracts;
        @Generated
        private Boolean isCertified;
        @Generated
        private ArrayList<String> certifier$key;
        @Generated
        private ArrayList<String> certifier$value;
        @Generated
        private String certificationNote;
        @Generated
        private String certifierDisplayName;
        @Generated
        private ArrayList<Map<String, String>> upstreamTables;
        @Generated
        private ArrayList<Map<String, String>> upstreamDatasources;
        @Generated
        private TableauWorkbook workbook;
        @Generated
        private TableauProject project;
        @Generated
        private ArrayList<TableauCalculatedField> fields;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDatasource instance, TableauDatasourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.isPublished(instance.isPublished);
            b.hasExtracts(instance.hasExtracts);
            b.isCertified(instance.isCertified);
            b.certifier(instance.certifier == null ? Collections.emptyMap() : instance.certifier);
            b.certificationNote(instance.certificationNote);
            b.certifierDisplayName(instance.certifierDisplayName);
            b.upstreamTables(instance.upstreamTables == null ? Collections.emptyList() : instance.upstreamTables);
            b.upstreamDatasources(instance.upstreamDatasources == null ? Collections.emptyList() : instance.upstreamDatasources);
            b.workbook(instance.workbook);
            b.project(instance.project);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isPublished(Boolean isPublished) {
            this.isPublished = isPublished;
            return (B)this.self();
        }

        @Generated
        public B hasExtracts(Boolean hasExtracts) {
            this.hasExtracts = hasExtracts;
            return (B)this.self();
        }

        @Generated
        public B isCertified(Boolean isCertified) {
            this.isCertified = isCertified;
            return (B)this.self();
        }

        @Generated
        public B putCertifier(String putCertifierKey, String putCertifierValue) {
            if (this.certifier$key == null) {
                this.certifier$key = new ArrayList();
                this.certifier$value = new ArrayList();
            }
            this.certifier$key.add(putCertifierKey);
            this.certifier$value.add(putCertifierValue);
            return (B)this.self();
        }

        @Generated
        public B certifier(Map<? extends String, ? extends String> certifier) {
            if (certifier == null) {
                throw new NullPointerException("certifier cannot be null");
            }
            if (this.certifier$key == null) {
                this.certifier$key = new ArrayList();
                this.certifier$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : certifier.entrySet()) {
                this.certifier$key.add($lombokEntry.getKey());
                this.certifier$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCertifier() {
            if (this.certifier$key != null) {
                this.certifier$key.clear();
                this.certifier$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B certificationNote(String certificationNote) {
            this.certificationNote = certificationNote;
            return (B)this.self();
        }

        @Generated
        public B certifierDisplayName(String certifierDisplayName) {
            this.certifierDisplayName = certifierDisplayName;
            return (B)this.self();
        }

        @Generated
        public B upstreamTable(Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.add(upstreamTable);
            return (B)this.self();
        }

        @Generated
        public B upstreamTables(Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.addAll(upstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) {
                this.upstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B upstreamDatasource(Map<String, String> upstreamDatasource) {
            if (this.upstreamDatasources == null) {
                this.upstreamDatasources = new ArrayList();
            }
            this.upstreamDatasources.add(upstreamDatasource);
            return (B)this.self();
        }

        @Generated
        public B upstreamDatasources(Collection<? extends Map<String, String>> upstreamDatasources) {
            if (upstreamDatasources == null) {
                throw new NullPointerException("upstreamDatasources cannot be null");
            }
            if (this.upstreamDatasources == null) {
                this.upstreamDatasources = new ArrayList();
            }
            this.upstreamDatasources.addAll(upstreamDatasources);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamDatasources() {
            if (this.upstreamDatasources != null) {
                this.upstreamDatasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbook(TableauWorkbook workbook) {
            this.workbook = workbook;
            return (B)this.self();
        }

        @Generated
        public B project(TableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B field(TableauCalculatedField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends TableauCalculatedField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauDatasource.TableauDatasourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", workbookQualifiedName=" + this.workbookQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", isPublished=" + this.isPublished + ", hasExtracts=" + this.hasExtracts + ", isCertified=" + this.isCertified + ", certifier$key=" + this.certifier$key + ", certifier$value=" + this.certifier$value + ", certificationNote=" + this.certificationNote + ", certifierDisplayName=" + this.certifierDisplayName + ", upstreamTables=" + this.upstreamTables + ", upstreamDatasources=" + this.upstreamDatasources + ", workbook=" + this.workbook + ", project=" + this.project + ", fields=" + this.fields + ")";
        }
    }
}

