/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauDatasourceField
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasourceField";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    String datasourceQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String fullyQualifiedName;
    @Attribute
    String tableauDatasourceFieldDataCategory;
    @Attribute
    String tableauDatasourceFieldRole;
    @Attribute
    String tableauDatasourceFieldDataType;
    @Attribute
    List<Map<String, String>> upstreamTables;
    @Attribute
    String tableauDatasourceFieldFormula;
    @Attribute
    String tableauDatasourceFieldBinSize;
    @Attribute
    List<Map<String, String>> upstreamColumns;
    @Attribute
    List<Map<String, String>> upstreamFields;
    @Attribute
    String datasourceFieldType;
    @Attribute
    SortedSet<TableauWorksheet> worksheets;
    @Attribute
    TableauDatasource datasource;

    public static TableauDatasourceField refByGuid(String guid) {
        return ((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().guid(guid)).build();
    }

    public static TableauDatasourceField refByQualifiedName(String qualifiedName) {
        return ((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauDatasourceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDatasourceFieldBuilder)((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauDatasourceFieldBuilder<?, ?> trimToRequired() {
        return TableauDatasourceField.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDatasourceField retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauDatasourceField) {
            return (TableauDatasourceField)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauDatasourceField.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauDatasourceField retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauDatasourceField) {
            return (TableauDatasourceField)entity;
        }
        throw new NotFoundException("No TableauDatasourceField found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauDatasourceField removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeDescription(((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasourceField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeUserDescription(((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasourceField removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeOwners(((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasourceField updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasourceField)Asset.updateCertificate(TableauDatasourceField.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDatasourceField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeCertificate(((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauDatasourceField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasourceField)Asset.updateAnnouncement(TableauDatasourceField.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDatasourceField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeAnnouncement(((TableauDatasourceFieldBuilder)TableauDatasourceField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauDatasourceField replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.replaceTerms(TableauDatasourceField.updater(qualifiedName, name), terms);
    }

    public static TableauDatasourceField appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauDatasourceField removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDatasourceField(TableauDatasourceFieldBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> upstreamFields;
        List<Object> upstreamColumns;
        List<Object> upstreamTables;
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauDatasourceField.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        this.workbookQualifiedName = b.workbookQualifiedName;
        this.datasourceQualifiedName = b.datasourceQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.fullyQualifiedName = b.fullyQualifiedName;
        this.tableauDatasourceFieldDataCategory = b.tableauDatasourceFieldDataCategory;
        this.tableauDatasourceFieldRole = b.tableauDatasourceFieldRole;
        this.tableauDatasourceFieldDataType = b.tableauDatasourceFieldDataType;
        switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
            case 0: {
                upstreamTables = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamTables = Collections.singletonList(b.upstreamTables.get(0));
                break;
            }
            default: {
                upstreamTables = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamTables));
            }
        }
        this.upstreamTables = upstreamTables;
        this.tableauDatasourceFieldFormula = b.tableauDatasourceFieldFormula;
        this.tableauDatasourceFieldBinSize = b.tableauDatasourceFieldBinSize;
        switch (b.upstreamColumns == null ? 0 : b.upstreamColumns.size()) {
            case 0: {
                upstreamColumns = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamColumns = Collections.singletonList(b.upstreamColumns.get(0));
                break;
            }
            default: {
                upstreamColumns = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamColumns));
            }
        }
        this.upstreamColumns = upstreamColumns;
        switch (b.upstreamFields == null ? 0 : b.upstreamFields.size()) {
            case 0: {
                upstreamFields = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamFields = Collections.singletonList(b.upstreamFields.get(0));
                break;
            }
            default: {
                upstreamFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamFields));
            }
        }
        this.upstreamFields = upstreamFields;
        this.datasourceFieldType = b.datasourceFieldType;
        SortedSet<TableauWorksheet> worksheets = new TreeSet<TableauWorksheet>();
        if (b.worksheets != null) {
            worksheets.addAll(b.worksheets);
        }
        worksheets = Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
        this.datasource = b.datasource;
    }

    @Generated
    public static TableauDatasourceFieldBuilder<?, ?> builder() {
        return new TableauDatasourceFieldBuilderImpl();
    }

    @Generated
    public TableauDatasourceFieldBuilder<?, ?> toBuilder() {
        return new TableauDatasourceFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Generated
    public String getDatasourceQualifiedName() {
        return this.datasourceQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Generated
    public String getTableauDatasourceFieldDataCategory() {
        return this.tableauDatasourceFieldDataCategory;
    }

    @Generated
    public String getTableauDatasourceFieldRole() {
        return this.tableauDatasourceFieldRole;
    }

    @Generated
    public String getTableauDatasourceFieldDataType() {
        return this.tableauDatasourceFieldDataType;
    }

    @Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    @Generated
    public String getTableauDatasourceFieldFormula() {
        return this.tableauDatasourceFieldFormula;
    }

    @Generated
    public String getTableauDatasourceFieldBinSize() {
        return this.tableauDatasourceFieldBinSize;
    }

    @Generated
    public List<Map<String, String>> getUpstreamColumns() {
        return this.upstreamColumns;
    }

    @Generated
    public List<Map<String, String>> getUpstreamFields() {
        return this.upstreamFields;
    }

    @Generated
    public String getDatasourceFieldType() {
        return this.datasourceFieldType;
    }

    @Generated
    public SortedSet<TableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @Generated
    public TableauDatasource getDatasource() {
        return this.datasource;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setWorkbookQualifiedName(String workbookQualifiedName) {
        this.workbookQualifiedName = workbookQualifiedName;
    }

    @Generated
    public void setDatasourceQualifiedName(String datasourceQualifiedName) {
        this.datasourceQualifiedName = datasourceQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Generated
    public void setTableauDatasourceFieldDataCategory(String tableauDatasourceFieldDataCategory) {
        this.tableauDatasourceFieldDataCategory = tableauDatasourceFieldDataCategory;
    }

    @Generated
    public void setTableauDatasourceFieldRole(String tableauDatasourceFieldRole) {
        this.tableauDatasourceFieldRole = tableauDatasourceFieldRole;
    }

    @Generated
    public void setTableauDatasourceFieldDataType(String tableauDatasourceFieldDataType) {
        this.tableauDatasourceFieldDataType = tableauDatasourceFieldDataType;
    }

    @Generated
    public void setUpstreamTables(List<Map<String, String>> upstreamTables) {
        this.upstreamTables = upstreamTables;
    }

    @Generated
    public void setTableauDatasourceFieldFormula(String tableauDatasourceFieldFormula) {
        this.tableauDatasourceFieldFormula = tableauDatasourceFieldFormula;
    }

    @Generated
    public void setTableauDatasourceFieldBinSize(String tableauDatasourceFieldBinSize) {
        this.tableauDatasourceFieldBinSize = tableauDatasourceFieldBinSize;
    }

    @Generated
    public void setUpstreamColumns(List<Map<String, String>> upstreamColumns) {
        this.upstreamColumns = upstreamColumns;
    }

    @Generated
    public void setUpstreamFields(List<Map<String, String>> upstreamFields) {
        this.upstreamFields = upstreamFields;
    }

    @Generated
    public void setDatasourceFieldType(String datasourceFieldType) {
        this.datasourceFieldType = datasourceFieldType;
    }

    @Generated
    public void setWorksheets(SortedSet<TableauWorksheet> worksheets) {
        this.worksheets = worksheets;
    }

    @Generated
    public void setDatasource(TableauDatasource datasource) {
        this.datasource = datasource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDatasourceField)) {
            return false;
        }
        TableauDatasourceField other = (TableauDatasourceField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        String this$datasourceQualifiedName = this.getDatasourceQualifiedName();
        String other$datasourceQualifiedName = other.getDatasourceQualifiedName();
        if (this$datasourceQualifiedName == null ? other$datasourceQualifiedName != null : !this$datasourceQualifiedName.equals(other$datasourceQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$fullyQualifiedName = this.getFullyQualifiedName();
        String other$fullyQualifiedName = other.getFullyQualifiedName();
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
            return false;
        }
        String this$tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        String other$tableauDatasourceFieldDataCategory = other.getTableauDatasourceFieldDataCategory();
        if (this$tableauDatasourceFieldDataCategory == null ? other$tableauDatasourceFieldDataCategory != null : !this$tableauDatasourceFieldDataCategory.equals(other$tableauDatasourceFieldDataCategory)) {
            return false;
        }
        String this$tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        String other$tableauDatasourceFieldRole = other.getTableauDatasourceFieldRole();
        if (this$tableauDatasourceFieldRole == null ? other$tableauDatasourceFieldRole != null : !this$tableauDatasourceFieldRole.equals(other$tableauDatasourceFieldRole)) {
            return false;
        }
        String this$tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        String other$tableauDatasourceFieldDataType = other.getTableauDatasourceFieldDataType();
        if (this$tableauDatasourceFieldDataType == null ? other$tableauDatasourceFieldDataType != null : !this$tableauDatasourceFieldDataType.equals(other$tableauDatasourceFieldDataType)) {
            return false;
        }
        List<Map<String, String>> this$upstreamTables = this.getUpstreamTables();
        List<Map<String, String>> other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !((Object)this$upstreamTables).equals(other$upstreamTables)) {
            return false;
        }
        String this$tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        String other$tableauDatasourceFieldFormula = other.getTableauDatasourceFieldFormula();
        if (this$tableauDatasourceFieldFormula == null ? other$tableauDatasourceFieldFormula != null : !this$tableauDatasourceFieldFormula.equals(other$tableauDatasourceFieldFormula)) {
            return false;
        }
        String this$tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        String other$tableauDatasourceFieldBinSize = other.getTableauDatasourceFieldBinSize();
        if (this$tableauDatasourceFieldBinSize == null ? other$tableauDatasourceFieldBinSize != null : !this$tableauDatasourceFieldBinSize.equals(other$tableauDatasourceFieldBinSize)) {
            return false;
        }
        List<Map<String, String>> this$upstreamColumns = this.getUpstreamColumns();
        List<Map<String, String>> other$upstreamColumns = other.getUpstreamColumns();
        if (this$upstreamColumns == null ? other$upstreamColumns != null : !((Object)this$upstreamColumns).equals(other$upstreamColumns)) {
            return false;
        }
        List<Map<String, String>> this$upstreamFields = this.getUpstreamFields();
        List<Map<String, String>> other$upstreamFields = other.getUpstreamFields();
        if (this$upstreamFields == null ? other$upstreamFields != null : !((Object)this$upstreamFields).equals(other$upstreamFields)) {
            return false;
        }
        String this$datasourceFieldType = this.getDatasourceFieldType();
        String other$datasourceFieldType = other.getDatasourceFieldType();
        if (this$datasourceFieldType == null ? other$datasourceFieldType != null : !this$datasourceFieldType.equals(other$datasourceFieldType)) {
            return false;
        }
        SortedSet<TableauWorksheet> this$worksheets = this.getWorksheets();
        SortedSet<TableauWorksheet> other$worksheets = other.getWorksheets();
        if (this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets)) {
            return false;
        }
        TableauDatasource this$datasource = this.getDatasource();
        TableauDatasource other$datasource = other.getDatasource();
        return !(this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDatasourceField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        String $datasourceQualifiedName = this.getDatasourceQualifiedName();
        result = result * 59 + ($datasourceQualifiedName == null ? 43 : $datasourceQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $fullyQualifiedName = this.getFullyQualifiedName();
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        String $tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        result = result * 59 + ($tableauDatasourceFieldDataCategory == null ? 43 : $tableauDatasourceFieldDataCategory.hashCode());
        String $tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        result = result * 59 + ($tableauDatasourceFieldRole == null ? 43 : $tableauDatasourceFieldRole.hashCode());
        String $tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        result = result * 59 + ($tableauDatasourceFieldDataType == null ? 43 : $tableauDatasourceFieldDataType.hashCode());
        List<Map<String, String>> $upstreamTables = this.getUpstreamTables();
        result = result * 59 + ($upstreamTables == null ? 43 : ((Object)$upstreamTables).hashCode());
        String $tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        result = result * 59 + ($tableauDatasourceFieldFormula == null ? 43 : $tableauDatasourceFieldFormula.hashCode());
        String $tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        result = result * 59 + ($tableauDatasourceFieldBinSize == null ? 43 : $tableauDatasourceFieldBinSize.hashCode());
        List<Map<String, String>> $upstreamColumns = this.getUpstreamColumns();
        result = result * 59 + ($upstreamColumns == null ? 43 : ((Object)$upstreamColumns).hashCode());
        List<Map<String, String>> $upstreamFields = this.getUpstreamFields();
        result = result * 59 + ($upstreamFields == null ? 43 : ((Object)$upstreamFields).hashCode());
        String $datasourceFieldType = this.getDatasourceFieldType();
        result = result * 59 + ($datasourceFieldType == null ? 43 : $datasourceFieldType.hashCode());
        SortedSet<TableauWorksheet> $worksheets = this.getWorksheets();
        result = result * 59 + ($worksheets == null ? 43 : $worksheets.hashCode());
        TableauDatasource $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauDatasourceFieldBuilderImpl
    extends TableauDatasourceFieldBuilder<TableauDatasourceField, TableauDatasourceFieldBuilderImpl> {
        @Generated
        private TableauDatasourceFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDatasourceFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDatasourceField build() {
            return new TableauDatasourceField(this);
        }
    }

    @Generated
    public static abstract class TableauDatasourceFieldBuilder<C extends TableauDatasourceField, B extends TableauDatasourceFieldBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private String datasourceQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String fullyQualifiedName;
        @Generated
        private String tableauDatasourceFieldDataCategory;
        @Generated
        private String tableauDatasourceFieldRole;
        @Generated
        private String tableauDatasourceFieldDataType;
        @Generated
        private ArrayList<Map<String, String>> upstreamTables;
        @Generated
        private String tableauDatasourceFieldFormula;
        @Generated
        private String tableauDatasourceFieldBinSize;
        @Generated
        private ArrayList<Map<String, String>> upstreamColumns;
        @Generated
        private ArrayList<Map<String, String>> upstreamFields;
        @Generated
        private String datasourceFieldType;
        @Generated
        private ArrayList<TableauWorksheet> worksheets;
        @Generated
        private TableauDatasource datasource;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasourceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDatasourceField instance, TableauDatasourceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.datasourceQualifiedName(instance.datasourceQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.fullyQualifiedName(instance.fullyQualifiedName);
            b.tableauDatasourceFieldDataCategory(instance.tableauDatasourceFieldDataCategory);
            b.tableauDatasourceFieldRole(instance.tableauDatasourceFieldRole);
            b.tableauDatasourceFieldDataType(instance.tableauDatasourceFieldDataType);
            b.upstreamTables(instance.upstreamTables == null ? Collections.emptyList() : instance.upstreamTables);
            b.tableauDatasourceFieldFormula(instance.tableauDatasourceFieldFormula);
            b.tableauDatasourceFieldBinSize(instance.tableauDatasourceFieldBinSize);
            b.upstreamColumns(instance.upstreamColumns == null ? Collections.emptyList() : instance.upstreamColumns);
            b.upstreamFields(instance.upstreamFields == null ? Collections.emptyList() : instance.upstreamFields);
            b.datasourceFieldType(instance.datasourceFieldType);
            b.worksheets(instance.worksheets == null ? Collections.emptySortedSet() : instance.worksheets);
            b.datasource(instance.datasource);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B datasourceQualifiedName(String datasourceQualifiedName) {
            this.datasourceQualifiedName = datasourceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldDataCategory(String tableauDatasourceFieldDataCategory) {
            this.tableauDatasourceFieldDataCategory = tableauDatasourceFieldDataCategory;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldRole(String tableauDatasourceFieldRole) {
            this.tableauDatasourceFieldRole = tableauDatasourceFieldRole;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldDataType(String tableauDatasourceFieldDataType) {
            this.tableauDatasourceFieldDataType = tableauDatasourceFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B upstreamTable(Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.add(upstreamTable);
            return (B)this.self();
        }

        @Generated
        public B upstreamTables(Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.addAll(upstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) {
                this.upstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldFormula(String tableauDatasourceFieldFormula) {
            this.tableauDatasourceFieldFormula = tableauDatasourceFieldFormula;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldBinSize(String tableauDatasourceFieldBinSize) {
            this.tableauDatasourceFieldBinSize = tableauDatasourceFieldBinSize;
            return (B)this.self();
        }

        @Generated
        public B upstreamColumn(Map<String, String> upstreamColumn) {
            if (this.upstreamColumns == null) {
                this.upstreamColumns = new ArrayList();
            }
            this.upstreamColumns.add(upstreamColumn);
            return (B)this.self();
        }

        @Generated
        public B upstreamColumns(Collection<? extends Map<String, String>> upstreamColumns) {
            if (upstreamColumns == null) {
                throw new NullPointerException("upstreamColumns cannot be null");
            }
            if (this.upstreamColumns == null) {
                this.upstreamColumns = new ArrayList();
            }
            this.upstreamColumns.addAll(upstreamColumns);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamColumns() {
            if (this.upstreamColumns != null) {
                this.upstreamColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B upstreamField(Map<String, String> upstreamField) {
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.add(upstreamField);
            return (B)this.self();
        }

        @Generated
        public B upstreamFields(Collection<? extends Map<String, String>> upstreamFields) {
            if (upstreamFields == null) {
                throw new NullPointerException("upstreamFields cannot be null");
            }
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.addAll(upstreamFields);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamFields() {
            if (this.upstreamFields != null) {
                this.upstreamFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasourceFieldType(String datasourceFieldType) {
            this.datasourceFieldType = datasourceFieldType;
            return (B)this.self();
        }

        @Generated
        public B worksheet(TableauWorksheet worksheet) {
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.add(worksheet);
            return (B)this.self();
        }

        @Generated
        public B worksheets(Collection<? extends TableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.addAll(worksheets);
            return (B)this.self();
        }

        @Generated
        public B clearWorksheets() {
            if (this.worksheets != null) {
                this.worksheets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasource(TableauDatasource datasource) {
            this.datasource = datasource;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauDatasourceField.TableauDatasourceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", workbookQualifiedName=" + this.workbookQualifiedName + ", datasourceQualifiedName=" + this.datasourceQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", fullyQualifiedName=" + this.fullyQualifiedName + ", tableauDatasourceFieldDataCategory=" + this.tableauDatasourceFieldDataCategory + ", tableauDatasourceFieldRole=" + this.tableauDatasourceFieldRole + ", tableauDatasourceFieldDataType=" + this.tableauDatasourceFieldDataType + ", upstreamTables=" + this.upstreamTables + ", tableauDatasourceFieldFormula=" + this.tableauDatasourceFieldFormula + ", tableauDatasourceFieldBinSize=" + this.tableauDatasourceFieldBinSize + ", upstreamColumns=" + this.upstreamColumns + ", upstreamFields=" + this.upstreamFields + ", datasourceFieldType=" + this.datasourceFieldType + ", worksheets=" + this.worksheets + ", datasource=" + this.datasource + ")";
        }
    }
}

