/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TableauFlow
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauFlow";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    List<Map<String, String>> inputFields;
    @Attribute
    List<Map<String, String>> outputFields;
    @Attribute
    List<Map<String, String>> outputSteps;
    @Attribute
    TableauProject project;

    public static TableauFlow refByGuid(String guid) {
        return ((TableauFlowBuilder)TableauFlow.builder().guid(guid)).build();
    }

    public static TableauFlow refByQualifiedName(String qualifiedName) {
        return ((TableauFlowBuilder)TableauFlow.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauFlowBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauFlowBuilder)((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauFlowBuilder<?, ?> trimToRequired() {
        return TableauFlow.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauFlow retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauFlow) {
            return (TableauFlow)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauFlow.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauFlow retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauFlow) {
            return (TableauFlow)entity;
        }
        throw new NotFoundException("No TableauFlow found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauFlow removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeDescription(((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauFlow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeUserDescription(((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauFlow removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeOwners(((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauFlow updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauFlow)Asset.updateCertificate(TableauFlow.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauFlow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeCertificate(((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauFlow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauFlow)Asset.updateAnnouncement(TableauFlow.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauFlow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeAnnouncement(((TableauFlowBuilder)TableauFlow.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauFlow replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.replaceTerms(TableauFlow.updater(qualifiedName, name), terms);
    }

    public static TableauFlow appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauFlow removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauFlow(TableauFlowBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> outputSteps;
        List<Object> outputFields;
        List<Object> inputFields;
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauFlow.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        switch (b.inputFields == null ? 0 : b.inputFields.size()) {
            case 0: {
                inputFields = Collections.emptyList();
                break;
            }
            case 1: {
                inputFields = Collections.singletonList(b.inputFields.get(0));
                break;
            }
            default: {
                inputFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.inputFields));
            }
        }
        this.inputFields = inputFields;
        switch (b.outputFields == null ? 0 : b.outputFields.size()) {
            case 0: {
                outputFields = Collections.emptyList();
                break;
            }
            case 1: {
                outputFields = Collections.singletonList(b.outputFields.get(0));
                break;
            }
            default: {
                outputFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.outputFields));
            }
        }
        this.outputFields = outputFields;
        switch (b.outputSteps == null ? 0 : b.outputSteps.size()) {
            case 0: {
                outputSteps = Collections.emptyList();
                break;
            }
            case 1: {
                outputSteps = Collections.singletonList(b.outputSteps.get(0));
                break;
            }
            default: {
                outputSteps = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.outputSteps));
            }
        }
        this.outputSteps = outputSteps;
        this.project = b.project;
    }

    @Generated
    public static TableauFlowBuilder<?, ?> builder() {
        return new TableauFlowBuilderImpl();
    }

    @Generated
    public TableauFlowBuilder<?, ?> toBuilder() {
        return new TableauFlowBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public List<Map<String, String>> getInputFields() {
        return this.inputFields;
    }

    @Generated
    public List<Map<String, String>> getOutputFields() {
        return this.outputFields;
    }

    @Generated
    public List<Map<String, String>> getOutputSteps() {
        return this.outputSteps;
    }

    @Generated
    public TableauProject getProject() {
        return this.project;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setInputFields(List<Map<String, String>> inputFields) {
        this.inputFields = inputFields;
    }

    @Generated
    public void setOutputFields(List<Map<String, String>> outputFields) {
        this.outputFields = outputFields;
    }

    @Generated
    public void setOutputSteps(List<Map<String, String>> outputSteps) {
        this.outputSteps = outputSteps;
    }

    @Generated
    public void setProject(TableauProject project) {
        this.project = project;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauFlow)) {
            return false;
        }
        TableauFlow other = (TableauFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        List<Map<String, String>> this$inputFields = this.getInputFields();
        List<Map<String, String>> other$inputFields = other.getInputFields();
        if (this$inputFields == null ? other$inputFields != null : !((Object)this$inputFields).equals(other$inputFields)) {
            return false;
        }
        List<Map<String, String>> this$outputFields = this.getOutputFields();
        List<Map<String, String>> other$outputFields = other.getOutputFields();
        if (this$outputFields == null ? other$outputFields != null : !((Object)this$outputFields).equals(other$outputFields)) {
            return false;
        }
        List<Map<String, String>> this$outputSteps = this.getOutputSteps();
        List<Map<String, String>> other$outputSteps = other.getOutputSteps();
        if (this$outputSteps == null ? other$outputSteps != null : !((Object)this$outputSteps).equals(other$outputSteps)) {
            return false;
        }
        TableauProject this$project = this.getProject();
        TableauProject other$project = other.getProject();
        return !(this$project == null ? other$project != null : !((Object)this$project).equals(other$project));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauFlow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        List<Map<String, String>> $inputFields = this.getInputFields();
        result = result * 59 + ($inputFields == null ? 43 : ((Object)$inputFields).hashCode());
        List<Map<String, String>> $outputFields = this.getOutputFields();
        result = result * 59 + ($outputFields == null ? 43 : ((Object)$outputFields).hashCode());
        List<Map<String, String>> $outputSteps = this.getOutputSteps();
        result = result * 59 + ($outputSteps == null ? 43 : ((Object)$outputSteps).hashCode());
        TableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauFlowBuilderImpl
    extends TableauFlowBuilder<TableauFlow, TableauFlowBuilderImpl> {
        @Generated
        private TableauFlowBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauFlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauFlow build() {
            return new TableauFlow(this);
        }
    }

    @Generated
    public static abstract class TableauFlowBuilder<C extends TableauFlow, B extends TableauFlowBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private ArrayList<Map<String, String>> inputFields;
        @Generated
        private ArrayList<Map<String, String>> outputFields;
        @Generated
        private ArrayList<Map<String, String>> outputSteps;
        @Generated
        private TableauProject project;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauFlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauFlow instance, TableauFlowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.inputFields(instance.inputFields == null ? Collections.emptyList() : instance.inputFields);
            b.outputFields(instance.outputFields == null ? Collections.emptyList() : instance.outputFields);
            b.outputSteps(instance.outputSteps == null ? Collections.emptyList() : instance.outputSteps);
            b.project(instance.project);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputField(Map<String, String> inputField) {
            if (this.inputFields == null) {
                this.inputFields = new ArrayList();
            }
            this.inputFields.add(inputField);
            return (B)this.self();
        }

        @Generated
        public B inputFields(Collection<? extends Map<String, String>> inputFields) {
            if (inputFields == null) {
                throw new NullPointerException("inputFields cannot be null");
            }
            if (this.inputFields == null) {
                this.inputFields = new ArrayList();
            }
            this.inputFields.addAll(inputFields);
            return (B)this.self();
        }

        @Generated
        public B clearInputFields() {
            if (this.inputFields != null) {
                this.inputFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputField(Map<String, String> outputField) {
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.add(outputField);
            return (B)this.self();
        }

        @Generated
        public B outputFields(Collection<? extends Map<String, String>> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields cannot be null");
            }
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.addAll(outputFields);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFields() {
            if (this.outputFields != null) {
                this.outputFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputStep(Map<String, String> outputStep) {
            if (this.outputSteps == null) {
                this.outputSteps = new ArrayList();
            }
            this.outputSteps.add(outputStep);
            return (B)this.self();
        }

        @Generated
        public B outputSteps(Collection<? extends Map<String, String>> outputSteps) {
            if (outputSteps == null) {
                throw new NullPointerException("outputSteps cannot be null");
            }
            if (this.outputSteps == null) {
                this.outputSteps = new ArrayList();
            }
            this.outputSteps.addAll(outputSteps);
            return (B)this.self();
        }

        @Generated
        public B clearOutputSteps() {
            if (this.outputSteps != null) {
                this.outputSteps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(TableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauFlow.TableauFlowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", inputFields=" + this.inputFields + ", outputFields=" + this.outputFields + ", outputSteps=" + this.outputSteps + ", project=" + this.project + ")";
        }
    }
}

