/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TableauMetric
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauMetric";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    TableauProject project;

    public static TableauMetric refByGuid(String guid) {
        return ((TableauMetricBuilder)TableauMetric.builder().guid(guid)).build();
    }

    public static TableauMetric refByQualifiedName(String qualifiedName) {
        return ((TableauMetricBuilder)TableauMetric.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauMetricBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauMetricBuilder)((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauMetricBuilder<?, ?> trimToRequired() {
        return TableauMetric.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauMetric retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauMetric) {
            return (TableauMetric)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauMetric.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauMetric retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauMetric) {
            return (TableauMetric)entity;
        }
        throw new NotFoundException("No TableauMetric found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauMetric removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauMetric)Asset.removeDescription(((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauMetric removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauMetric)Asset.removeUserDescription(((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauMetric removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauMetric)Asset.removeOwners(((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauMetric updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauMetric)Asset.updateCertificate(TableauMetric.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauMetric removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauMetric)Asset.removeCertificate(((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauMetric updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauMetric)Asset.updateAnnouncement(TableauMetric.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauMetric removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauMetric)Asset.removeAnnouncement(((TableauMetricBuilder)TableauMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauMetric replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauMetric)Asset.replaceTerms(TableauMetric.updater(qualifiedName, name), terms);
    }

    public static TableauMetric appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauMetric)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauMetric removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauMetric)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauMetric(TableauMetricBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauMetric.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.project = b.project;
    }

    @Generated
    public static TableauMetricBuilder<?, ?> builder() {
        return new TableauMetricBuilderImpl();
    }

    @Generated
    public TableauMetricBuilder<?, ?> toBuilder() {
        return new TableauMetricBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public TableauProject getProject() {
        return this.project;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setProject(TableauProject project) {
        this.project = project;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauMetric)) {
            return false;
        }
        TableauMetric other = (TableauMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        TableauProject this$project = this.getProject();
        TableauProject other$project = other.getProject();
        return !(this$project == null ? other$project != null : !((Object)this$project).equals(other$project));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        TableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauMetricBuilderImpl
    extends TableauMetricBuilder<TableauMetric, TableauMetricBuilderImpl> {
        @Generated
        private TableauMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauMetric build() {
            return new TableauMetric(this);
        }
    }

    @Generated
    public static abstract class TableauMetricBuilder<C extends TableauMetric, B extends TableauMetricBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private TableauProject project;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauMetricBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauMetric instance, TableauMetricBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.project(instance.project);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(TableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauMetric.TableauMetricBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", project=" + this.project + ")";
        }
    }
}

