/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauFlow;
import com.atlan.model.assets.TableauSite;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauProject
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauProject";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    Boolean isTopLevelProject;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    SortedSet<TableauWorkbook> workbooks;
    @Attribute
    TableauSite site;
    @Attribute
    TableauProject parentProject;
    @Attribute
    SortedSet<TableauDatasource> datasources;
    @Attribute
    SortedSet<TableauFlow> flows;
    @Attribute
    SortedSet<TableauProject> childProjects;

    public static TableauProject refByGuid(String guid) {
        return ((TableauProjectBuilder)TableauProject.builder().guid(guid)).build();
    }

    public static TableauProject refByQualifiedName(String qualifiedName) {
        return ((TableauProjectBuilder)TableauProject.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauProjectBuilder)((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauProjectBuilder<?, ?> trimToRequired() {
        return TableauProject.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauProject retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauProject) {
            return (TableauProject)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauProject.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauProject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauProject) {
            return (TableauProject)entity;
        }
        throw new NotFoundException("No TableauProject found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeDescription(((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeUserDescription(((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeOwners(((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauProject updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauProject)Asset.updateCertificate(TableauProject.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeCertificate(((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauProject)Asset.updateAnnouncement(TableauProject.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeAnnouncement(((TableauProjectBuilder)TableauProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauProject replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.replaceTerms(TableauProject.updater(qualifiedName, name), terms);
    }

    public static TableauProject appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauProject removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauProject(TableauProjectBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauProject.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        this.isTopLevelProject = b.isTopLevelProject;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        SortedSet<TableauWorkbook> workbooks = new TreeSet<TableauWorkbook>();
        if (b.workbooks != null) {
            workbooks.addAll(b.workbooks);
        }
        workbooks = Collections.unmodifiableSortedSet(workbooks);
        this.workbooks = workbooks;
        this.site = b.site;
        this.parentProject = b.parentProject;
        SortedSet<TableauDatasource> datasources = new TreeSet<TableauDatasource>();
        if (b.datasources != null) {
            datasources.addAll(b.datasources);
        }
        datasources = Collections.unmodifiableSortedSet(datasources);
        this.datasources = datasources;
        SortedSet<TableauFlow> flows = new TreeSet<TableauFlow>();
        if (b.flows != null) {
            flows.addAll(b.flows);
        }
        flows = Collections.unmodifiableSortedSet(flows);
        this.flows = flows;
        SortedSet<TableauProject> childProjects = new TreeSet<TableauProject>();
        if (b.childProjects != null) {
            childProjects.addAll(b.childProjects);
        }
        childProjects = Collections.unmodifiableSortedSet(childProjects);
        this.childProjects = childProjects;
    }

    @Generated
    public static TableauProjectBuilder<?, ?> builder() {
        return new TableauProjectBuilderImpl();
    }

    @Generated
    public TableauProjectBuilder<?, ?> toBuilder() {
        return new TableauProjectBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public Boolean getIsTopLevelProject() {
        return this.isTopLevelProject;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public SortedSet<TableauWorkbook> getWorkbooks() {
        return this.workbooks;
    }

    @Generated
    public TableauSite getSite() {
        return this.site;
    }

    @Generated
    public TableauProject getParentProject() {
        return this.parentProject;
    }

    @Generated
    public SortedSet<TableauDatasource> getDatasources() {
        return this.datasources;
    }

    @Generated
    public SortedSet<TableauFlow> getFlows() {
        return this.flows;
    }

    @Generated
    public SortedSet<TableauProject> getChildProjects() {
        return this.childProjects;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setIsTopLevelProject(Boolean isTopLevelProject) {
        this.isTopLevelProject = isTopLevelProject;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setWorkbooks(SortedSet<TableauWorkbook> workbooks) {
        this.workbooks = workbooks;
    }

    @Generated
    public void setSite(TableauSite site) {
        this.site = site;
    }

    @Generated
    public void setParentProject(TableauProject parentProject) {
        this.parentProject = parentProject;
    }

    @Generated
    public void setDatasources(SortedSet<TableauDatasource> datasources) {
        this.datasources = datasources;
    }

    @Generated
    public void setFlows(SortedSet<TableauFlow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setChildProjects(SortedSet<TableauProject> childProjects) {
        this.childProjects = childProjects;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauProject)) {
            return false;
        }
        TableauProject other = (TableauProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isTopLevelProject = this.getIsTopLevelProject();
        Boolean other$isTopLevelProject = other.getIsTopLevelProject();
        if (this$isTopLevelProject == null ? other$isTopLevelProject != null : !((Object)this$isTopLevelProject).equals(other$isTopLevelProject)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        SortedSet<TableauWorkbook> this$workbooks = this.getWorkbooks();
        SortedSet<TableauWorkbook> other$workbooks = other.getWorkbooks();
        if (this$workbooks == null ? other$workbooks != null : !this$workbooks.equals(other$workbooks)) {
            return false;
        }
        TableauSite this$site = this.getSite();
        TableauSite other$site = other.getSite();
        if (this$site == null ? other$site != null : !((Object)this$site).equals(other$site)) {
            return false;
        }
        TableauProject this$parentProject = this.getParentProject();
        TableauProject other$parentProject = other.getParentProject();
        if (this$parentProject == null ? other$parentProject != null : !((Object)this$parentProject).equals(other$parentProject)) {
            return false;
        }
        SortedSet<TableauDatasource> this$datasources = this.getDatasources();
        SortedSet<TableauDatasource> other$datasources = other.getDatasources();
        if (this$datasources == null ? other$datasources != null : !this$datasources.equals(other$datasources)) {
            return false;
        }
        SortedSet<TableauFlow> this$flows = this.getFlows();
        SortedSet<TableauFlow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !this$flows.equals(other$flows)) {
            return false;
        }
        SortedSet<TableauProject> this$childProjects = this.getChildProjects();
        SortedSet<TableauProject> other$childProjects = other.getChildProjects();
        return !(this$childProjects == null ? other$childProjects != null : !this$childProjects.equals(other$childProjects));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauProject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isTopLevelProject = this.getIsTopLevelProject();
        result = result * 59 + ($isTopLevelProject == null ? 43 : ((Object)$isTopLevelProject).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        SortedSet<TableauWorkbook> $workbooks = this.getWorkbooks();
        result = result * 59 + ($workbooks == null ? 43 : $workbooks.hashCode());
        TableauSite $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : ((Object)$site).hashCode());
        TableauProject $parentProject = this.getParentProject();
        result = result * 59 + ($parentProject == null ? 43 : ((Object)$parentProject).hashCode());
        SortedSet<TableauDatasource> $datasources = this.getDatasources();
        result = result * 59 + ($datasources == null ? 43 : $datasources.hashCode());
        SortedSet<TableauFlow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : $flows.hashCode());
        SortedSet<TableauProject> $childProjects = this.getChildProjects();
        result = result * 59 + ($childProjects == null ? 43 : $childProjects.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauProjectBuilderImpl
    extends TableauProjectBuilder<TableauProject, TableauProjectBuilderImpl> {
        @Generated
        private TableauProjectBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauProjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauProject build() {
            return new TableauProject(this);
        }
    }

    @Generated
    public static abstract class TableauProjectBuilder<C extends TableauProject, B extends TableauProjectBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private Boolean isTopLevelProject;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private ArrayList<TableauWorkbook> workbooks;
        @Generated
        private TableauSite site;
        @Generated
        private TableauProject parentProject;
        @Generated
        private ArrayList<TableauDatasource> datasources;
        @Generated
        private ArrayList<TableauFlow> flows;
        @Generated
        private ArrayList<TableauProject> childProjects;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauProject instance, TableauProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.isTopLevelProject(instance.isTopLevelProject);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.workbooks(instance.workbooks == null ? Collections.emptySortedSet() : instance.workbooks);
            b.site(instance.site);
            b.parentProject(instance.parentProject);
            b.datasources(instance.datasources == null ? Collections.emptySortedSet() : instance.datasources);
            b.flows(instance.flows == null ? Collections.emptySortedSet() : instance.flows);
            b.childProjects(instance.childProjects == null ? Collections.emptySortedSet() : instance.childProjects);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B isTopLevelProject(Boolean isTopLevelProject) {
            this.isTopLevelProject = isTopLevelProject;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbook(TableauWorkbook workbook) {
            if (this.workbooks == null) {
                this.workbooks = new ArrayList();
            }
            this.workbooks.add(workbook);
            return (B)this.self();
        }

        @Generated
        public B workbooks(Collection<? extends TableauWorkbook> workbooks) {
            if (workbooks == null) {
                throw new NullPointerException("workbooks cannot be null");
            }
            if (this.workbooks == null) {
                this.workbooks = new ArrayList();
            }
            this.workbooks.addAll(workbooks);
            return (B)this.self();
        }

        @Generated
        public B clearWorkbooks() {
            if (this.workbooks != null) {
                this.workbooks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B site(TableauSite site) {
            this.site = site;
            return (B)this.self();
        }

        @Generated
        public B parentProject(TableauProject parentProject) {
            this.parentProject = parentProject;
            return (B)this.self();
        }

        @Generated
        public B datasource(TableauDatasource datasource) {
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.add(datasource);
            return (B)this.self();
        }

        @Generated
        public B datasources(Collection<? extends TableauDatasource> datasources) {
            if (datasources == null) {
                throw new NullPointerException("datasources cannot be null");
            }
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.addAll(datasources);
            return (B)this.self();
        }

        @Generated
        public B clearDatasources() {
            if (this.datasources != null) {
                this.datasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flow(TableauFlow flow) {
            if (this.flows == null) {
                this.flows = new ArrayList();
            }
            this.flows.add(flow);
            return (B)this.self();
        }

        @Generated
        public B flows(Collection<? extends TableauFlow> flows) {
            if (flows == null) {
                throw new NullPointerException("flows cannot be null");
            }
            if (this.flows == null) {
                this.flows = new ArrayList();
            }
            this.flows.addAll(flows);
            return (B)this.self();
        }

        @Generated
        public B clearFlows() {
            if (this.flows != null) {
                this.flows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B childProject(TableauProject childProject) {
            if (this.childProjects == null) {
                this.childProjects = new ArrayList();
            }
            this.childProjects.add(childProject);
            return (B)this.self();
        }

        @Generated
        public B childProjects(Collection<? extends TableauProject> childProjects) {
            if (childProjects == null) {
                throw new NullPointerException("childProjects cannot be null");
            }
            if (this.childProjects == null) {
                this.childProjects = new ArrayList();
            }
            this.childProjects.addAll(childProjects);
            return (B)this.self();
        }

        @Generated
        public B clearChildProjects() {
            if (this.childProjects != null) {
                this.childProjects.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauProject.TableauProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", isTopLevelProject=" + this.isTopLevelProject + ", projectHierarchy=" + this.projectHierarchy + ", workbooks=" + this.workbooks + ", site=" + this.site + ", parentProject=" + this.parentProject + ", datasources=" + this.datasources + ", flows=" + this.flows + ", childProjects=" + this.childProjects + ")";
        }
    }
}

