/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauSite
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauSite";
    String typeName;
    @Attribute
    SortedSet<TableauProject> projects;

    public static TableauSite refByGuid(String guid) {
        return ((TableauSiteBuilder)TableauSite.builder().guid(guid)).build();
    }

    public static TableauSite refByQualifiedName(String qualifiedName) {
        return ((TableauSiteBuilder)TableauSite.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauSiteBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauSiteBuilder)((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauSiteBuilder<?, ?> trimToRequired() {
        return TableauSite.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauSite retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauSite) {
            return (TableauSite)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauSite.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauSite retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauSite) {
            return (TableauSite)entity;
        }
        throw new NotFoundException("No TableauSite found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauSite removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauSite)Asset.removeDescription(((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauSite removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauSite)Asset.removeUserDescription(((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauSite removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauSite)Asset.removeOwners(((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauSite updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauSite)Asset.updateCertificate(TableauSite.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauSite removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauSite)Asset.removeCertificate(((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauSite updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauSite)Asset.updateAnnouncement(TableauSite.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauSite removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauSite)Asset.removeAnnouncement(((TableauSiteBuilder)TableauSite.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauSite replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauSite)Asset.replaceTerms(TableauSite.updater(qualifiedName, name), terms);
    }

    public static TableauSite appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauSite)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauSite removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauSite)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauSite(TableauSiteBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TableauSite.$default$typeName();
        SortedSet<TableauProject> projects = new TreeSet<TableauProject>();
        if (b.projects != null) {
            projects.addAll(b.projects);
        }
        projects = Collections.unmodifiableSortedSet(projects);
        this.projects = projects;
    }

    @Generated
    public static TableauSiteBuilder<?, ?> builder() {
        return new TableauSiteBuilderImpl();
    }

    @Generated
    public TableauSiteBuilder<?, ?> toBuilder() {
        return new TableauSiteBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public SortedSet<TableauProject> getProjects() {
        return this.projects;
    }

    @Generated
    public void setProjects(SortedSet<TableauProject> projects) {
        this.projects = projects;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauSite)) {
            return false;
        }
        TableauSite other = (TableauSite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<TableauProject> this$projects = this.getProjects();
        SortedSet<TableauProject> other$projects = other.getProjects();
        return !(this$projects == null ? other$projects != null : !this$projects.equals(other$projects));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauSite;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<TableauProject> $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : $projects.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauSiteBuilderImpl
    extends TableauSiteBuilder<TableauSite, TableauSiteBuilderImpl> {
        @Generated
        private TableauSiteBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauSiteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauSite build() {
            return new TableauSite(this);
        }
    }

    @Generated
    public static abstract class TableauSiteBuilder<C extends TableauSite, B extends TableauSiteBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<TableauProject> projects;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauSiteBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauSite instance, TableauSiteBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.projects(instance.projects == null ? Collections.emptySortedSet() : instance.projects);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B project(TableauProject project) {
            if (this.projects == null) {
                this.projects = new ArrayList();
            }
            this.projects.add(project);
            return (B)this.self();
        }

        @Generated
        public B projects(Collection<? extends TableauProject> projects) {
            if (projects == null) {
                throw new NullPointerException("projects cannot be null");
            }
            if (this.projects == null) {
                this.projects = new ArrayList();
            }
            this.projects.addAll(projects);
            return (B)this.self();
        }

        @Generated
        public B clearProjects() {
            if (this.projects != null) {
                this.projects.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauSite.TableauSiteBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", projects=" + this.projects + ")";
        }
    }
}

