/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauDashboard;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauWorkbook
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauWorkbook";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    SortedSet<TableauWorksheet> worksheets;
    @Attribute
    SortedSet<TableauDatasource> datasources;
    @Attribute
    TableauProject project;
    @Attribute
    SortedSet<TableauDashboard> dashboards;

    public static TableauWorkbook refByGuid(String guid) {
        return ((TableauWorkbookBuilder)TableauWorkbook.builder().guid(guid)).build();
    }

    public static TableauWorkbook refByQualifiedName(String qualifiedName) {
        return ((TableauWorkbookBuilder)TableauWorkbook.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauWorkbookBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauWorkbookBuilder)((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauWorkbookBuilder<?, ?> trimToRequired() {
        return TableauWorkbook.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauWorkbook retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauWorkbook) {
            return (TableauWorkbook)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauWorkbook.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauWorkbook retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauWorkbook) {
            return (TableauWorkbook)entity;
        }
        throw new NotFoundException("No TableauWorkbook found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauWorkbook removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauWorkbook)Asset.removeDescription(((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorkbook removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauWorkbook)Asset.removeUserDescription(((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorkbook removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauWorkbook)Asset.removeOwners(((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorkbook updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauWorkbook)Asset.updateCertificate(TableauWorkbook.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauWorkbook removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauWorkbook)Asset.removeCertificate(((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorkbook updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauWorkbook)Asset.updateAnnouncement(TableauWorkbook.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauWorkbook removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauWorkbook)Asset.removeAnnouncement(((TableauWorkbookBuilder)TableauWorkbook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauWorkbook replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorkbook)Asset.replaceTerms(TableauWorkbook.updater(qualifiedName, name), terms);
    }

    public static TableauWorkbook appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorkbook)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauWorkbook removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorkbook)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauWorkbook(TableauWorkbookBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauWorkbook.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectName = b.topLevelProjectName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        SortedSet<TableauWorksheet> worksheets = new TreeSet<TableauWorksheet>();
        if (b.worksheets != null) {
            worksheets.addAll(b.worksheets);
        }
        worksheets = Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
        SortedSet<TableauDatasource> datasources = new TreeSet<TableauDatasource>();
        if (b.datasources != null) {
            datasources.addAll(b.datasources);
        }
        datasources = Collections.unmodifiableSortedSet(datasources);
        this.datasources = datasources;
        this.project = b.project;
        SortedSet<TableauDashboard> dashboards = new TreeSet<TableauDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
    }

    @Generated
    public static TableauWorkbookBuilder<?, ?> builder() {
        return new TableauWorkbookBuilderImpl();
    }

    @Generated
    public TableauWorkbookBuilder<?, ?> toBuilder() {
        return new TableauWorkbookBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectName() {
        return this.topLevelProjectName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public SortedSet<TableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @Generated
    public SortedSet<TableauDatasource> getDatasources() {
        return this.datasources;
    }

    @Generated
    public TableauProject getProject() {
        return this.project;
    }

    @Generated
    public SortedSet<TableauDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectName(String topLevelProjectName) {
        this.topLevelProjectName = topLevelProjectName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setWorksheets(SortedSet<TableauWorksheet> worksheets) {
        this.worksheets = worksheets;
    }

    @Generated
    public void setDatasources(SortedSet<TableauDatasource> datasources) {
        this.datasources = datasources;
    }

    @Generated
    public void setProject(TableauProject project) {
        this.project = project;
    }

    @Generated
    public void setDashboards(SortedSet<TableauDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauWorkbook)) {
            return false;
        }
        TableauWorkbook other = (TableauWorkbook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectName = this.getTopLevelProjectName();
        String other$topLevelProjectName = other.getTopLevelProjectName();
        if (this$topLevelProjectName == null ? other$topLevelProjectName != null : !this$topLevelProjectName.equals(other$topLevelProjectName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        SortedSet<TableauWorksheet> this$worksheets = this.getWorksheets();
        SortedSet<TableauWorksheet> other$worksheets = other.getWorksheets();
        if (this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets)) {
            return false;
        }
        SortedSet<TableauDatasource> this$datasources = this.getDatasources();
        SortedSet<TableauDatasource> other$datasources = other.getDatasources();
        if (this$datasources == null ? other$datasources != null : !this$datasources.equals(other$datasources)) {
            return false;
        }
        TableauProject this$project = this.getProject();
        TableauProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        SortedSet<TableauDashboard> this$dashboards = this.getDashboards();
        SortedSet<TableauDashboard> other$dashboards = other.getDashboards();
        return !(this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauWorkbook;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectName = this.getTopLevelProjectName();
        result = result * 59 + ($topLevelProjectName == null ? 43 : $topLevelProjectName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        SortedSet<TableauWorksheet> $worksheets = this.getWorksheets();
        result = result * 59 + ($worksheets == null ? 43 : $worksheets.hashCode());
        SortedSet<TableauDatasource> $datasources = this.getDatasources();
        result = result * 59 + ($datasources == null ? 43 : $datasources.hashCode());
        TableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        SortedSet<TableauDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauWorkbookBuilderImpl
    extends TableauWorkbookBuilder<TableauWorkbook, TableauWorkbookBuilderImpl> {
        @Generated
        private TableauWorkbookBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauWorkbookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauWorkbook build() {
            return new TableauWorkbook(this);
        }
    }

    @Generated
    public static abstract class TableauWorkbookBuilder<C extends TableauWorkbook, B extends TableauWorkbookBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private ArrayList<TableauWorksheet> worksheets;
        @Generated
        private ArrayList<TableauDatasource> datasources;
        @Generated
        private TableauProject project;
        @Generated
        private ArrayList<TableauDashboard> dashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauWorkbookBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauWorkbook instance, TableauWorkbookBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectName(instance.topLevelProjectName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.worksheets(instance.worksheets == null ? Collections.emptySortedSet() : instance.worksheets);
            b.datasources(instance.datasources == null ? Collections.emptySortedSet() : instance.datasources);
            b.project(instance.project);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectName(String topLevelProjectName) {
            this.topLevelProjectName = topLevelProjectName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B worksheet(TableauWorksheet worksheet) {
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.add(worksheet);
            return (B)this.self();
        }

        @Generated
        public B worksheets(Collection<? extends TableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.addAll(worksheets);
            return (B)this.self();
        }

        @Generated
        public B clearWorksheets() {
            if (this.worksheets != null) {
                this.worksheets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasource(TableauDatasource datasource) {
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.add(datasource);
            return (B)this.self();
        }

        @Generated
        public B datasources(Collection<? extends TableauDatasource> datasources) {
            if (datasources == null) {
                throw new NullPointerException("datasources cannot be null");
            }
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.addAll(datasources);
            return (B)this.self();
        }

        @Generated
        public B clearDatasources() {
            if (this.datasources != null) {
                this.datasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(TableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B dashboard(TableauDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends TableauDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauWorkbook.TableauWorkbookBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectName=" + this.topLevelProjectName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", worksheets=" + this.worksheets + ", datasources=" + this.datasources + ", project=" + this.project + ", dashboards=" + this.dashboards + ")";
        }
    }
}

