/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Tableau;
import com.atlan.model.assets.TableauCalculatedField;
import com.atlan.model.assets.TableauDashboard;
import com.atlan.model.assets.TableauDatasourceField;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class TableauWorksheet
extends Tableau {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauWorksheet";
    String typeName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    TableauWorkbook workbook;
    @Attribute
    SortedSet<TableauDatasourceField> datasourceFields;
    @Attribute
    SortedSet<TableauCalculatedField> calculatedFields;
    @Attribute
    SortedSet<TableauDashboard> dashboards;

    public static TableauWorksheet refByGuid(String guid) {
        return ((TableauWorksheetBuilder)TableauWorksheet.builder().guid(guid)).build();
    }

    public static TableauWorksheet refByQualifiedName(String qualifiedName) {
        return ((TableauWorksheetBuilder)TableauWorksheet.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static TableauWorksheetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauWorksheetBuilder)((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected TableauWorksheetBuilder<?, ?> trimToRequired() {
        return TableauWorksheet.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauWorksheet retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof TableauWorksheet) {
            return (TableauWorksheet)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a TableauWorksheet.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static TableauWorksheet retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof TableauWorksheet) {
            return (TableauWorksheet)entity;
        }
        throw new NotFoundException("No TableauWorksheet found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static TableauWorksheet removeDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheet)Asset.removeDescription(((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorksheet removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheet)Asset.removeUserDescription(((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorksheet removeOwners(String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheet)Asset.removeOwners(((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorksheet updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (TableauWorksheet)Asset.updateCertificate(TableauWorksheet.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauWorksheet removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheet)Asset.removeCertificate(((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static TableauWorksheet updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauWorksheet)Asset.updateAnnouncement(TableauWorksheet.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauWorksheet removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheet)Asset.removeAnnouncement(((TableauWorksheetBuilder)TableauWorksheet.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static TableauWorksheet replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheet)Asset.replaceTerms(TableauWorksheet.updater(qualifiedName, name), terms);
    }

    public static TableauWorksheet appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheet)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static TableauWorksheet removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheet)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauWorksheet(TableauWorksheetBuilder<?, ?> b) {
        super((Tableau.TableauBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        this.typeName = b.typeName$set ? b.typeName$value : TableauWorksheet.$default$typeName();
        this.siteQualifiedName = b.siteQualifiedName;
        this.projectQualifiedName = b.projectQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.workbookQualifiedName = b.workbookQualifiedName;
        this.workbook = b.workbook;
        SortedSet<TableauDatasourceField> datasourceFields = new TreeSet<TableauDatasourceField>();
        if (b.datasourceFields != null) {
            datasourceFields.addAll(b.datasourceFields);
        }
        datasourceFields = Collections.unmodifiableSortedSet(datasourceFields);
        this.datasourceFields = datasourceFields;
        SortedSet<TableauCalculatedField> calculatedFields = new TreeSet<TableauCalculatedField>();
        if (b.calculatedFields != null) {
            calculatedFields.addAll(b.calculatedFields);
        }
        calculatedFields = Collections.unmodifiableSortedSet(calculatedFields);
        this.calculatedFields = calculatedFields;
        SortedSet<TableauDashboard> dashboards = new TreeSet<TableauDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
    }

    @Generated
    public static TableauWorksheetBuilder<?, ?> builder() {
        return new TableauWorksheetBuilderImpl();
    }

    @Generated
    public TableauWorksheetBuilder<?, ?> toBuilder() {
        return new TableauWorksheetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Generated
    public TableauWorkbook getWorkbook() {
        return this.workbook;
    }

    @Generated
    public SortedSet<TableauDatasourceField> getDatasourceFields() {
        return this.datasourceFields;
    }

    @Generated
    public SortedSet<TableauCalculatedField> getCalculatedFields() {
        return this.calculatedFields;
    }

    @Generated
    public SortedSet<TableauDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public void setSiteQualifiedName(String siteQualifiedName) {
        this.siteQualifiedName = siteQualifiedName;
    }

    @Generated
    public void setProjectQualifiedName(String projectQualifiedName) {
        this.projectQualifiedName = projectQualifiedName;
    }

    @Generated
    public void setTopLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
        this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
    }

    @Generated
    public void setProjectHierarchy(List<Map<String, String>> projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @Generated
    public void setWorkbookQualifiedName(String workbookQualifiedName) {
        this.workbookQualifiedName = workbookQualifiedName;
    }

    @Generated
    public void setWorkbook(TableauWorkbook workbook) {
        this.workbook = workbook;
    }

    @Generated
    public void setDatasourceFields(SortedSet<TableauDatasourceField> datasourceFields) {
        this.datasourceFields = datasourceFields;
    }

    @Generated
    public void setCalculatedFields(SortedSet<TableauCalculatedField> calculatedFields) {
        this.calculatedFields = calculatedFields;
    }

    @Generated
    public void setDashboards(SortedSet<TableauDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauWorksheet)) {
            return false;
        }
        TableauWorksheet other = (TableauWorksheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        TableauWorkbook this$workbook = this.getWorkbook();
        TableauWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !((Object)this$workbook).equals(other$workbook)) {
            return false;
        }
        SortedSet<TableauDatasourceField> this$datasourceFields = this.getDatasourceFields();
        SortedSet<TableauDatasourceField> other$datasourceFields = other.getDatasourceFields();
        if (this$datasourceFields == null ? other$datasourceFields != null : !this$datasourceFields.equals(other$datasourceFields)) {
            return false;
        }
        SortedSet<TableauCalculatedField> this$calculatedFields = this.getCalculatedFields();
        SortedSet<TableauCalculatedField> other$calculatedFields = other.getCalculatedFields();
        if (this$calculatedFields == null ? other$calculatedFields != null : !this$calculatedFields.equals(other$calculatedFields)) {
            return false;
        }
        SortedSet<TableauDashboard> this$dashboards = this.getDashboards();
        SortedSet<TableauDashboard> other$dashboards = other.getDashboards();
        return !(this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauWorksheet;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        TableauWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : ((Object)$workbook).hashCode());
        SortedSet<TableauDatasourceField> $datasourceFields = this.getDatasourceFields();
        result = result * 59 + ($datasourceFields == null ? 43 : $datasourceFields.hashCode());
        SortedSet<TableauCalculatedField> $calculatedFields = this.getCalculatedFields();
        result = result * 59 + ($calculatedFields == null ? 43 : $calculatedFields.hashCode());
        SortedSet<TableauDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class TableauWorksheetBuilderImpl
    extends TableauWorksheetBuilder<TableauWorksheet, TableauWorksheetBuilderImpl> {
        @Generated
        private TableauWorksheetBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauWorksheetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauWorksheet build() {
            return new TableauWorksheet(this);
        }
    }

    @Generated
    public static abstract class TableauWorksheetBuilder<C extends TableauWorksheet, B extends TableauWorksheetBuilder<C, B>>
    extends Tableau.TableauBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private TableauWorkbook workbook;
        @Generated
        private ArrayList<TableauDatasourceField> datasourceFields;
        @Generated
        private ArrayList<TableauCalculatedField> calculatedFields;
        @Generated
        private ArrayList<TableauDashboard> dashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauWorksheetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauWorksheet instance, TableauWorksheetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.workbook(instance.workbook);
            b.datasourceFields(instance.datasourceFields == null ? Collections.emptySortedSet() : instance.datasourceFields);
            b.calculatedFields(instance.calculatedFields == null ? Collections.emptySortedSet() : instance.calculatedFields);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbook(TableauWorkbook workbook) {
            this.workbook = workbook;
            return (B)this.self();
        }

        @Generated
        public B datasourceField(TableauDatasourceField datasourceField) {
            if (this.datasourceFields == null) {
                this.datasourceFields = new ArrayList();
            }
            this.datasourceFields.add(datasourceField);
            return (B)this.self();
        }

        @Generated
        public B datasourceFields(Collection<? extends TableauDatasourceField> datasourceFields) {
            if (datasourceFields == null) {
                throw new NullPointerException("datasourceFields cannot be null");
            }
            if (this.datasourceFields == null) {
                this.datasourceFields = new ArrayList();
            }
            this.datasourceFields.addAll(datasourceFields);
            return (B)this.self();
        }

        @Generated
        public B clearDatasourceFields() {
            if (this.datasourceFields != null) {
                this.datasourceFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B calculatedField(TableauCalculatedField calculatedField) {
            if (this.calculatedFields == null) {
                this.calculatedFields = new ArrayList();
            }
            this.calculatedFields.add(calculatedField);
            return (B)this.self();
        }

        @Generated
        public B calculatedFields(Collection<? extends TableauCalculatedField> calculatedFields) {
            if (calculatedFields == null) {
                throw new NullPointerException("calculatedFields cannot be null");
            }
            if (this.calculatedFields == null) {
                this.calculatedFields = new ArrayList();
            }
            this.calculatedFields.addAll(calculatedFields);
            return (B)this.self();
        }

        @Generated
        public B clearCalculatedFields() {
            if (this.calculatedFields != null) {
                this.calculatedFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dashboard(TableauDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends TableauDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauWorksheet.TableauWorksheetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", siteQualifiedName=" + this.siteQualifiedName + ", projectQualifiedName=" + this.projectQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", projectHierarchy=" + this.projectHierarchy + ", workbookQualifiedName=" + this.workbookQualifiedName + ", workbook=" + this.workbook + ", datasourceFields=" + this.datasourceFields + ", calculatedFields=" + this.calculatedFields + ", dashboards=" + this.dashboards + ")";
        }
    }
}

