/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import com.atlan.api.EntityBulkEndpoint;
import com.atlan.api.EntityGuidEndpoint;
import com.atlan.api.EntityUniqueAttributesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.Meaning;
import com.atlan.model.core.Classification;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.core.EntityMutationResponse;
import com.atlan.model.core.EntityResponse;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.Reference;
import com.atlan.serde.EntityDeserializer;
import com.atlan.serde.EntitySerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@JsonSerialize(using=EntitySerializer.class)
@JsonDeserialize(using=EntityDeserializer.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="typeName", defaultImpl=IndistinctAsset.class)
public abstract class Entity
extends Reference {
    @JsonIgnore
    transient Set<String> nullFields;
    Set<Classification> classifications;
    Map<String, CustomMetadataAttributes> customMetadataSets;
    AtlanStatus status;
    final String createdBy;
    final String updatedBy;
    final Long createTime;
    final Long updateTime;
    final String deleteHandler;
    Set<String> classificationNames;
    Boolean isIncomplete;
    Set<String> meaningNames;
    Set<Meaning> meanings;
    final Set<String> pendingTasks;

    public Set<String> getNullFields() {
        if (this.nullFields == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.nullFields);
    }

    public void addNullField(String fieldName) {
        if (this.nullFields == null) {
            this.nullFields = new LinkedHashSet<String>();
        }
        this.nullFields.add(fieldName);
    }

    public void removeCustomMetadata() {
        this.customMetadataSets = null;
    }

    public void removeClassifications() {
        this.classifications = null;
        this.classificationNames = null;
    }

    public EntityMutationResponse upsert() throws AtlanException {
        return EntityBulkEndpoint.upsert(this, false, false);
    }

    public EntityMutationResponse upsert(boolean replaceClassifications, boolean replaceCustomMetadata) throws AtlanException {
        return EntityBulkEndpoint.upsert(this, replaceClassifications, replaceCustomMetadata);
    }

    public static Entity retrieveFull(String guid) throws AtlanException {
        EntityResponse response = EntityGuidEndpoint.retrieve(guid, false, false);
        Entity entity = response.getEntity();
        if (entity != null) {
            entity.setCompleteObject();
        }
        return entity;
    }

    public static Entity retrieveMinimal(String guid) throws AtlanException {
        EntityResponse response = EntityGuidEndpoint.retrieve(guid, true, true);
        return response.getEntity();
    }

    protected static Entity retrieveFull(String typeName, String qualifiedName) throws AtlanException {
        EntityResponse response = EntityUniqueAttributesEndpoint.retrieve(typeName, qualifiedName, false, false);
        Entity entity = response.getEntity();
        if (entity != null) {
            entity.setCompleteObject();
        }
        return entity;
    }

    public static Entity retrieveMinimal(String typeName, String qualifiedName) throws AtlanException {
        EntityResponse response = EntityUniqueAttributesEndpoint.retrieve(typeName, qualifiedName, true, true);
        return response.getEntity();
    }

    public static EntityMutationResponse delete(String guid) throws AtlanException {
        return EntityBulkEndpoint.delete(guid, AtlanDeleteType.SOFT);
    }

    public static EntityMutationResponse purge(String guid) throws AtlanException {
        return EntityBulkEndpoint.delete(guid, AtlanDeleteType.HARD);
    }

    public static void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        EntityGuidEndpoint.updateCustomMetadataAttributes(guid, cmName, attributes);
    }

    public static void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        EntityGuidEndpoint.replaceCustomMetadata(guid, cmName, attributes);
    }

    public static void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        EntityGuidEndpoint.removeCustomMetadata(guid, cmName);
    }

    protected static void addClassifications(String typeName, String qualifiedName, List<String> classificationNames) throws AtlanException {
        EntityUniqueAttributesEndpoint.addClassifications(typeName, qualifiedName, classificationNames);
    }

    protected static void removeClassification(String typeName, String qualifiedName, String classificationName) throws AtlanException {
        EntityUniqueAttributesEndpoint.removeClassification(typeName, qualifiedName, classificationName, true);
    }

    @Generated
    protected Entity(EntityBuilder<?, ?> b) {
        super((Reference.ReferenceBuilder<?, ?>)b);
        Map<Object, Object> customMetadataSets;
        Set<Object> classifications;
        this.nullFields = b.nullFields;
        switch (b.classifications == null ? 0 : b.classifications.size()) {
            case 0: {
                classifications = Collections.emptySet();
                break;
            }
            case 1: {
                classifications = Collections.singleton(b.classifications.get(0));
                break;
            }
            default: {
                classifications = new LinkedHashSet(b.classifications.size() < 0x40000000 ? 1 + b.classifications.size() + (b.classifications.size() - 3) / 3 : Integer.MAX_VALUE);
                classifications.addAll(b.classifications);
                classifications = Collections.unmodifiableSet(classifications);
            }
        }
        this.classifications = classifications;
        switch (b.customMetadataSets$key == null ? 0 : b.customMetadataSets$key.size()) {
            case 0: {
                customMetadataSets = Collections.emptyMap();
                break;
            }
            case 1: {
                customMetadataSets = Collections.singletonMap(b.customMetadataSets$key.get(0), b.customMetadataSets$value.get(0));
                break;
            }
            default: {
                customMetadataSets = new LinkedHashMap(b.customMetadataSets$key.size() < 0x40000000 ? 1 + b.customMetadataSets$key.size() + (b.customMetadataSets$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.customMetadataSets$key.size(); ++$i) {
                    customMetadataSets.put(b.customMetadataSets$key.get($i), b.customMetadataSets$value.get($i));
                }
                customMetadataSets = Collections.unmodifiableMap(customMetadataSets);
            }
        }
        this.customMetadataSets = customMetadataSets;
        this.status = b.status;
        this.createdBy = b.createdBy;
        this.updatedBy = b.updatedBy;
        this.createTime = b.createTime;
        this.updateTime = b.updateTime;
        this.deleteHandler = b.deleteHandler;
        this.classificationNames = b.classificationNames;
        this.isIncomplete = b.isIncomplete;
        this.meaningNames = b.meaningNames;
        this.meanings = b.meanings;
        this.pendingTasks = b.pendingTasks;
    }

    @Generated
    public Set<Classification> getClassifications() {
        return this.classifications;
    }

    @Generated
    public Map<String, CustomMetadataAttributes> getCustomMetadataSets() {
        return this.customMetadataSets;
    }

    @Generated
    public AtlanStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getDeleteHandler() {
        return this.deleteHandler;
    }

    @Generated
    public Set<String> getClassificationNames() {
        return this.classificationNames;
    }

    @Generated
    public Boolean getIsIncomplete() {
        return this.isIncomplete;
    }

    @Generated
    public Set<String> getMeaningNames() {
        return this.meaningNames;
    }

    @Generated
    public Set<Meaning> getMeanings() {
        return this.meanings;
    }

    @Generated
    public Set<String> getPendingTasks() {
        return this.pendingTasks;
    }

    @JsonIgnore
    @Generated
    public void setNullFields(Set<String> nullFields) {
        this.nullFields = nullFields;
    }

    @Generated
    public void setClassifications(Set<Classification> classifications) {
        this.classifications = classifications;
    }

    @Generated
    public void setCustomMetadataSets(Map<String, CustomMetadataAttributes> customMetadataSets) {
        this.customMetadataSets = customMetadataSets;
    }

    @Generated
    public void setStatus(AtlanStatus status) {
        this.status = status;
    }

    @Generated
    public void setClassificationNames(Set<String> classificationNames) {
        this.classificationNames = classificationNames;
    }

    @Generated
    public void setIsIncomplete(Boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    @Generated
    public void setMeaningNames(Set<String> meaningNames) {
        this.meaningNames = meaningNames;
    }

    @Generated
    public void setMeanings(Set<Meaning> meanings) {
        this.meanings = meanings;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Boolean this$isIncomplete = this.getIsIncomplete();
        Boolean other$isIncomplete = other.getIsIncomplete();
        if (this$isIncomplete == null ? other$isIncomplete != null : !((Object)this$isIncomplete).equals(other$isIncomplete)) {
            return false;
        }
        Set<Classification> this$classifications = this.getClassifications();
        Set<Classification> other$classifications = other.getClassifications();
        if (this$classifications == null ? other$classifications != null : !((Object)this$classifications).equals(other$classifications)) {
            return false;
        }
        Map<String, CustomMetadataAttributes> this$customMetadataSets = this.getCustomMetadataSets();
        Map<String, CustomMetadataAttributes> other$customMetadataSets = other.getCustomMetadataSets();
        if (this$customMetadataSets == null ? other$customMetadataSets != null : !((Object)this$customMetadataSets).equals(other$customMetadataSets)) {
            return false;
        }
        AtlanStatus this$status = this.getStatus();
        AtlanStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String this$deleteHandler = this.getDeleteHandler();
        String other$deleteHandler = other.getDeleteHandler();
        if (this$deleteHandler == null ? other$deleteHandler != null : !this$deleteHandler.equals(other$deleteHandler)) {
            return false;
        }
        Set<String> this$classificationNames = this.getClassificationNames();
        Set<String> other$classificationNames = other.getClassificationNames();
        if (this$classificationNames == null ? other$classificationNames != null : !((Object)this$classificationNames).equals(other$classificationNames)) {
            return false;
        }
        Set<String> this$meaningNames = this.getMeaningNames();
        Set<String> other$meaningNames = other.getMeaningNames();
        if (this$meaningNames == null ? other$meaningNames != null : !((Object)this$meaningNames).equals(other$meaningNames)) {
            return false;
        }
        Set<Meaning> this$meanings = this.getMeanings();
        Set<Meaning> other$meanings = other.getMeanings();
        if (this$meanings == null ? other$meanings != null : !((Object)this$meanings).equals(other$meanings)) {
            return false;
        }
        Set<String> this$pendingTasks = this.getPendingTasks();
        Set<String> other$pendingTasks = other.getPendingTasks();
        return !(this$pendingTasks == null ? other$pendingTasks != null : !((Object)this$pendingTasks).equals(other$pendingTasks));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Boolean $isIncomplete = this.getIsIncomplete();
        result = result * 59 + ($isIncomplete == null ? 43 : ((Object)$isIncomplete).hashCode());
        Set<Classification> $classifications = this.getClassifications();
        result = result * 59 + ($classifications == null ? 43 : ((Object)$classifications).hashCode());
        Map<String, CustomMetadataAttributes> $customMetadataSets = this.getCustomMetadataSets();
        result = result * 59 + ($customMetadataSets == null ? 43 : ((Object)$customMetadataSets).hashCode());
        AtlanStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $deleteHandler = this.getDeleteHandler();
        result = result * 59 + ($deleteHandler == null ? 43 : $deleteHandler.hashCode());
        Set<String> $classificationNames = this.getClassificationNames();
        result = result * 59 + ($classificationNames == null ? 43 : ((Object)$classificationNames).hashCode());
        Set<String> $meaningNames = this.getMeaningNames();
        result = result * 59 + ($meaningNames == null ? 43 : ((Object)$meaningNames).hashCode());
        Set<Meaning> $meanings = this.getMeanings();
        result = result * 59 + ($meanings == null ? 43 : ((Object)$meanings).hashCode());
        Set<String> $pendingTasks = this.getPendingTasks();
        result = result * 59 + ($pendingTasks == null ? 43 : ((Object)$pendingTasks).hashCode());
        return result;
    }

    @Generated
    public static abstract class EntityBuilder<C extends Entity, B extends EntityBuilder<C, B>>
    extends Reference.ReferenceBuilder<C, B> {
        @Generated
        private Set<String> nullFields;
        @Generated
        private ArrayList<Classification> classifications;
        @Generated
        private ArrayList<String> customMetadataSets$key;
        @Generated
        private ArrayList<CustomMetadataAttributes> customMetadataSets$value;
        @Generated
        private AtlanStatus status;
        @Generated
        private String createdBy;
        @Generated
        private String updatedBy;
        @Generated
        private Long createTime;
        @Generated
        private Long updateTime;
        @Generated
        private String deleteHandler;
        @Generated
        private Set<String> classificationNames;
        @Generated
        private Boolean isIncomplete;
        @Generated
        private Set<String> meaningNames;
        @Generated
        private Set<Meaning> meanings;
        @Generated
        private Set<String> pendingTasks;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Entity instance, EntityBuilder<?, ?> b) {
            b.nullFields(instance.nullFields);
            b.classifications(instance.classifications == null ? Collections.emptySet() : instance.classifications);
            b.customMetadataSets(instance.customMetadataSets == null ? Collections.emptyMap() : instance.customMetadataSets);
            b.status(instance.status);
            b.createdBy(instance.createdBy);
            b.updatedBy(instance.updatedBy);
            b.createTime(instance.createTime);
            b.updateTime(instance.updateTime);
            b.deleteHandler(instance.deleteHandler);
            b.classificationNames(instance.classificationNames);
            b.isIncomplete(instance.isIncomplete);
            b.meaningNames(instance.meaningNames);
            b.meanings(instance.meanings);
            b.pendingTasks(instance.pendingTasks);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @JsonIgnore
        @Generated
        public B nullFields(Set<String> nullFields) {
            this.nullFields = nullFields;
            return (B)this.self();
        }

        @Generated
        public B classification(Classification classification) {
            if (this.classifications == null) {
                this.classifications = new ArrayList();
            }
            this.classifications.add(classification);
            return (B)this.self();
        }

        @Generated
        public B classifications(Collection<? extends Classification> classifications) {
            if (classifications == null) {
                throw new NullPointerException("classifications cannot be null");
            }
            if (this.classifications == null) {
                this.classifications = new ArrayList();
            }
            this.classifications.addAll(classifications);
            return (B)this.self();
        }

        @Generated
        public B clearClassifications() {
            if (this.classifications != null) {
                this.classifications.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customMetadata(String customMetadataKey, CustomMetadataAttributes customMetadataValue) {
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            this.customMetadataSets$key.add(customMetadataKey);
            this.customMetadataSets$value.add(customMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B customMetadataSets(Map<? extends String, ? extends CustomMetadataAttributes> customMetadataSets) {
            if (customMetadataSets == null) {
                throw new NullPointerException("customMetadataSets cannot be null");
            }
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new ArrayList();
                this.customMetadataSets$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends CustomMetadataAttributes> $lombokEntry : customMetadataSets.entrySet()) {
                this.customMetadataSets$key.add($lombokEntry.getKey());
                this.customMetadataSets$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCustomMetadataSets() {
            if (this.customMetadataSets$key != null) {
                this.customMetadataSets$key.clear();
                this.customMetadataSets$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B status(AtlanStatus status) {
            this.status = status;
            return (B)this.self();
        }

        @Generated
        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @Generated
        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Generated
        public B createTime(Long createTime) {
            this.createTime = createTime;
            return (B)this.self();
        }

        @Generated
        public B updateTime(Long updateTime) {
            this.updateTime = updateTime;
            return (B)this.self();
        }

        @Generated
        public B deleteHandler(String deleteHandler) {
            this.deleteHandler = deleteHandler;
            return (B)this.self();
        }

        @Generated
        public B classificationNames(Set<String> classificationNames) {
            this.classificationNames = classificationNames;
            return (B)this.self();
        }

        @Generated
        public B isIncomplete(Boolean isIncomplete) {
            this.isIncomplete = isIncomplete;
            return (B)this.self();
        }

        @Generated
        public B meaningNames(Set<String> meaningNames) {
            this.meaningNames = meaningNames;
            return (B)this.self();
        }

        @Generated
        public B meanings(Set<Meaning> meanings) {
            this.meanings = meanings;
            return (B)this.self();
        }

        @Generated
        public B pendingTasks(Set<String> pendingTasks) {
            this.pendingTasks = pendingTasks;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Entity.EntityBuilder(super=" + super.toString() + ", nullFields=" + this.nullFields + ", classifications=" + this.classifications + ", customMetadataSets$key=" + this.customMetadataSets$key + ", customMetadataSets$value=" + this.customMetadataSets$value + ", status=" + this.status + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", deleteHandler=" + this.deleteHandler + ", classificationNames=" + this.classificationNames + ", isIncomplete=" + this.isIncomplete + ", meaningNames=" + this.meaningNames + ", meanings=" + this.meanings + ", pendingTasks=" + this.pendingTasks + ")";
        }
    }
}

