/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.lineage.LineageGraph;
import com.atlan.model.lineage.LineageRelation;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class LineageResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    String baseEntityGuid;
    AtlanLineageDirection lineageDirection;
    Integer lineageDepth;
    Long limit;
    Long offset;
    Boolean hasMoreUpstreamVertices;
    Boolean hasMoreDownstreamVertices;
    @JsonProperty(value="guidEntityMap")
    Map<String, Entity> assetDetails;
    Set<LineageRelation> relations;
    @Deprecated
    Object childrenCounts;
    Object vertexChildrenInfo;
    @JsonIgnore
    private transient LineageGraph graph = null;

    @JsonIgnore
    private LineageGraph getGraph() throws InvalidRequestException {
        if (this.graph == null) {
            this.graph = new LineageGraph();
            for (LineageRelation relation : this.relations) {
                if (relation.isFullLink()) {
                    this.graph.addRelation(relation);
                    continue;
                }
                throw new InvalidRequestException("Lineage was retrieved using hideProcess = false. We do not provide a graph view in this case.", "hideProcess", "ATLAN-JAVA-CLIENT-400-050", 400, null);
            }
        }
        return this.graph;
    }

    @JsonIgnore
    public Set<String> getDownstreamEntityGuids() throws InvalidRequestException {
        return this.getDownstreamEntityGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Entity> getDownstreamEntities() throws InvalidRequestException {
        return this.getDownstreamEntities(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getDownstreamProcessGuids() throws InvalidRequestException {
        return this.getDownstreamProcessGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getUpstreamEntityGuids() throws InvalidRequestException {
        return this.getUpstreamEntityGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Entity> getUpstreamEntities() throws InvalidRequestException {
        return this.getUpstreamEntities(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getUpstreamProcessGuids() throws InvalidRequestException {
        return this.getUpstreamProcessGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getDownstreamEntityGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getDownstreamEntityGuids(guid);
    }

    @JsonIgnore
    public Set<String> getDownstreamProcessGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getDownstreamProcessGuids(guid);
    }

    @JsonIgnore
    public Set<String> getUpstreamEntityGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getUpstreamEntityGuids(guid);
    }

    @JsonIgnore
    public Set<String> getUpstreamProcessGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getUpstreamProcessGuids(guid);
    }

    @JsonIgnore
    public List<Entity> getDownstreamEntities(String guid) throws InvalidRequestException {
        ArrayList<Entity> downstream = new ArrayList<Entity>();
        Set<String> downstreamGuids = this.getDownstreamEntityGuids(guid);
        for (String downstreamGuid : downstreamGuids) {
            Entity one = this.assetDetails.get(downstreamGuid);
            if (one == null) continue;
            downstream.add(one);
        }
        return Collections.unmodifiableList(downstream);
    }

    @JsonIgnore
    public List<Entity> getUpstreamEntities(String guid) throws InvalidRequestException {
        ArrayList<Entity> upstream = new ArrayList<Entity>();
        Set<String> upstreamGuids = this.getUpstreamEntityGuids(guid);
        for (String upstreamGuid : upstreamGuids) {
            Entity one = this.assetDetails.get(upstreamGuid);
            if (one == null) continue;
            upstream.add(one);
        }
        return Collections.unmodifiableList(upstream);
    }

    @JsonIgnore
    public List<String> getAllDownstreamEntityGuidsDFS() throws InvalidRequestException {
        return this.getAllDownstreamEntityGuidsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<String> getAllDownstreamEntityGuidsDFS(String guid) throws InvalidRequestException {
        return this.getGraph().getAllDownstreamEntityGuidsDFS(guid);
    }

    @JsonIgnore
    public List<Entity> getAllDownstreamEntitiesDFS() throws InvalidRequestException {
        return this.getAllDownstreamEntitiesDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Entity> getAllDownstreamEntitiesDFS(String guid) throws InvalidRequestException {
        ArrayList<Entity> downstream = new ArrayList<Entity>();
        List<String> downstreamGuids = this.getAllDownstreamEntityGuidsDFS(guid);
        for (String downstreamGuid : downstreamGuids) {
            Entity one = this.assetDetails.get(downstreamGuid);
            if (one == null) continue;
            downstream.add(one);
        }
        return Collections.unmodifiableList(downstream);
    }

    @JsonIgnore
    public List<String> getAllUpstreamEntityGuidsDFS() throws InvalidRequestException {
        return this.getAllUpstreamEntityGuidsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<String> getAllUpstreamEntityGuidsDFS(String guid) throws InvalidRequestException {
        return this.getGraph().getAllUpstreamEntityGuidsDFS(guid);
    }

    @JsonIgnore
    public List<Entity> getAllUpstreamEntitiesDFS() throws InvalidRequestException {
        return this.getAllUpstreamEntitiesDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Entity> getAllUpstreamEntitiesDFS(String guid) throws InvalidRequestException {
        ArrayList<Entity> upstream = new ArrayList<Entity>();
        List<String> upstreamGuids = this.getAllUpstreamEntityGuidsDFS(guid);
        for (String upstreamGuid : upstreamGuids) {
            Entity one = this.assetDetails.get(upstreamGuid);
            if (one == null) continue;
            upstream.add(one);
        }
        return Collections.unmodifiableList(upstream);
    }

    @Generated
    public String getBaseEntityGuid() {
        return this.baseEntityGuid;
    }

    @Generated
    public AtlanLineageDirection getLineageDirection() {
        return this.lineageDirection;
    }

    @Generated
    public Integer getLineageDepth() {
        return this.lineageDepth;
    }

    @Generated
    public Long getLimit() {
        return this.limit;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public Boolean getHasMoreUpstreamVertices() {
        return this.hasMoreUpstreamVertices;
    }

    @Generated
    public Boolean getHasMoreDownstreamVertices() {
        return this.hasMoreDownstreamVertices;
    }

    @Generated
    public Map<String, Entity> getAssetDetails() {
        return this.assetDetails;
    }

    @Generated
    public void setBaseEntityGuid(String baseEntityGuid) {
        this.baseEntityGuid = baseEntityGuid;
    }

    @Generated
    public void setLineageDirection(AtlanLineageDirection lineageDirection) {
        this.lineageDirection = lineageDirection;
    }

    @Generated
    public void setLineageDepth(Integer lineageDepth) {
        this.lineageDepth = lineageDepth;
    }

    @Generated
    public void setLimit(Long limit) {
        this.limit = limit;
    }

    @Generated
    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Generated
    public void setHasMoreUpstreamVertices(Boolean hasMoreUpstreamVertices) {
        this.hasMoreUpstreamVertices = hasMoreUpstreamVertices;
    }

    @Generated
    public void setHasMoreDownstreamVertices(Boolean hasMoreDownstreamVertices) {
        this.hasMoreDownstreamVertices = hasMoreDownstreamVertices;
    }

    @JsonProperty(value="guidEntityMap")
    @Generated
    public void setAssetDetails(Map<String, Entity> assetDetails) {
        this.assetDetails = assetDetails;
    }

    @Generated
    public void setRelations(Set<LineageRelation> relations) {
        this.relations = relations;
    }

    @Deprecated
    @Generated
    public void setChildrenCounts(Object childrenCounts) {
        this.childrenCounts = childrenCounts;
    }

    @Generated
    public void setVertexChildrenInfo(Object vertexChildrenInfo) {
        this.vertexChildrenInfo = vertexChildrenInfo;
    }

    @JsonIgnore
    @Generated
    public void setGraph(LineageGraph graph) {
        this.graph = graph;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageResponse)) {
            return false;
        }
        LineageResponse other = (LineageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lineageDepth = this.getLineageDepth();
        Integer other$lineageDepth = other.getLineageDepth();
        if (this$lineageDepth == null ? other$lineageDepth != null : !((Object)this$lineageDepth).equals(other$lineageDepth)) {
            return false;
        }
        Long this$limit = this.getLimit();
        Long other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Boolean this$hasMoreUpstreamVertices = this.getHasMoreUpstreamVertices();
        Boolean other$hasMoreUpstreamVertices = other.getHasMoreUpstreamVertices();
        if (this$hasMoreUpstreamVertices == null ? other$hasMoreUpstreamVertices != null : !((Object)this$hasMoreUpstreamVertices).equals(other$hasMoreUpstreamVertices)) {
            return false;
        }
        Boolean this$hasMoreDownstreamVertices = this.getHasMoreDownstreamVertices();
        Boolean other$hasMoreDownstreamVertices = other.getHasMoreDownstreamVertices();
        if (this$hasMoreDownstreamVertices == null ? other$hasMoreDownstreamVertices != null : !((Object)this$hasMoreDownstreamVertices).equals(other$hasMoreDownstreamVertices)) {
            return false;
        }
        String this$baseEntityGuid = this.getBaseEntityGuid();
        String other$baseEntityGuid = other.getBaseEntityGuid();
        if (this$baseEntityGuid == null ? other$baseEntityGuid != null : !this$baseEntityGuid.equals(other$baseEntityGuid)) {
            return false;
        }
        AtlanLineageDirection this$lineageDirection = this.getLineageDirection();
        AtlanLineageDirection other$lineageDirection = other.getLineageDirection();
        if (this$lineageDirection == null ? other$lineageDirection != null : !this$lineageDirection.equals(other$lineageDirection)) {
            return false;
        }
        Map<String, Entity> this$assetDetails = this.getAssetDetails();
        Map<String, Entity> other$assetDetails = other.getAssetDetails();
        if (this$assetDetails == null ? other$assetDetails != null : !((Object)this$assetDetails).equals(other$assetDetails)) {
            return false;
        }
        Set<LineageRelation> this$relations = this.getRelations();
        Set<LineageRelation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        Object this$childrenCounts = this.getChildrenCounts();
        Object other$childrenCounts = other.getChildrenCounts();
        if (this$childrenCounts == null ? other$childrenCounts != null : !this$childrenCounts.equals(other$childrenCounts)) {
            return false;
        }
        Object this$vertexChildrenInfo = this.getVertexChildrenInfo();
        Object other$vertexChildrenInfo = other.getVertexChildrenInfo();
        return !(this$vertexChildrenInfo == null ? other$vertexChildrenInfo != null : !this$vertexChildrenInfo.equals(other$vertexChildrenInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lineageDepth = this.getLineageDepth();
        result = result * 59 + ($lineageDepth == null ? 43 : ((Object)$lineageDepth).hashCode());
        Long $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Boolean $hasMoreUpstreamVertices = this.getHasMoreUpstreamVertices();
        result = result * 59 + ($hasMoreUpstreamVertices == null ? 43 : ((Object)$hasMoreUpstreamVertices).hashCode());
        Boolean $hasMoreDownstreamVertices = this.getHasMoreDownstreamVertices();
        result = result * 59 + ($hasMoreDownstreamVertices == null ? 43 : ((Object)$hasMoreDownstreamVertices).hashCode());
        String $baseEntityGuid = this.getBaseEntityGuid();
        result = result * 59 + ($baseEntityGuid == null ? 43 : $baseEntityGuid.hashCode());
        AtlanLineageDirection $lineageDirection = this.getLineageDirection();
        result = result * 59 + ($lineageDirection == null ? 43 : $lineageDirection.hashCode());
        Map<String, Entity> $assetDetails = this.getAssetDetails();
        result = result * 59 + ($assetDetails == null ? 43 : ((Object)$assetDetails).hashCode());
        Set<LineageRelation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        Object $childrenCounts = this.getChildrenCounts();
        result = result * 59 + ($childrenCounts == null ? 43 : $childrenCounts.hashCode());
        Object $vertexChildrenInfo = this.getVertexChildrenInfo();
        result = result * 59 + ($vertexChildrenInfo == null ? 43 : $vertexChildrenInfo.hashCode());
        return result;
    }

    @Generated
    private Set<LineageRelation> getRelations() {
        return this.relations;
    }

    @Deprecated
    @Generated
    private Object getChildrenCounts() {
        return this.childrenCounts;
    }

    @Generated
    private Object getVertexChildrenInfo() {
        return this.vertexChildrenInfo;
    }
}

