/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTaskArguments;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbtCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-dbt";

    public static Workflow mtCloudAuth(String connectionName, String apiToken) throws AtlanException {
        return DbtCrawler.mtCloudAuth(connectionName, apiToken, List.of(RoleCache.getIdForName("$admin")), null, null, null, null, null);
    }

    public static Workflow mtCloudAuth(String connectionName, String apiToken, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, Map<String, List<String>> includeAssets, Map<String, List<String>> excludeAssets, String connectionQualifiedName) throws InvalidRequestException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.DBT, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "atlan-dbt-" + epoch + "-0");
        credentialBody.put("host", "https://cloud.getdbt.com");
        credentialBody.put("port", 443);
        credentialBody.put("authType", "token");
        credentialBody.put("username", "");
        credentialBody.put("password", apiToken);
        credentialBody.put("extra", Collections.emptyMap());
        credentialBody.put("connectorConfigName", "atlan-connectors-dbt");
        Map<String, Map<String, Map<String, String>>> toInclude = DbtCrawler.buildDbtCloudFilter(includeAssets);
        Map<String, Map<String, Map<String, String>>> toExclude = DbtCrawler.buildDbtCloudFilter(excludeAssets);
        Object argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)WorkflowTaskArguments.builder().parameter(NameValuePair.of("extraction-method", "api"))).parameter(NameValuePair.of("deployment-type", "multi"))).parameter(NameValuePair.of("core-extraction-method", "s3"))).parameter(NameValuePair.of("api-credential-guid", "{{credentialGuid}}"));
        try {
            argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).parameter(NameValuePair.of("include-filter", Serde.mapper.writeValueAsString(toInclude)));
            argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).parameter(NameValuePair.of("exclude-filter", Serde.mapper.writeValueAsString(toExclude)));
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Unable to translate the provided include/exclude asset filters into JSON.", "includeAssets/excludeAssets", "ATLAN_JAVA_CLIENT-400-601", 400, e);
        }
        argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).parameter(NameValuePair.of("include-filter-core", "*"))).parameter(NameValuePair.of("exclude-filter-core", "*"));
        if (connectionQualifiedName != null) {
            argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).parameter(NameValuePair.of("connection-qualified-name", connectionQualifiedName));
        }
        String runName = "atlan-dbt-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "dbt")).label("orchestration.atlan.com/sourceCategory", "enricher")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hdbt")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6335824578705")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://www.getdbt.com/ui/img/social/apple-touch-icon-149x149.png")).annotation("orchestration.atlan.com/logo", "https://www.getdbt.com/ui/img/social/apple-touch-icon-149x149.png")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/dbt")).annotation("orchestration.atlan.com/name", "dbt Enrichment")).annotation("orchestration.atlan.com/usecase", "crawling,enrichment")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Scan all your dbt models and enrich the corresponding assets on Atlan.")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/dbt")).annotation("package.argoproj.io/keywords", "[\"connector\",\"crawler\",\"dbt\"]")).annotation("package.argoproj.io/name", "@atlan/dbt")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", runName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowTaskArguments)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

