/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTaskArguments;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FivetranCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-fivetran";

    public static Workflow directApiAuth(String connectionName, String apiKey, String apiSecret) throws AtlanException {
        return FivetranCrawler.directApiAuth(connectionName, apiKey, apiSecret, List.of(RoleCache.getIdForName("$admin")), null, null);
    }

    public static Workflow directApiAuth(String connectionName, String apiKey, String apiSecret, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws InvalidRequestException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.FIVETRAN, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://res.cloudinary.com/crunchbase-production/image/upload/c_lpad,f_auto,q_auto:eco,dpr_1/mmhosuxvz2msbiieekl3")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "atlan-fivetran-" + epoch + "-0");
        credentialBody.put("host", "https://api.fivetran.com");
        credentialBody.put("port", 443);
        credentialBody.put("authType", "api");
        credentialBody.put("username", apiKey);
        credentialBody.put("password", apiSecret);
        credentialBody.put("extra", Collections.emptyMap());
        credentialBody.put("connectorConfigName", "atlan-connectors-fivetran");
        Object argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)WorkflowTaskArguments.builder().parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("connection")).value(connection.toJson())).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("credential-guid")).value("{{credentialGuid}}")).build());
        String runName = "atlan-fivetran-" + epoch;
        String atlanName = "atlan-fivetran-default-fivetran-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "fivetran")).label("orchestration.atlan.com/sourceCategory", "elt")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hfivetran")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-fivetran-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/8427123935121")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://res.cloudinary.com/crunchbase-production/image/upload/c_lpad,f_auto,q_auto:eco,dpr_1/mmhosuxvz2msbiieekl3")).annotation("orchestration.atlan.com/logo", "https://alternative.me/media/256/fivetran-icon-qfxkppdpdx2oh4r9-c.png")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/fivetran")).annotation("orchestration.atlan.com/name", "Fivetran Enrichment")).annotation("orchestration.atlan.com/usecase", "crawling,enrichment")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Enrich known assets associated with Fivetran Connectors with column-level lineage.  Requires access to Fivetran's Metadata API.")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/fivetran")).annotation("package.argoproj.io/keywords", "[\"connector\",\"elt\",\"fivetran\",\"lineage\"]")).annotation("package.argoproj.io/name", "@atlan/fivetran")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowTaskArguments)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

