/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTaskArguments;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LookerCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-looker";

    public static Workflow directResourceOwner(String connectionName, String hostname, String clientId, String clientSecret) throws AtlanException {
        return LookerCrawler.directResourceOwner(connectionName, hostname, 443, clientId, clientSecret, null, null, List.of(RoleCache.getIdForName("$admin")), null, null, null, null, null, null);
    }

    public static Workflow directResourceOwner(String connectionName, String hostname, int port, String clientId, String clientSecret, String privateKey, String privateKeyPassphrase, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, List<String> includeFolders, List<String> includeProjects, List<String> excludeFolders, List<String> excludeProjects) throws InvalidRequestException {
        Object argsBuilder;
        boolean fieldLevelLineage = privateKey != null && !privateKey.equals("");
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.LOOKER, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://www.pngrepo.com/png/354012/512/looker-icon.png")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, String> extraMap = new HashMap<String, String>();
        if (fieldLevelLineage) {
            extraMap.put("ssh_private_key", privateKey);
            extraMap.put("passphrase", privateKeyPassphrase);
        }
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-looker-" + epoch + "-0");
        credentialBody.put("host", hostname);
        credentialBody.put("port", port);
        credentialBody.put("authType", "resource_owner");
        credentialBody.put("username", clientId);
        credentialBody.put("password", clientSecret);
        credentialBody.put("extra", extraMap);
        credentialBody.put("connectorConfigName", "atlan-connectors-looker");
        Map<String, Map<String, String>> toIncludeFolders = LookerCrawler.buildFlatFilter(includeFolders);
        Map<String, Map<String, String>> toExcludeFolders = LookerCrawler.buildFlatFilter(excludeFolders);
        Map<String, Map<String, String>> toIncludeProjects = LookerCrawler.buildFlatFilter(includeProjects);
        Map<String, Map<String, String>> toExcludeProjects = LookerCrawler.buildFlatFilter(excludeProjects);
        try {
            argsBuilder = ((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)WorkflowTaskArguments.builder().parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("credential-guid")).value("{{credentialGuid}}")).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("connection")).value(connection.toJson())).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("include-folders")).value(Serde.allInclusiveMapper.writeValueAsString(toIncludeFolders))).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("exclude-folders")).value(Serde.allInclusiveMapper.writeValueAsString(toExcludeFolders))).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("include-projects")).value(Serde.allInclusiveMapper.writeValueAsString(toIncludeProjects))).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("exclude-projects")).value(Serde.allInclusiveMapper.writeValueAsString(toExcludeProjects))).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("use-field-level-lineage")).value("" + fieldLevelLineage)).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("extraction-method")).value("direct")).build());
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Unable to translate the provided include/exclude asset filters into JSON.", "includeAssets/excludeAssets", "ATLAN_JAVA_CLIENT-400-600", 400, e);
        }
        String atlanName = "atlan-looker-default-looker-" + epoch;
        String runName = "atlan-looker-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "looker")).label("orchestration.atlan.com/sourceCategory", "bi")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hlooker")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-looker-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6330214610193")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://www.pngrepo.com/png/354012/512/looker-icon.png")).annotation("orchestration.atlan.com/logo", "https://looker.com/assets/img/images/logos/looker.svg")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/looker")).annotation("orchestration.atlan.com/name", "Looker Assets")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl Looker assets and publish to Atlan for discovery")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/looker")).annotation("package.argoproj.io/keywords", "[\"looker\",\"bi\",\"connector\",\"crawler\",\"lookml\"]")).annotation("package.argoproj.io/name", "@atlan/looker")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowTaskArguments)((WorkflowTaskArguments.WorkflowTaskArgumentsBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

