/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.relations;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.AuditDetail;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Comparator;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=ReferenceBuilderImpl.class)
public class Reference
extends AtlanObject
implements Comparable<Reference>,
AuditDetail {
    private static final long serialVersionUID = 2L;
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<UniqueAttributes> uniqueAttrsComparator = Comparator.comparing(UniqueAttributes::getQualifiedName, stringComparator).thenComparing(UniqueAttributes::getAwsArn, stringComparator);
    private static final Comparator<Reference> referenceComparator = Comparator.comparing(Reference::getRelationshipGuid, stringComparator).thenComparing(Reference::getGuid, stringComparator).thenComparing(Reference::getUniqueAttributes, Comparator.nullsFirst(uniqueAttrsComparator));
    @JsonIgnore
    transient boolean completeObject;
    String typeName;
    String guid;
    String displayText;
    String entityStatus;
    String relationshipType;
    String relationshipGuid;
    AtlanStatus relationshipStatus;
    Map<String, Object> relationshipAttributes;
    UniqueAttributes uniqueAttributes;

    public static Reference to(String typeName, String guid) {
        return ((ReferenceBuilder)((ReferenceBuilder)Reference.builder().typeName(typeName)).guid(guid)).build();
    }

    public static Reference by(String typeName, String qualifiedName) {
        return ((ReferenceBuilder)((ReferenceBuilder)Reference.builder().typeName(typeName)).uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public boolean isComplete() {
        return this.completeObject;
    }

    @JsonIgnore
    protected void setCompleteObject() {
        this.completeObject = true;
    }

    @JsonIgnore
    public boolean isValidReferenceByGuid() {
        return this.getTypeName() != null && this.getGuid() != null;
    }

    @JsonIgnore
    public boolean isValidReferenceByQualifiedName() {
        return this.getTypeName() != null && this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null;
    }

    @JsonIgnore
    public boolean isValidReference() {
        return this.isValidReferenceByGuid() || this.isValidReferenceByQualifiedName();
    }

    @Override
    public int compareTo(Reference o) {
        return referenceComparator.compare(this, o);
    }

    @Generated
    private static boolean $default$completeObject() {
        return false;
    }

    @Generated
    protected Reference(ReferenceBuilder<?, ?> b) {
        super(b);
        this.completeObject = b.completeObject$set ? b.completeObject$value : Reference.$default$completeObject();
        this.typeName = b.typeName;
        this.guid = b.guid;
        this.displayText = b.displayText;
        this.entityStatus = b.entityStatus;
        this.relationshipType = b.relationshipType;
        this.relationshipGuid = b.relationshipGuid;
        this.relationshipStatus = b.relationshipStatus;
        this.relationshipAttributes = b.relationshipAttributes;
        this.uniqueAttributes = b.uniqueAttributes;
    }

    @Generated
    public static ReferenceBuilder<?, ?> builder() {
        return new ReferenceBuilderImpl();
    }

    @Generated
    public ReferenceBuilder<?, ?> toBuilder() {
        return new ReferenceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean getCompleteObject() {
        return this.completeObject;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getGuid() {
        return this.guid;
    }

    @Generated
    public String getDisplayText() {
        return this.displayText;
    }

    @Generated
    public String getEntityStatus() {
        return this.entityStatus;
    }

    @Generated
    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Generated
    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    @Generated
    public AtlanStatus getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Generated
    public Map<String, Object> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    @Generated
    public UniqueAttributes getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Generated
    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    @Generated
    public void setEntityStatus(String entityStatus) {
        this.entityStatus = entityStatus;
    }

    @Generated
    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Generated
    public void setRelationshipGuid(String relationshipGuid) {
        this.relationshipGuid = relationshipGuid;
    }

    @Generated
    public void setRelationshipStatus(AtlanStatus relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
    }

    @Generated
    public void setRelationshipAttributes(Map<String, Object> relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
    }

    @Generated
    public void setUniqueAttributes(UniqueAttributes uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
            return false;
        }
        String this$displayText = this.getDisplayText();
        String other$displayText = other.getDisplayText();
        if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) {
            return false;
        }
        String this$entityStatus = this.getEntityStatus();
        String other$entityStatus = other.getEntityStatus();
        if (this$entityStatus == null ? other$entityStatus != null : !this$entityStatus.equals(other$entityStatus)) {
            return false;
        }
        String this$relationshipType = this.getRelationshipType();
        String other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !this$relationshipType.equals(other$relationshipType)) {
            return false;
        }
        String this$relationshipGuid = this.getRelationshipGuid();
        String other$relationshipGuid = other.getRelationshipGuid();
        if (this$relationshipGuid == null ? other$relationshipGuid != null : !this$relationshipGuid.equals(other$relationshipGuid)) {
            return false;
        }
        AtlanStatus this$relationshipStatus = this.getRelationshipStatus();
        AtlanStatus other$relationshipStatus = other.getRelationshipStatus();
        if (this$relationshipStatus == null ? other$relationshipStatus != null : !this$relationshipStatus.equals(other$relationshipStatus)) {
            return false;
        }
        Map<String, Object> this$relationshipAttributes = this.getRelationshipAttributes();
        Map<String, Object> other$relationshipAttributes = other.getRelationshipAttributes();
        if (this$relationshipAttributes == null ? other$relationshipAttributes != null : !((Object)this$relationshipAttributes).equals(other$relationshipAttributes)) {
            return false;
        }
        UniqueAttributes this$uniqueAttributes = this.getUniqueAttributes();
        UniqueAttributes other$uniqueAttributes = other.getUniqueAttributes();
        return !(this$uniqueAttributes == null ? other$uniqueAttributes != null : !((Object)this$uniqueAttributes).equals(other$uniqueAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reference;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        String $displayText = this.getDisplayText();
        result = result * 59 + ($displayText == null ? 43 : $displayText.hashCode());
        String $entityStatus = this.getEntityStatus();
        result = result * 59 + ($entityStatus == null ? 43 : $entityStatus.hashCode());
        String $relationshipType = this.getRelationshipType();
        result = result * 59 + ($relationshipType == null ? 43 : $relationshipType.hashCode());
        String $relationshipGuid = this.getRelationshipGuid();
        result = result * 59 + ($relationshipGuid == null ? 43 : $relationshipGuid.hashCode());
        AtlanStatus $relationshipStatus = this.getRelationshipStatus();
        result = result * 59 + ($relationshipStatus == null ? 43 : $relationshipStatus.hashCode());
        Map<String, Object> $relationshipAttributes = this.getRelationshipAttributes();
        result = result * 59 + ($relationshipAttributes == null ? 43 : ((Object)$relationshipAttributes).hashCode());
        UniqueAttributes $uniqueAttributes = this.getUniqueAttributes();
        result = result * 59 + ($uniqueAttributes == null ? 43 : ((Object)$uniqueAttributes).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ReferenceBuilderImpl
    extends ReferenceBuilder<Reference, ReferenceBuilderImpl> {
        @Generated
        private ReferenceBuilderImpl() {
        }

        @Override
        @Generated
        protected ReferenceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Reference build() {
            return new Reference(this);
        }
    }

    @Generated
    public static abstract class ReferenceBuilder<C extends Reference, B extends ReferenceBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private boolean completeObject$set;
        @Generated
        private boolean completeObject$value;
        @Generated
        private String typeName;
        @Generated
        private String guid;
        @Generated
        private String displayText;
        @Generated
        private String entityStatus;
        @Generated
        private String relationshipType;
        @Generated
        private String relationshipGuid;
        @Generated
        private AtlanStatus relationshipStatus;
        @Generated
        private Map<String, Object> relationshipAttributes;
        @Generated
        private UniqueAttributes uniqueAttributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Reference instance, ReferenceBuilder<?, ?> b) {
            b.completeObject(instance.completeObject);
            b.typeName(instance.typeName);
            b.guid(instance.guid);
            b.displayText(instance.displayText);
            b.entityStatus(instance.entityStatus);
            b.relationshipType(instance.relationshipType);
            b.relationshipGuid(instance.relationshipGuid);
            b.relationshipStatus(instance.relationshipStatus);
            b.relationshipAttributes(instance.relationshipAttributes);
            b.uniqueAttributes(instance.uniqueAttributes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @JsonIgnore
        @Generated
        public B completeObject(boolean completeObject) {
            this.completeObject$value = completeObject;
            this.completeObject$set = true;
            return (B)this.self();
        }

        @Generated
        public B typeName(String typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        @Generated
        public B guid(String guid) {
            this.guid = guid;
            return (B)this.self();
        }

        @Generated
        public B displayText(String displayText) {
            this.displayText = displayText;
            return (B)this.self();
        }

        @Generated
        public B entityStatus(String entityStatus) {
            this.entityStatus = entityStatus;
            return (B)this.self();
        }

        @Generated
        public B relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return (B)this.self();
        }

        @Generated
        public B relationshipGuid(String relationshipGuid) {
            this.relationshipGuid = relationshipGuid;
            return (B)this.self();
        }

        @Generated
        public B relationshipStatus(AtlanStatus relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return (B)this.self();
        }

        @Generated
        public B relationshipAttributes(Map<String, Object> relationshipAttributes) {
            this.relationshipAttributes = relationshipAttributes;
            return (B)this.self();
        }

        @Generated
        public B uniqueAttributes(UniqueAttributes uniqueAttributes) {
            this.uniqueAttributes = uniqueAttributes;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Reference.ReferenceBuilder(super=" + super.toString() + ", completeObject$value=" + this.completeObject$value + ", typeName=" + this.typeName + ", guid=" + this.guid + ", displayText=" + this.displayText + ", entityStatus=" + this.entityStatus + ", relationshipType=" + this.relationshipType + ", relationshipGuid=" + this.relationshipGuid + ", relationshipStatus=" + this.relationshipStatus + ", relationshipAttributes=" + this.relationshipAttributes + ", uniqueAttributes=" + this.uniqueAttributes + ")";
        }
    }
}

